/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.dao.impl;

import in.serosoft.cb.dao.SearchTableDAO;
import in.serosoft.cb.dao.impl.CBGenericDAOImpl;
import in.serosoft.cb.entity.SearchTable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="searchTableDAO")
public class SearchTableDAOImpl
extends CBGenericDAOImpl<SearchTable, Long>
implements SearchTableDAO {
    public SearchTableDAOImpl() {
        super(SearchTable.class);
    }

    @Override
    public SearchTable findSearchTableId(String searchTableName) {
        Criteria criteria = this.getCriteria(SearchTable.class);
        criteria.add(Restrictions.eq("dbTableName", searchTableName));
        SearchTable searchTable = (SearchTable)criteria.uniqueResult();
        return searchTable;
    }

    @Override
    public List<SearchTable> findAllSearchTables() {
        Criteria criteria = this.getCriteria(SearchTable.class);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<SearchTable> searchTables = this.executeCriteria(criteria);
        return searchTables;
    }

    @Override
    public Long findSearchTableIdByTableName(String tableName) {
        Criteria criteria = this.getCriteria();
        criteria.setProjection(Projections.property("id"));
        criteria.add(Restrictions.eq("dbTableName", tableName));
        return (Long)criteria.uniqueResult();
    }
}

