/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.imagecompress;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class Compression {
    private static String inputFilePath = "C:\\Pictures";
    private static String outputFilePath = "C:\\Pictures";

    public static void main(String[] args) throws IOException {
        File[] images;
        for (File f : images = new File(inputFilePath).listFiles()) {
            String name;
            String fileName;
            if (f.isDirectory() || (fileName = (name = f.getName()).substring(0, name.lastIndexOf(46))).contains("_icon")) continue;
            BufferedImage image = ImageIO.read(f);
            image = Compression.resize(image, 100, 100);
            File compressedImageFile = new File(outputFilePath + "\\" + fileName + "_icon.jpg");
            FileOutputStream os = new FileOutputStream(compressedImageFile);
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
            ImageWriter writer = writers.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(os);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(0.5f);
            writer.write(null, new IIOImage(image, null, null), param);
            ((OutputStream)os).close();
            ios.close();
            writer.dispose();
        }
    }

    private static BufferedImage resize(BufferedImage image, int height, int width) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

