/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.processor.RequestProcessor;

@ThreadSafe
public class Connection<NodeType extends Node, WorkspaceType extends Workspace>
implements RepositoryConnection {
    private final BaseRepositorySource source;
    private final Repository<NodeType, WorkspaceType> repository;

    public Connection(BaseRepositorySource source, Repository<NodeType, WorkspaceType> repository) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    @Override
    public String getSourceName() {
        return this.source.getName();
    }

    @Override
    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    @Override
    public XAResource getXAResource() {
        return null;
    }

    @Override
    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Logger logger2 = context.getLogger(this.getClass());
        Stopwatch sw = null;
        if (logger2.isTraceEnabled()) {
            sw = new Stopwatch();
            sw.start();
        }
        boolean commit = true;
        Transaction<NodeType, WorkspaceType> txn = this.repository.startTransaction(context, request.isReadOnly());
        RequestProcessor processor = this.repository.createRequestProcessor(txn);
        try {
            processor.process(request);
            if (request.hasError() && !request.isReadOnly()) {
                commit = false;
            }
        }
        catch (Throwable error) {
            commit = false;
            error.printStackTrace();
        }
        finally {
            try {
                processor.close();
            }
            finally {
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    commitOrRollbackError.printStackTrace();
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
            }
        }
        if (logger2.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger2.trace("MapRepositoryConnection.execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" " + this.repository.getClass().getSimpleName();
    }
}

