/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class RemovePropertyRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location from;
    private final String workspaceName;
    private final Name propertyName;
    private Location actualLocation;

    public RemovePropertyRequest(Location from, String workspaceName, Name propertyName) {
        CheckArg.isNotNull(from, "from");
        CheckArg.isNotNull(propertyName, "propertyName");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.from = from;
        this.propertyName = propertyName;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location from() {
        return this.from;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name propertyName() {
        return this.propertyName;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actual, "actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.from.hasPath() && this.from.getPath().isAtOrBelow(path);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute(this.from, this.workspaceName, this.propertyName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            RemovePropertyRequest that = (RemovePropertyRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.propertyName().equals(that.propertyName())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.from;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    public String toString() {
        return "remove property " + this.propertyName() + " from " + this.from() + " in the \"" + this.workspaceName + "\" workspace";
    }

    @Override
    public RemovePropertyRequest clone() {
        RemovePropertyRequest request = new RemovePropertyRequest(this.actualLocation != null ? this.actualLocation : this.from, this.workspaceName, this.propertyName);
        request.setActualLocationOfNode(this.actualLocation);
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.REMOVE_PROPERTY;
    }
}

