 SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `acad_loc_purpose_setting_history`;

CREATE TABLE `acad_loc_purpose_setting_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `purposeSettingValue` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationPurposeId` bigint(20) DEFAULT NULL,
  `entitySettingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `acad_loc_purpose_setting_history` */

/*Table structure for table `academia_job_detail_logs_history` */

DROP TABLE IF EXISTS `academia_job_detail_logs_history`;

CREATE TABLE `academia_job_detail_logs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `error` varchar(255) DEFAULT NULL,
  `jobName` varchar(255) DEFAULT NULL,
  `startTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academia_job_detail_logs_history` */

/*Table structure for table `academies_history` */

DROP TABLE IF EXISTS `academies_history`;

CREATE TABLE `academies_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `academicTypeCode` varchar(50) DEFAULT NULL,
  `academyName` varchar(100) DEFAULT NULL,
  `shortCode` varchar(10) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `organizationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academies_history` */

/*Table structure for table `academy_cf_data_history` */

DROP TABLE IF EXISTS `academy_cf_data_history`;

CREATE TABLE `academy_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `academyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academy_cf_data_history` */

/*Table structure for table `academy_location_history` */

DROP TABLE IF EXISTS `academy_location_history`;

CREATE TABLE `academy_location_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `academyName` varchar(100) DEFAULT NULL,
  `currentTransactionDate` date DEFAULT NULL,
  `locationName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyId` bigint(20) DEFAULT NULL,
  `locationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academy_location_history` */

/*Table structure for table `academy_location_purpose_history` */

DROP TABLE IF EXISTS `academy_location_purpose_history`;

CREATE TABLE `academy_location_purpose_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `purposeCode` varchar(50) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `academicYearId` bigint(20) DEFAULT NULL,
  `academicYearTenureId` bigint(20) DEFAULT NULL,
  `facultyFeePlanId` bigint(20) DEFAULT NULL,
  `ownerId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academy_location_purpose_history` */

/*Table structure for table `academy_location_setting_history` */

DROP TABLE IF EXISTS `academy_location_setting_history`;

CREATE TABLE `academy_location_setting_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `locationSettingValue` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `entitySettingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academy_location_setting_history` */

/*Table structure for table `academy_year_history` */

DROP TABLE IF EXISTS `academy_year_history`;

CREATE TABLE `academy_year_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `yearName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academy_year_history` */

/*Table structure for table `academy_year_tenure_history` */

DROP TABLE IF EXISTS `academy_year_tenure_history`;

CREATE TABLE `academy_year_tenure_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `tenureName` varchar(255) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyYearId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `academy_year_tenure_history` */

/*Table structure for table `account_config_batch_sch_history` */

DROP TABLE IF EXISTS `account_config_batch_sch_history`;

CREATE TABLE `account_config_batch_sch_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fri` tinyint(1) DEFAULT NULL,
  `mon` tinyint(1) DEFAULT NULL,
  `sat` tinyint(1) DEFAULT NULL,
  `scheduleTime` varchar(10) DEFAULT NULL,
  `sun` tinyint(1) DEFAULT NULL,
  `thu` tinyint(1) DEFAULT NULL,
  `tue` tinyint(1) DEFAULT NULL,
  `wed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_config_batch_sch_history` */

/*Table structure for table `account_config_history` */

DROP TABLE IF EXISTS `account_config_history`;

CREATE TABLE `account_config_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `batchMode` varchar(35) DEFAULT NULL,
  `configDesc` varchar(255) DEFAULT NULL,
  `configName` varchar(100) DEFAULT NULL,
  `errorLogPath` varchar(100) DEFAULT NULL,
  `modeOfTransaction` varchar(10) DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `whetherBatch` tinyint(1) DEFAULT NULL,
  `whetherDataImportEnable` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `createdBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_config_history` */

/*Table structure for table `account_config_import_sch_history` */

DROP TABLE IF EXISTS `account_config_import_sch_history`;

CREATE TABLE `account_config_import_sch_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fri` tinyint(1) DEFAULT NULL,
  `importTime` varchar(10) DEFAULT NULL,
  `mon` tinyint(1) DEFAULT NULL,
  `sat` tinyint(1) DEFAULT NULL,
  `sun` tinyint(1) DEFAULT NULL,
  `thu` tinyint(1) DEFAULT NULL,
  `tue` tinyint(1) DEFAULT NULL,
  `wed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `account_config_import_sch_history` */

/*Table structure for table `activity_type_history` */

DROP TABLE IF EXISTS `activity_type_history`;

CREATE TABLE `activity_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `activity_type_history` */

/*Table structure for table `address_history` */

DROP TABLE IF EXISTS `address_history`;

CREATE TABLE `address_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `addressText` varchar(255) DEFAULT NULL,
  `alternateEmailId` varchar(100) DEFAULT NULL,
  `cellCountryCode` varchar(10) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `primaryeEmailId` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressTypeId` bigint(20) DEFAULT NULL,
  `cityId` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `countryRegionId` bigint(20) DEFAULT NULL,
  `parentRegionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `address_history` */

/*Table structure for table `address_to_be_changed_history` */

DROP TABLE IF EXISTS `address_to_be_changed_history`;

CREATE TABLE `address_to_be_changed_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `addressText` varchar(255) DEFAULT NULL,
  `alternateEmailId` varchar(255) DEFAULT NULL,
  `cellCountryCode` varchar(255) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneCountryCode` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(255) DEFAULT NULL,
  `primaryeEmailId` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressTypeId` bigint(20) DEFAULT NULL,
  `cityId` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `countryRegionByCountryRegionId` bigint(20) DEFAULT NULL,
  `countryRegionByParentRegionId` bigint(20) DEFAULT NULL,
  `dataToBeChangedId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `address_to_be_changed_history` */

/*Table structure for table `address_type_history` */

DROP TABLE IF EXISTS `address_type_history`;

CREATE TABLE `address_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `addressCategory` varchar(20) DEFAULT NULL,
  `addressTypeName` varchar(20) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `address_type_history` */

/*Table structure for table `admission_enq_details_cf_data_history` */

DROP TABLE IF EXISTS `admission_enq_details_cf_data_history`;

CREATE TABLE `admission_enq_details_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `admissionEnqDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `admission_enq_details_cf_data_history` */

/*Table structure for table `admission_enq_details_history` */

DROP TABLE IF EXISTS `admission_enq_details_history`;

CREATE TABLE `admission_enq_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `enquiryClosureReasonId` bigint(20) DEFAULT NULL,
  `enquiryReopenReasonId` bigint(20) DEFAULT NULL,
  `enqStudentDetailsId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `admission_enq_details_history` */

/*Table structure for table `admission_history` */

DROP TABLE IF EXISTS `admission_history`;

CREATE TABLE `admission_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `admissionDate` datetime DEFAULT NULL,
  `code` varchar(20) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `applicationAdmissionId` bigint(20) DEFAULT NULL,
  `applicationProgramId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `admission_history` */

/*Table structure for table `admission_program_course_history` */

DROP TABLE IF EXISTS `admission_program_course_history`;

CREATE TABLE `admission_program_course_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `courseName` varchar(100) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `marks` double DEFAULT NULL,
  `period` varchar(255) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `admission_program_course_history` */

/*Table structure for table `admission_status_history` */

DROP TABLE IF EXISTS `admission_status_history`;

CREATE TABLE `admission_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `admission_status_history` */

/*Table structure for table `applicant_address_history` */

DROP TABLE IF EXISTS `applicant_address_history`;

CREATE TABLE `applicant_address_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `addressText` varchar(255) DEFAULT NULL,
  `alternateEmailId` varchar(100) DEFAULT NULL,
  `cellCountryCode` varchar(10) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `primaryEmailId` varchar(100) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `whetherPrimary` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressTypeId` bigint(20) DEFAULT NULL,
  `cityId` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `countryRegionId` bigint(20) DEFAULT NULL,
  `parentRegionId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_address_history` */

/*Table structure for table `applicant_bank_details_history` */

DROP TABLE IF EXISTS `applicant_bank_details_history`;

CREATE TABLE `applicant_bank_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `IFSCode` varchar(255) DEFAULT NULL,
  `accountNumber` varchar(255) DEFAULT NULL,
  `bankName` varchar(255) DEFAULT NULL,
  `branchName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_bank_details_history` */

/*Table structure for table `applicant_classification_history` */

DROP TABLE IF EXISTS `applicant_classification_history`;

CREATE TABLE `applicant_classification_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `classificationName` varchar(18) DEFAULT NULL,
  `classificationValue` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_classification_history` */

/*Table structure for table `applicant_education_histories_history` */

DROP TABLE IF EXISTS `applicant_education_histories_history`;

CREATE TABLE `applicant_education_histories_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enrollmentNumber` varchar(255) DEFAULT NULL,
  `examConductedBy` varchar(255) DEFAULT NULL,
  `examResult` varchar(255) DEFAULT NULL,
  `whetherExistingStudent` tinyint(1) DEFAULT NULL,
  `yearPassed` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `examPassedId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_education_histories_history` */

/*Table structure for table `applicant_extracurricular_activity_history` */

DROP TABLE IF EXISTS `applicant_extracurricular_activity_history`;

CREATE TABLE `applicant_extracurricular_activity_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `activityName` varchar(255) DEFAULT NULL,
  `activityYear` int(11) DEFAULT NULL,
  `whetherCurrentOrganization` tinyint(1) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `performance` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `activityType` bigint(20) DEFAULT NULL,
  `communityId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_extracurricular_activity_history` */

/*Table structure for table `applicant_medical_history_history` */

DROP TABLE IF EXISTS `applicant_medical_history_history`;

CREATE TABLE `applicant_medical_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `consultingDoctor` varchar(255) DEFAULT NULL,
  `dateSince` date DEFAULT NULL,
  `medicalCondition` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `medicalConditonId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_medical_history_history` */

/*Table structure for table `applicant_person_communities_history` */

DROP TABLE IF EXISTS `applicant_person_communities_history`;

CREATE TABLE `applicant_person_communities_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `exitDate` datetime DEFAULT NULL,
  `whetherOpted` tinyint(1) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `communityId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_person_communities_history` */

/*Table structure for table `applicant_person_history` */

DROP TABLE IF EXISTS `applicant_person_history`;

CREATE TABLE `applicant_person_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `bloodGroup` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) DEFAULT NULL,
  `employeeId` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `whetherEmployeeOfOrganization` tinyint(1) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `maritalStatus` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `occupation` varchar(255) DEFAULT NULL,
  `personalIncome` double DEFAULT NULL,
  `photoUrl` varchar(255) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `shortName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `bankDetailId` bigint(20) DEFAULT NULL,
  `casteCategoryId` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `nationalityId` bigint(20) DEFAULT NULL,
  `referredStudentId` bigint(20) DEFAULT NULL,
  `religionId` bigint(20) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_person_history` */

/*Table structure for table `applicant_person_relationships_history` */

DROP TABLE IF EXISTS `applicant_person_relationships_history`;

CREATE TABLE `applicant_person_relationships_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `relationship` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `relatedApplicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_person_relationships_history` */

/*Table structure for table `applicant_person_services_history` */

DROP TABLE IF EXISTS `applicant_person_services_history`;

CREATE TABLE `applicant_person_services_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amountToBePaid` decimal(19,2) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `whetherMandatory` tinyint(1) DEFAULT NULL,
  `whetherOpted` tinyint(1) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `serviceIdentifier` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `serviceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_person_services_history` */

/*Table structure for table `applicant_subject_mark_info_history` */

DROP TABLE IF EXISTS `applicant_subject_mark_info_history`;

CREATE TABLE `applicant_subject_mark_info_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marks` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantEducationHistoryId` bigint(20) DEFAULT NULL,
  `subjectId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_subject_mark_info_history` */

/*Table structure for table `applicant_vaccination_info_history` */

DROP TABLE IF EXISTS `applicant_vaccination_info_history`;

CREATE TABLE `applicant_vaccination_info_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `purpose` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `vaccinationDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_vaccination_info_history` */

/*Table structure for table `applicant_work_experience_history` */

DROP TABLE IF EXISTS `applicant_work_experience_history`;

CREATE TABLE `applicant_work_experience_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `duration` float DEFAULT NULL,
  `employer` varchar(255) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `workType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `experienceTypeId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `applicant_work_experience_history` */

/*Table structure for table `application_admission_detail_history` */

DROP TABLE IF EXISTS `application_admission_detail_history`;

CREATE TABLE `application_admission_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `admissionType` varchar(100) DEFAULT NULL,
  `ConfirmedAdmissionClosureReason` varchar(255) DEFAULT NULL,
  `provisionalAdmissionClosureReason` varchar(255) DEFAULT NULL,
  `provisionalLastDate` datetime DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `trialAdmissionClosureReason` varchar(255) DEFAULT NULL,
  `trialEndDate` datetime DEFAULT NULL,
  `trialStartDate` datetime DEFAULT NULL,
  `whetherConfirmed` tinyint(1) DEFAULT NULL,
  `whetherDenied` tinyint(1) DEFAULT NULL,
  `whetherWithdrawl` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `advisiorId` bigint(20) DEFAULT NULL,
  `applicationProgramId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_admission_detail_history` */

/*Table structure for table `application_cf_data_history` */

DROP TABLE IF EXISTS `application_cf_data_history`;

CREATE TABLE `application_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_cf_data_history` */

/*Table structure for table `application_fee_details_history` */

DROP TABLE IF EXISTS `application_fee_details_history`;

CREATE TABLE `application_fee_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `paidStatus` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `feeStageId` bigint(20) DEFAULT NULL,
  `receiptHeaderId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_fee_details_history` */

/*Table structure for table `application_fee_plan_details_history` */

DROP TABLE IF EXISTS `application_fee_plan_details_history`;

CREATE TABLE `application_fee_plan_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeHeadAmount` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationFeeDetailId` bigint(20) DEFAULT NULL,
  `applicationProgramId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_fee_plan_details_history` */

/*Table structure for table `application_form_collector_history` */

DROP TABLE IF EXISTS `application_form_collector_history`;

CREATE TABLE `application_form_collector_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_form_collector_history` */

/*Table structure for table `application_form_history` */

DROP TABLE IF EXISTS `application_form_history`;

CREATE TABLE `application_form_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `collectedBy` varchar(100) DEFAULT NULL,
  `collectedByAddress` varchar(255) DEFAULT NULL,
  `collectedByCountryCode` varchar(10) DEFAULT NULL,
  `collectedByEmail` varchar(50) DEFAULT NULL,
  `collectedByFirstName` varchar(35) DEFAULT NULL,
  `collectedByLandlineNo` varchar(10) DEFAULT NULL,
  `collectedByLastName` varchar(35) DEFAULT NULL,
  `collectedByMiddleName` varchar(35) DEFAULT NULL,
  `collectedByPhoneNo` varchar(10) DEFAULT NULL,
  `handedOverToApplicant` varchar(35) DEFAULT NULL,
  `handedOverToEnquirer` varchar(35) DEFAULT NULL,
  `isConfirmed` tinyint(1) DEFAULT NULL,
  `saleDate` datetime DEFAULT NULL,
  `token` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_form_history` */

/*Table structure for table `application_history` */

DROP TABLE IF EXISTS `application_history`;

CREATE TABLE `application_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `currentStatus` varchar(50) DEFAULT NULL,
  `familyIncome` double DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneNo` varchar(255) DEFAULT NULL,
  `primaryEmailId` varchar(255) DEFAULT NULL,
  `saleRefId` varchar(255) DEFAULT NULL,
  `saleRefType` varchar(255) DEFAULT NULL,
  `submissionDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationFormId` bigint(20) DEFAULT NULL,
  `enquiryStudentDetailId` bigint(20) DEFAULT NULL,
  `existingStudentId` bigint(20) DEFAULT NULL,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `programGroupId` bigint(20) DEFAULT NULL,
  `reservationCategoryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_history` */

/*Table structure for table `application_other_courses_history` */

DROP TABLE IF EXISTS `application_other_courses_history`;

CREATE TABLE `application_other_courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `courseName` varchar(100) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `marks` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_other_courses_history` */

/*Table structure for table `application_prog_approval_reasons_history` */

DROP TABLE IF EXISTS `application_prog_approval_reasons_history`;

CREATE TABLE `application_prog_approval_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `value` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_prog_approval_reasons_history` */

/*Table structure for table `application_prog_rejection_reasons_history` */

DROP TABLE IF EXISTS `application_prog_rejection_reasons_history`;

CREATE TABLE `application_prog_rejection_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `value` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_prog_rejection_reasons_history` */

/*Table structure for table `application_prog_stage_history` */

DROP TABLE IF EXISTS `application_prog_stage_history`;

CREATE TABLE `application_prog_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `currentStatus` varchar(50) DEFAULT NULL,
  `documentStatus` varchar(50) DEFAULT NULL,
  `whetherUnderReplacement` tinyint(1) DEFAULT NULL,
  `quotaRank` bigint(20) DEFAULT NULL,
  `rank` bigint(20) DEFAULT NULL,
  `replacementStatus` varchar(255) DEFAULT NULL,
  `selectionRank` bigint(20) DEFAULT NULL,
  `stageMarks` float DEFAULT NULL,
  `totalMarks` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationProgramId` bigint(20) DEFAULT NULL,
  `programSelectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_prog_stage_history` */

/*Table structure for table `application_prog_stage_marks_history` */

DROP TABLE IF EXISTS `application_prog_stage_marks_history`;

CREATE TABLE `application_prog_stage_marks_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marksObtained` float DEFAULT NULL,
  `obtainedGrade` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationProgramStageId` bigint(20) DEFAULT NULL,
  `evaluationParameterWeightageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_prog_stage_marks_history` */

/*Table structure for table `application_prog_stage_status_history` */

DROP TABLE IF EXISTS `application_prog_stage_status_history`;

CREATE TABLE `application_prog_stage_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationProgramStageId` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_prog_stage_status_history` */

/*Table structure for table `application_prog_withdraw_reasons_history` */

DROP TABLE IF EXISTS `application_prog_withdraw_reasons_history`;

CREATE TABLE `application_prog_withdraw_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `value` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_prog_withdraw_reasons_history` */

/*Table structure for table `application_program_group_conf_history` */

DROP TABLE IF EXISTS `application_program_group_conf_history`;

CREATE TABLE `application_program_group_conf_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `appFormEndDate` date DEFAULT NULL,
  `appFormStartDate` date DEFAULT NULL,
  `appFormSubmitEndDate` date DEFAULT NULL,
  `appFormSubmitStartDate` date DEFAULT NULL,
  `onlineSalePermitted` tinyint(1) DEFAULT NULL,
  `onlineSubmissionAllowed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_program_group_conf_history` */

/*Table structure for table `application_program_history` */

DROP TABLE IF EXISTS `application_program_history`;

CREATE TABLE `application_program_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approval_remark` varchar(255) DEFAULT NULL,
  `currentStatus` varchar(100) DEFAULT NULL,
  `distancetoTravel` int(11) DEFAULT NULL,
  `feeAmount` decimal(18,5) DEFAULT NULL,
  `lateFee` decimal(18,5) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `rejection_remark` varchar(255) DEFAULT NULL,
  `whetherHostelApplicable` tinyint(1) DEFAULT NULL,
  `whetherOfferLetterAccepted` tinyint(1) DEFAULT NULL,
  `whetherTransportApplicable` tinyint(1) DEFAULT NULL,
  `withdrawl_remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `approval_reason_id` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `currentStageId` bigint(20) DEFAULT NULL,
  `rejection_reason_id` bigint(20) DEFAULT NULL,
  `withdrawl_reason_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_program_history` */

/*Table structure for table `application_quota_history` */

DROP TABLE IF EXISTS `application_quota_history`;

CREATE TABLE `application_quota_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `quotaId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_quota_history` */

/*Table structure for table `application_references_history` */

DROP TABLE IF EXISTS `application_references_history`;

CREATE TABLE `application_references_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `contactNo` varchar(50) DEFAULT NULL,
  `designation` varchar(100) DEFAULT NULL,
  `referenceName` varchar(100) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_references_history` */

/*Table structure for table `application_required_documents_history` */

DROP TABLE IF EXISTS `application_required_documents_history`;

CREATE TABLE `application_required_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicableAt` varchar(255) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_required_documents_history` */

/*Table structure for table `application_stage_cndtnl_marks_history` */

DROP TABLE IF EXISTS `application_stage_cndtnl_marks_history`;

CREATE TABLE `application_stage_cndtnl_marks_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marksObtained` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationProgramStageId` bigint(20) DEFAULT NULL,
  `selectionStageConditionalMarkId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `application_stage_cndtnl_marks_history` */

/*Table structure for table `approval_details_history` */

DROP TABLE IF EXISTS `approval_details_history`;

CREATE TABLE `approval_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actionDate` datetime DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `whetherLatest` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `escalatedApproverUserId` bigint(20) DEFAULT NULL,
  `requestStatusId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `approval_details_history` */

/*Table structure for table `attendance_academylocationwise_setup_history` */

DROP TABLE IF EXISTS `attendance_academylocationwise_setup_history`;

CREATE TABLE `attendance_academylocationwise_setup_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `backDateAllowed` int(11) DEFAULT NULL,
  `facultyAttendanceType` varchar(20) DEFAULT NULL,
  `studentAttendanceType` varchar(20) DEFAULT NULL,
  `timeTablePlanningFlag` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `attendance_academylocationwise_setup_history` */

/*Table structure for table `bank_account_detail_history` */

DROP TABLE IF EXISTS `bank_account_detail_history`;

CREATE TABLE `bank_account_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountNumber` int(11) DEFAULT NULL,
  `bankName` varchar(100) DEFAULT NULL,
  `branchName` varchar(100) DEFAULT NULL,
  `controlAccount` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bank_account_detail_history` */

/*Table structure for table `bank_contact_person_history` */

DROP TABLE IF EXISTS `bank_contact_person_history`;

CREATE TABLE `bank_contact_person_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `designation` varchar(10) DEFAULT NULL,
  `personName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `bankId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bank_contact_person_history` */

/*Table structure for table `bank_details_history` */

DROP TABLE IF EXISTS `bank_details_history`;

CREATE TABLE `bank_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `IFSCode` varchar(255) DEFAULT NULL,
  `accountNumber` varchar(255) DEFAULT NULL,
  `bankName` varchar(255) DEFAULT NULL,
  `branchName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bank_details_history` */

/*Table structure for table `bank_drawn_on_master_history` */

DROP TABLE IF EXISTS `bank_drawn_on_master_history`;

CREATE TABLE `bank_drawn_on_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `bankName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bank_drawn_on_master_history` */

/*Table structure for table `bank_history` */

DROP TABLE IF EXISTS `bank_history`;

CREATE TABLE `bank_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountNo` varchar(30) DEFAULT NULL,
  `bankCode` varchar(20) DEFAULT NULL,
  `bankName` varchar(30) DEFAULT NULL,
  `bankStatus` varchar(6) DEFAULT NULL,
  `branchAddress` longtext,
  `branchName` varchar(30) DEFAULT NULL,
  `ifscCode` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyId` bigint(20) DEFAULT NULL,
  `locationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bank_history` */

/*Table structure for table `bank_person_address_history` */

DROP TABLE IF EXISTS `bank_person_address_history`;

CREATE TABLE `bank_person_address_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `bankPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bank_person_address_history` */

/*Table structure for table `batch_courses_history` */

DROP TABLE IF EXISTS `batch_courses_history`;

CREATE TABLE `batch_courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherOptional` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `batch_courses_history` */

/*Table structure for table `batch_documents_history` */

DROP TABLE IF EXISTS `batch_documents_history`;

CREATE TABLE `batch_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `batch_documents_history` */

/*Table structure for table `batches_cf_data_history` */

DROP TABLE IF EXISTS `batches_cf_data_history`;

CREATE TABLE `batches_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `batches_cf_data_history` */

/*Table structure for table `batches_history` */

DROP TABLE IF EXISTS `batches_history`;

CREATE TABLE `batches_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `academicYear` int(11) DEFAULT NULL,
  `additionalRequirementDetails` varchar(255) DEFAULT NULL,
  `ageVerificationDate` date DEFAULT NULL,
  `batchName` varchar(18) DEFAULT NULL,
  `batchPartTime` tinyint(1) DEFAULT NULL,
  `faq` longtext,
  `hasAdditionalRequirement` tinyint(1) DEFAULT NULL,
  `maxCompulsoryCourses` int(11) DEFAULT NULL,
  `maxOptionalCourses` int(11) DEFAULT NULL,
  `maxPeriod` varchar(15) DEFAULT NULL,
  `maxProgramCourses` int(11) DEFAULT NULL,
  `maxProgramCredits` int(11) DEFAULT NULL,
  `minCompulsoryCourses` int(11) DEFAULT NULL,
  `minOptionalCourses` int(11) DEFAULT NULL,
  `minPeriod` varchar(15) DEFAULT NULL,
  `minProgramCourses` int(11) DEFAULT NULL,
  `minProgramCredits` int(11) DEFAULT NULL,
  `placementProcessRequired` tinyint(1) DEFAULT NULL,
  `programEntryCreteria` longtext,
  `programExitCreteria` longtext,
  `programMaxAge` int(11) DEFAULT NULL,
  `programMinAge` int(11) DEFAULT NULL,
  `seatCapacity` int(11) DEFAULT NULL,
  `specializationPossible` tinyint(1) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchOfSucceedingProgram` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `programPeriodTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `batches_history` */

/*Table structure for table `bill_dependant_details_history` */

DROP TABLE IF EXISTS `bill_dependant_details_history`;

CREATE TABLE `bill_dependant_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFeePlanRuleStageId` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `dependantFeeHeadId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_dependant_details_history` */

/*Table structure for table `bill_faculty_covered_history` */

DROP TABLE IF EXISTS `bill_faculty_covered_history`;

CREATE TABLE `bill_faculty_covered_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_faculty_covered_history` */

/*Table structure for table `bill_faculty_payment_history` */

DROP TABLE IF EXISTS `bill_faculty_payment_history`;

CREATE TABLE `bill_faculty_payment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `paymentDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_faculty_payment_history` */

/*Table structure for table `bill_faculty_sessions_history` */

DROP TABLE IF EXISTS `bill_faculty_sessions_history`;

CREATE TABLE `bill_faculty_sessions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `noOfSessions` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFacultyId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_faculty_sessions_history` */

/*Table structure for table `bill_fee_concessions_history` */

DROP TABLE IF EXISTS `bill_fee_concessions_history`;

CREATE TABLE `bill_fee_concessions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `concessionAmount` double DEFAULT NULL,
  `reasonOfConcession` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFeeRuleStageId` bigint(20) DEFAULT NULL,
  `discountCode` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_fee_concessions_history` */

/*Table structure for table `bill_fee_installments_history` */

DROP TABLE IF EXISTS `bill_fee_installments_history`;

CREATE TABLE `bill_fee_installments_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `concessionAmount` float DEFAULT NULL,
  `installmentAmount` float DEFAULT NULL,
  `installmentDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_fee_installments_history` */

/*Table structure for table `bill_fee_plan_rule_stage_history` */

DROP TABLE IF EXISTS `bill_fee_plan_rule_stage_history`;

CREATE TABLE `bill_fee_plan_rule_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustedAmount` double DEFAULT NULL,
  `balanceAmount` double DEFAULT NULL,
  `billableAmount` double DEFAULT NULL,
  `concessionAmount` double DEFAULT NULL,
  `discountAmount` double DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  `installmentRef` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `sponsorshipInstallmentId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_fee_plan_rule_stage_history` */

/*Table structure for table `bill_header_history` */

DROP TABLE IF EXISTS `bill_header_history`;

CREATE TABLE `bill_header_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvalDate` date DEFAULT NULL,
  `billGenerationType` varchar(255) DEFAULT NULL,
  `billNo` varchar(200) DEFAULT NULL,
  `billStatus` varchar(255) DEFAULT NULL,
  `billUniqueNumber` int(11) DEFAULT NULL,
  `billingDate` datetime DEFAULT NULL,
  `dueDate` date DEFAULT NULL,
  `raiseBillCategory` varchar(255) DEFAULT NULL,
  `raiseBillType` varchar(255) DEFAULT NULL,
  `reasonForManualBill` varchar(255) DEFAULT NULL,
  `totalAmount` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `approver` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `thirdPartyId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `raiseBillFor` bigint(20) DEFAULT NULL,
  `refundReason` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_header_history` */

/*Table structure for table `bill_refund_fee_plan_history` */

DROP TABLE IF EXISTS `bill_refund_fee_plan_history`;

CREATE TABLE `bill_refund_fee_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `refundAmount` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billRefundId` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_refund_fee_plan_history` */

/*Table structure for table `bill_refund_header_history` */

DROP TABLE IF EXISTS `bill_refund_header_history`;

CREATE TABLE `bill_refund_header_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `refundableAmount` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `paymentHeaderId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_refund_header_history` */

/*Table structure for table `bill_scholarship_received_history` */

DROP TABLE IF EXISTS `bill_scholarship_received_history`;

CREATE TABLE `bill_scholarship_received_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `scholarshipReceivedId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_scholarship_received_history` */

/*Table structure for table `bill_service_received_history` */

DROP TABLE IF EXISTS `bill_service_received_history`;

CREATE TABLE `bill_service_received_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustedAmount` double DEFAULT NULL,
  `balanceAmount` double DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `noOfSession` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `serviceReceived` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_service_received_history` */

/*Table structure for table `bill_student_sessions_history` */

DROP TABLE IF EXISTS `bill_student_sessions_history`;

CREATE TABLE `bill_student_sessions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `noOfSessions` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billStudentId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_student_sessions_history` */

/*Table structure for table `bill_students_covered_history` */

DROP TABLE IF EXISTS `bill_students_covered_history`;

CREATE TABLE `bill_students_covered_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bill_students_covered_history` */

/*Table structure for table `billed_user_type_history` */

DROP TABLE IF EXISTS `billed_user_type_history`;

CREATE TABLE `billed_user_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `billedUserType` varchar(255) DEFAULT NULL,
  `raiseBillType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `billed_user_type_history` */

/*Table structure for table `booking_purposes_history` */

DROP TABLE IF EXISTS `booking_purposes_history`;

CREATE TABLE `booking_purposes_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `value` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `booking_purposes_history` */

/*Table structure for table `calendar_slots_history` */

DROP TABLE IF EXISTS `calendar_slots_history`;

CREATE TABLE `calendar_slots_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `period` int(11) DEFAULT NULL,
  `startTime` datetime DEFAULT NULL,
  `weekday` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `calendar_slots_history` */

/*Table structure for table `campaign_cf_data_history` */

DROP TABLE IF EXISTS `campaign_cf_data_history`;

CREATE TABLE `campaign_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `campaign_cf_data_history` */

/*Table structure for table `campaign_coverage_history` */

DROP TABLE IF EXISTS `campaign_coverage_history`;

CREATE TABLE `campaign_coverage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `coverageRemarks` varchar(255) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `campaign_coverage_history` */

/*Table structure for table `campaign_history` */

DROP TABLE IF EXISTS `campaign_history`;

CREATE TABLE `campaign_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actualAmount` int(11) DEFAULT NULL,
  `budgetAmount` int(11) DEFAULT NULL,
  `campaignDesc` varchar(100) DEFAULT NULL,
  `campaignName` varchar(255) DEFAULT NULL,
  `code` varchar(250) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `campaign_history` */

/*Table structure for table `campaign_media_history` */

DROP TABLE IF EXISTS `campaign_media_history`;

CREATE TABLE `campaign_media_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `mediaId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `campaign_media_history` */

/*Table structure for table `caste_categories_history` */

DROP TABLE IF EXISTS `caste_categories_history`;

CREATE TABLE `caste_categories_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `caste_categories_history` */

/*Table structure for table `category_field_items_history` */

DROP TABLE IF EXISTS `category_field_items_history`;

CREATE TABLE `category_field_items_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  `itemCode` varchar(10) DEFAULT NULL,
  `itemValue` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `categoryMetaDataId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `category_field_items_history` */

/*Table structure for table `category_field_meta_data_history` */

DROP TABLE IF EXISTS `category_field_meta_data_history`;

CREATE TABLE `category_field_meta_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dbColumn` varchar(30) DEFAULT NULL,
  `fieldName` varchar(30) DEFAULT NULL,
  `labelName` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `entityTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `category_field_meta_data_history` */

/*Table structure for table `center_allocation_history` */

DROP TABLE IF EXISTS `center_allocation_history`;

CREATE TABLE `center_allocation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `allocateDate` date DEFAULT NULL,
  `timeSlot` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `examCenterId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `center_allocation_history` */

/*Table structure for table `center_room_details_history` */

DROP TABLE IF EXISTS `center_room_details_history`;

CREATE TABLE `center_room_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `roomCapacity` int(11) DEFAULT NULL,
  `roomLocation` varchar(35) DEFAULT NULL,
  `roomNo` varchar(8) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `allocatedCenterId` bigint(20) DEFAULT NULL,
  `examCenterId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `center_room_details_history` */

/*Table structure for table `centre_unavailability_date_history` */

DROP TABLE IF EXISTS `centre_unavailability_date_history`;

CREATE TABLE `centre_unavailability_date_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `unavailabilityReason` varchar(255) DEFAULT NULL,
  `unavailableFor` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `centerId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `centre_unavailability_date_history` */

/*Table structure for table `centre_unavailability_time_history` */

DROP TABLE IF EXISTS `centre_unavailability_time_history`;

CREATE TABLE `centre_unavailability_time_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `timeFrom` datetime DEFAULT NULL,
  `timeTo` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `unavailabilityDateId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `centre_unavailability_time_history` */

/*Table structure for table `certificate_request_details_history` */

DROP TABLE IF EXISTS `certificate_request_details_history`;

CREATE TABLE `certificate_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `certificateCategory` int(11) DEFAULT NULL,
  `certificateStatus` varchar(255) DEFAULT NULL,
  `copies` int(11) DEFAULT NULL,
  `whetherOriginal` tinyint(1) DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `certificate_request_details_history` */

/*Table structure for table `certificates_history` */

DROP TABLE IF EXISTS `certificates_history`;

CREATE TABLE `certificates_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `certificateCategory` varchar(255) DEFAULT NULL,
  `certificateCode` varchar(255) DEFAULT NULL,
  `whetherActive` tinyint(1) DEFAULT NULL,
  `whetherOnlyOrganisational` tinyint(1) DEFAULT NULL,
  `certificateName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `certificates_history` */

/*Table structure for table `change_exam_centre_request_details_history` */

DROP TABLE IF EXISTS `change_exam_centre_request_details_history`;

CREATE TABLE `change_exam_centre_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centerType` varchar(255) DEFAULT NULL,
  `changeOfExamCenterReason` varchar(255) DEFAULT NULL,
  `expectedDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `currentExamBatchId` bigint(20) DEFAULT NULL,
  `currentExamCenterId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  `expectedExamCentreId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `change_exam_centre_request_details_history` */

/*Table structure for table `change_exam_date_request_details_history` */

DROP TABLE IF EXISTS `change_exam_date_request_details_history`;

CREATE TABLE `change_exam_date_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `changeOfDateReason` varchar(255) DEFAULT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `expectedDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `currentExamBatchId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  `expectedExamBatchId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `change_exam_date_request_details_history` */

/*Table structure for table `checklist_history` */

DROP TABLE IF EXISTS `checklist_history`;

CREATE TABLE `checklist_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `checkListItem` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `checklist_history` */

/*Table structure for table `checklist_items_history` */

DROP TABLE IF EXISTS `checklist_items_history`;

CREATE TABLE `checklist_items_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `checklist_items_history` */

/*Table structure for table `city_history` */

DROP TABLE IF EXISTS `city_history`;

CREATE TABLE `city_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `cityName` varchar(50) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `city_history` */

/*Table structure for table `classifications_history` */

DROP TABLE IF EXISTS `classifications_history`;

CREATE TABLE `classifications_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `classificationName` varchar(50) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `classifications_history` */

/*Table structure for table `closed_rplcmt_prog_slct_process_history` */

DROP TABLE IF EXISTS `closed_rplcmt_prog_slct_process_history`;

CREATE TABLE `closed_rplcmt_prog_slct_process_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `closedDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `closed_rplcmt_prog_slct_process_history` */

/*Table structure for table `closure_reason_history` */

DROP TABLE IF EXISTS `closure_reason_history`;

CREATE TABLE `closure_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `reasonCode` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `closure_reason_history` */

/*Table structure for table `community_history` */

DROP TABLE IF EXISTS `community_history`;

CREATE TABLE `community_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `communityCode` varchar(8) DEFAULT NULL,
  `communityName` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `community_history` */

/*Table structure for table `community_locations_history` */

DROP TABLE IF EXISTS `community_locations_history`;

CREATE TABLE `community_locations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `communityId` bigint(20) DEFAULT NULL,
  `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `community_locations_history` */

/*Table structure for table `complaint_details_history` */

DROP TABLE IF EXISTS `complaint_details_history`;

CREATE TABLE `complaint_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `against` varchar(255) DEFAULT NULL,
  `complainant` varchar(255) DEFAULT NULL,
  `complaintBy` varchar(255) DEFAULT NULL,
  `facilityDescription` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `complaintAgainstPersonId` bigint(20) DEFAULT NULL,
  `complaintTypeId` bigint(20) DEFAULT NULL,
  `internalResourceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `complaint_details_history` */

/*Table structure for table `complaint_type_setting_status_history` */

DROP TABLE IF EXISTS `complaint_type_setting_status_history`;

CREATE TABLE `complaint_type_setting_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `complaintTypeSettingId` bigint(20) DEFAULT NULL,
  `requestStatusId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `complaint_type_setting_status_history` */

/*Table structure for table `complaint_type_settings_history` */

DROP TABLE IF EXISTS `complaint_type_settings_history`;

CREATE TABLE `complaint_type_settings_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `sla` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `complaintTypeId` bigint(20) DEFAULT NULL,
  `defaultApproverUserId` bigint(20) DEFAULT NULL,
  `defaultAssigneeUserId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `complaint_type_settings_history` */

/*Table structure for table `complaint_types_history` */

DROP TABLE IF EXISTS `complaint_types_history`;

CREATE TABLE `complaint_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `complaint_types_history` */

/*Table structure for table `completion_certificates_history` */

DROP TABLE IF EXISTS `completion_certificates_history`;

CREATE TABLE `completion_certificates_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_certificates_history` */

/*Table structure for table `completion_checklists_history` */

DROP TABLE IF EXISTS `completion_checklists_history`;

CREATE TABLE `completion_checklists_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `seatTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_checklists_history` */

/*Table structure for table `completion_documents_history` */

DROP TABLE IF EXISTS `completion_documents_history`;

CREATE TABLE `completion_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `completionId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_documents_history` */

/*Table structure for table `completion_required_documents_history` */

DROP TABLE IF EXISTS `completion_required_documents_history`;

CREATE TABLE `completion_required_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherSubmitted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `completionId` bigint(20) DEFAULT NULL,
  `requiredDocumentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_required_documents_history` */

/*Table structure for table `completion_termination_history` */

DROP TABLE IF EXISTS `completion_termination_history`;

CREATE TABLE `completion_termination_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveFromDate` date DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `terminationReason` int(11) DEFAULT NULL,
  `terminationTillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `checkListId` bigint(20) DEFAULT NULL,
  `transactionId` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_termination_history` */

/*Table structure for table `completion_trans_details_history` */

DROP TABLE IF EXISTS `completion_trans_details_history`;

CREATE TABLE `completion_trans_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `inspectionDate` date DEFAULT NULL,
  `inspectionRequired` tinyint(1) DEFAULT NULL,
  `physicalDoc` varchar(100) DEFAULT NULL,
  `returnBy` int(11) DEFAULT NULL,
  `returnDate` date DEFAULT NULL,
  `returnTo` int(11) DEFAULT NULL,
  `uploadDoc` varchar(100) DEFAULT NULL,
  `whetherElectronic` tinyint(1) DEFAULT NULL,
  `whetherReturnableDoc` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `checkListId` bigint(20) DEFAULT NULL,
  `transactionId` bigint(20) DEFAULT NULL,
  `inspectionDoneBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_trans_details_history` */

/*Table structure for table `completion_trans_type_certs_history` */

DROP TABLE IF EXISTS `completion_trans_type_certs_history`;

CREATE TABLE `completion_trans_type_certs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `completionStatus` varchar(255) DEFAULT NULL,
  `isOriginal` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  `completionId` bigint(20) DEFAULT NULL,
  `transactionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_trans_type_certs_history` */

/*Table structure for table `completion_trans_type_checks_history` */

DROP TABLE IF EXISTS `completion_trans_type_checks_history`;

CREATE TABLE `completion_trans_type_checks_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherComplete` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `checklistId` bigint(20) DEFAULT NULL,
  `completionId` bigint(20) DEFAULT NULL,
  `transactionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_trans_type_checks_history` */

/*Table structure for table `completion_transactions_history` */

DROP TABLE IF EXISTS `completion_transactions_history`;

CREATE TABLE `completion_transactions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveFromDate` date DEFAULT NULL,
  `whetherMessage` tinyint(1) DEFAULT NULL,
  `whetherNotification` tinyint(1) DEFAULT NULL,
  `whetherPassedOut` tinyint(1) DEFAULT NULL,
  `whetherTermination` tinyint(1) DEFAULT NULL,
  `whetherTransfer` tinyint(1) DEFAULT NULL,
  `whetherWithdrawal` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completion_transactions_history` */

/*Table structure for table `completions_history` */

DROP TABLE IF EXISTS `completions_history`;

CREATE TABLE `completions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveDate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `completions_history` */

/*Table structure for table `compln_check_trans_certs_history` */

DROP TABLE IF EXISTS `compln_check_trans_certs_history`;

CREATE TABLE `compln_check_trans_certs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  `completionCheckListId` bigint(20) DEFAULT NULL,
  `transactionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `compln_check_trans_certs_history` */

/*Table structure for table `compln_check_trans_checks_history` */

DROP TABLE IF EXISTS `compln_check_trans_checks_history`;

CREATE TABLE `compln_check_trans_checks_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `checklistItemId` bigint(20) DEFAULT NULL,
  `completionCheckListId` bigint(20) DEFAULT NULL,
  `transactionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `compln_check_trans_checks_history` */

/*Table structure for table `component_type_history` */

DROP TABLE IF EXISTS `component_type_history`;

CREATE TABLE `component_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `abbreviation` varchar(30) DEFAULT NULL,
  `componentType` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `component_type_history` */

/*Table structure for table `config_control_account_history` */

DROP TABLE IF EXISTS `config_control_account_history`;

CREATE TABLE `config_control_account_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountingType` varchar(18) DEFAULT NULL,
  `whetherDefaultControlAccount` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `iauAccountingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `config_control_account_history` */

/*Table structure for table `config_control_head_detail_history` */

DROP TABLE IF EXISTS `config_control_head_detail_history`;

CREATE TABLE `config_control_head_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `controlAccount` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `config_control_head_detail_history` */

/*Table structure for table `config_control_head_plan_history` */

DROP TABLE IF EXISTS `config_control_head_plan_history`;

CREATE TABLE `config_control_head_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `controlAccount` varchar(35) DEFAULT NULL,
  `creditNarration` varchar(30) DEFAULT NULL,
  `debitNarration` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `config_control_head_plan_history` */

/*Table structure for table `config_control_plan_detail_history` */

DROP TABLE IF EXISTS `config_control_plan_detail_history`;

CREATE TABLE `config_control_plan_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `controlAccount` varchar(10) DEFAULT NULL,
  `creditNarration` varchar(30) DEFAULT NULL,
  `debitNarration` varchar(30) DEFAULT NULL,
  `feeSeqId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `config_control_plan_detail_history` */

/*Table structure for table `country_history` */

DROP TABLE IF EXISTS `country_history`;

CREATE TABLE `country_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `countryName` varchar(20) DEFAULT NULL,
  `isdCode` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `country_history` */

/*Table structure for table `country_region_history` */

DROP TABLE IF EXISTS `country_region_history`;

CREATE TABLE `country_region_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `countryRegionName` varchar(255) DEFAULT NULL,
  `countryRegionType` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `parentRegionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `country_region_history` */

/*Table structure for table `course_academy_location_history` */

DROP TABLE IF EXISTS `course_academy_location_history`;

CREATE TABLE `course_academy_location_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_academy_location_history` */

/*Table structure for table `course_cf_data_history` */

DROP TABLE IF EXISTS `course_cf_data_history`;

CREATE TABLE `course_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_cf_data_history` */

/*Table structure for table `course_components_cf_data_history` */

DROP TABLE IF EXISTS `course_components_cf_data_history`;

CREATE TABLE `course_components_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_components_cf_data_history` */

/*Table structure for table `course_components_history` */

DROP TABLE IF EXISTS `course_components_history`;

CREATE TABLE `course_components_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `componentCredit` tinyint(4) DEFAULT NULL,
  `componentDesc` varchar(255) DEFAULT NULL,
  `componentStatus` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `componentTypeId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_components_history` */

/*Table structure for table `course_coverage_plan_history` */

DROP TABLE IF EXISTS `course_coverage_plan_history`;

CREATE TABLE `course_coverage_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `noOfParticipants` int(11) DEFAULT NULL,
  `optionalSession` tinyint(1) DEFAULT NULL,
  `sessionDate` datetime DEFAULT NULL,
  `sessionNumber` int(11) DEFAULT NULL,
  `sessionStatus` varchar(255) DEFAULT NULL,
  `slotFrom` datetime DEFAULT NULL,
  `slotTo` datetime DEFAULT NULL,
  `whetherAttendanceToBeEntered` tinyint(1) DEFAULT NULL,
  `whetherPlannedSession` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `roomId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `additionalFacultyOne` bigint(20) DEFAULT NULL,
  `additionalFacultyTwo` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `facultyCourseAttendanceId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `studentCourseAttendanceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_coverage_plan_history` */

/*Table structure for table `course_coverage_resource_booking_history` */

DROP TABLE IF EXISTS `course_coverage_resource_booking_history`;

CREATE TABLE `course_coverage_resource_booking_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseCoveragePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_coverage_resource_booking_history` */

/*Table structure for table `course_distribution_list_history` */

DROP TABLE IF EXISTS `course_distribution_list_history`;

CREATE TABLE `course_distribution_list_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `distributionListId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_distribution_list_history` */

/*Table structure for table `course_documents_history` */

DROP TABLE IF EXISTS `course_documents_history`;

CREATE TABLE `course_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_documents_history` */

/*Table structure for table `course_equivalence_history` */

DROP TABLE IF EXISTS `course_equivalence_history`;

CREATE TABLE `course_equivalence_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `courseEquivalentName` varchar(35) DEFAULT NULL,
  `whetherActive` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `equivalentComponent` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_equivalence_history` */

/*Table structure for table `course_evaluation_que_paper_history` */

DROP TABLE IF EXISTS `course_evaluation_que_paper_history`;

CREATE TABLE `course_evaluation_que_paper_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `tillDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_evaluation_que_paper_history` */

/*Table structure for table `course_group_cf_data_history` */

DROP TABLE IF EXISTS `course_group_cf_data_history`;

CREATE TABLE `course_group_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_group_cf_data_history` */

/*Table structure for table `course_group_completion_history` */

DROP TABLE IF EXISTS `course_group_completion_history`;

CREATE TABLE `course_group_completion_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_group_completion_history` */

/*Table structure for table `course_group_history` */

DROP TABLE IF EXISTS `course_group_history`;

CREATE TABLE `course_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(30) DEFAULT NULL,
  `groupName` varchar(35) DEFAULT NULL,
  `maxCourses` int(11) DEFAULT NULL,
  `maxCredits` int(11) DEFAULT NULL,
  `minCourses` int(11) DEFAULT NULL,
  `minCredits` int(11) DEFAULT NULL,
  `optionalMaxCourses` int(11) DEFAULT NULL,
  `optionalMinCourses` int(11) DEFAULT NULL,
  `whetherAuditGroup` tinyint(1) DEFAULT NULL,
  `whetherRegularGroup` tinyint(1) DEFAULT NULL,
  `whetherSpecializedGroup` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_group_history` */

/*Table structure for table `course_groups_course_history` */

DROP TABLE IF EXISTS `course_groups_course_history`;

CREATE TABLE `course_groups_course_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherMandatory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_groups_course_history` */

/*Table structure for table `course_history_one_history` */

DROP TABLE IF EXISTS `course_history_one_history`;

CREATE TABLE `course_history_one_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `maxCapacity` bigint(20) DEFAULT NULL,
  `minCapacity` int(11) DEFAULT NULL,
  `noOfStudentEnrolled` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  `progBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_history_one_history` */

/*Table structure for table `course_history_two_history` */

DROP TABLE IF EXISTS `course_history_two_history`;

CREATE TABLE `course_history_two_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enrolmentReqReceived` int(11) DEFAULT NULL,
  `enrolmentReqRejected` int(11) DEFAULT NULL,
  `faculty1` bigint(20) DEFAULT NULL,
  `faculty2` bigint(20) DEFAULT NULL,
  `faculty3` bigint(20) DEFAULT NULL,
  `maxGradeForCourse` varchar(6) DEFAULT NULL,
  `maxGradeOfAny` varchar(6) DEFAULT NULL,
  `maxMarkForCourse` int(11) DEFAULT NULL,
  `maxMarkOfAny` int(11) DEFAULT NULL,
  `minGradeForCourse` varchar(6) DEFAULT NULL,
  `minGradeOfAny` varchar(6) DEFAULT NULL,
  `minMarkForCourse` int(11) DEFAULT NULL,
  `minMarkOfAny` int(11) DEFAULT NULL,
  `studentEnrolled` int(11) DEFAULT NULL,
  `studentPassed` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseHistoryOneId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_history_two_history` */

/*Table structure for table `course_hw_asignment_history` */

DROP TABLE IF EXISTS `course_hw_asignment_history`;

CREATE TABLE `course_hw_asignment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `assignmentName` varchar(255) DEFAULT NULL,
  `assignmentType` varchar(255) DEFAULT NULL,
  `dateGiven` date DEFAULT NULL,
  `dateResubmitted` date DEFAULT NULL,
  `dateSubmitted` date DEFAULT NULL,
  `grades` varchar(4) DEFAULT NULL,
  `hWOnlineSubmissions` tinyint(1) DEFAULT NULL,
  `hWOnlineSubmissionGroup` char(1) DEFAULT NULL,
  `hWRemarks` varchar(255) DEFAULT NULL,
  `marks` int(11) DEFAULT NULL,
  `submissionDate` date DEFAULT NULL,
  `topicType` varchar(45) DEFAULT NULL,
  `whetherMarkGrade` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `distributionModeId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceId` bigint(20) DEFAULT NULL,
  `evaluationDetailSequenceId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_hw_asignment_history` */

/*Table structure for table `course_hw_documents_history` */

DROP TABLE IF EXISTS `course_hw_documents_history`;

CREATE TABLE `course_hw_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `hwFile` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_hw_documents_history` */

/*Table structure for table `course_hw_topics_history` */

DROP TABLE IF EXISTS `course_hw_topics_history`;

CREATE TABLE `course_hw_topics_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_hw_topics_history` */

/*Table structure for table `course_read_distribution_history` */

DROP TABLE IF EXISTS `course_read_distribution_history`;

CREATE TABLE `course_read_distribution_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `distributionListId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_read_distribution_history` */

/*Table structure for table `course_read_type_details_history` */

DROP TABLE IF EXISTS `course_read_type_details_history`;

CREATE TABLE `course_read_type_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `readTypeName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `readTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_read_type_details_history` */

/*Table structure for table `course_read_type_history` */

DROP TABLE IF EXISTS `course_read_type_history`;

CREATE TABLE `course_read_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `readingTypeName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_read_type_history` */

/*Table structure for table `course_reading_cf_data_history` */

DROP TABLE IF EXISTS `course_reading_cf_data_history`;

CREATE TABLE `course_reading_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_cf_data_history` */

/*Table structure for table `course_reading_documents_history` */

DROP TABLE IF EXISTS `course_reading_documents_history`;

CREATE TABLE `course_reading_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_documents_history` */

/*Table structure for table `course_reading_history` */

DROP TABLE IF EXISTS `course_reading_history`;

CREATE TABLE `course_reading_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `academicYear` int(11) DEFAULT NULL,
  `author` varchar(60) DEFAULT NULL,
  `linkPath` varchar(255) DEFAULT NULL,
  `readingName` varchar(255) DEFAULT NULL,
  `topicType` varchar(35) DEFAULT NULL,
  `whetherCompulsory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseReadTypeId` bigint(20) DEFAULT NULL,
  `distributionModeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_history` */

/*Table structure for table `course_reading_links_history` */

DROP TABLE IF EXISTS `course_reading_links_history`;

CREATE TABLE `course_reading_links_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `mediaLinks` longtext,
  `whetherDownloadable` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_links_history` */

/*Table structure for table `course_reading_period_details_history` */

DROP TABLE IF EXISTS `course_reading_period_details_history`;

CREATE TABLE `course_reading_period_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_period_details_history` */

/*Table structure for table `course_reading_topics_history` */

DROP TABLE IF EXISTS `course_reading_topics_history`;

CREATE TABLE `course_reading_topics_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_topics_history` */

/*Table structure for table `course_reading_variant_history` */

DROP TABLE IF EXISTS `course_reading_variant_history`;

CREATE TABLE `course_reading_variant_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseReadingId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_reading_variant_history` */

/*Table structure for table `course_relation_history_history` */

DROP TABLE IF EXISTS `course_relation_history_history`;

CREATE TABLE `course_relation_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `relationType` varchar(10) DEFAULT NULL,
  `whetherRelatedCourseIndepedent` tinyint(1) DEFAULT NULL,
  `whetherRelatedCourseMandatory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `relatedCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_relation_history_history` */

/*Table structure for table `course_req_detail_courses_history` */

DROP TABLE IF EXISTS `course_req_detail_courses_history`;

CREATE TABLE `course_req_detail_courses_history` (
  `REV` int(11) NOT NULL,
  `courseWithdrawReqDetailId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`REV`,`courseWithdrawReqDetailId`,`courseId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_req_detail_courses_history` */

/*Table structure for table `course_topic_cf_data_history` */

DROP TABLE IF EXISTS `course_topic_cf_data_history`;

CREATE TABLE `course_topic_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `topicId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_topic_cf_data_history` */

/*Table structure for table `course_topic_coverage_history` */

DROP TABLE IF EXISTS `course_topic_coverage_history`;

CREATE TABLE `course_topic_coverage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `date` date DEFAULT NULL,
  `minuteSpent` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `variantId` bigint(20) DEFAULT NULL,
  `attendanceId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_topic_coverage_history` */

/*Table structure for table `course_topic_coverage_status_history` */

DROP TABLE IF EXISTS `course_topic_coverage_status_history`;

CREATE TABLE `course_topic_coverage_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `variantId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_topic_coverage_status_history` */

/*Table structure for table `course_topic_documents_history` */

DROP TABLE IF EXISTS `course_topic_documents_history`;

CREATE TABLE `course_topic_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_topic_documents_history` */

/*Table structure for table `course_topic_session_history` */

DROP TABLE IF EXISTS `course_topic_session_history`;

CREATE TABLE `course_topic_session_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `activitiesCovered` varchar(255) DEFAULT NULL,
  `session` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_topic_session_history` */

/*Table structure for table `course_topics_history` */

DROP TABLE IF EXISTS `course_topics_history`;

CREATE TABLE `course_topics_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `noOfSessions` int(11) DEFAULT NULL,
  `topicMinutes` bigint(20) DEFAULT NULL,
  `topicName` varchar(255) DEFAULT NULL,
  `topicSequence` tinyint(4) DEFAULT NULL,
  `whetherCompulsory` tinyint(1) DEFAULT NULL,
  `whetherTemporaryIgnoreTopic` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `topicDepth` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_topics_history` */

/*Table structure for table `course_variants_history` */

DROP TABLE IF EXISTS `course_variants_history`;

CREATE TABLE `course_variants_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `courseStatus` tinyint(1) DEFAULT NULL,
  `courseVariantCode` varchar(255) DEFAULT NULL,
  `courseVariantDescription` varchar(255) DEFAULT NULL,
  `courseVariantFileDwlLoc` varchar(255) DEFAULT NULL,
  `courseVariantHWFileLocation` varchar(255) DEFAULT NULL,
  `courseVariantShortDescription` varchar(255) DEFAULT NULL,
  `courseVariantStatus` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_variants_history` */

/*Table structure for table `course_withdraw_req_details_history` */

DROP TABLE IF EXISTS `course_withdraw_req_details_history`;

CREATE TABLE `course_withdraw_req_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_withdraw_req_details_history` */

/*Table structure for table `course_xfer_request_details_history` */

DROP TABLE IF EXISTS `course_xfer_request_details_history`;

CREATE TABLE `course_xfer_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `fromCourseId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `toCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `course_xfer_request_details_history` */

/*Table structure for table `courses_history` */

DROP TABLE IF EXISTS `courses_history`;

CREATE TABLE `courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `assignSectionType` varchar(35) DEFAULT NULL,
  `categoryField1` varchar(15) DEFAULT NULL,
  `categoryField2` varchar(15) DEFAULT NULL,
  `categoryField3` varchar(15) DEFAULT NULL,
  `categoryField4` varchar(15) DEFAULT NULL,
  `categoryField5` varchar(15) DEFAULT NULL,
  `courseCode` varchar(255) DEFAULT NULL,
  `courseCredits` tinyint(4) DEFAULT NULL,
  `courseCutOff` varchar(255) DEFAULT NULL,
  `courseDeficits` varchar(255) DEFAULT NULL,
  `courseDeficitsPoint` int(11) DEFAULT NULL,
  `courseEntryCriteriaQuery` varchar(255) DEFAULT NULL,
  `courseExitCriteriaQuery` varchar(255) DEFAULT NULL,
  `courseGradeType` varchar(255) DEFAULT NULL,
  `courseMarksGrades` varchar(255) DEFAULT NULL,
  `courseMaxMark` varchar(255) DEFAULT NULL,
  `courseName` varchar(255) DEFAULT NULL,
  `courseRankConsidered` varchar(255) DEFAULT NULL,
  `courseShortDescription` varchar(255) DEFAULT NULL,
  `courseShortName` varchar(255) DEFAULT NULL,
  `createdOn` datetime DEFAULT NULL,
  `deficiencyStatus` tinyint(1) DEFAULT NULL,
  `hasCourseComponents` tinyint(1) DEFAULT NULL,
  `nameToBePrinted` varchar(255) DEFAULT NULL,
  `sectionAtComponentLevel` tinyint(1) DEFAULT NULL,
  `sectionType` varchar(255) DEFAULT NULL,
  `courseStage` varchar(255) DEFAULT NULL,
  `whetherCourseCanBeExemption` tinyint(1) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `whetherEvaluationExternal` tinyint(1) DEFAULT NULL,
  `whetherFixed` tinyint(1) DEFAULT NULL,
  `whetherRepeatable` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `componentId` bigint(20) DEFAULT NULL,
  `departmentId` bigint(20) DEFAULT NULL,
  `parentCourseId` bigint(20) DEFAULT NULL,
  `subDepartmentId` bigint(20) DEFAULT NULL,
  `courseCoordinator` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `courses_history` */

/*Table structure for table `currency_exchange_rate_audit` */

DROP TABLE IF EXISTS `currency_exchange_rate_audit`;

CREATE TABLE `currency_exchange_rate_audit` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `exchangeRate` float DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `currency_exchange_rate_audit` */

/*Table structure for table `currency_history` */

DROP TABLE IF EXISTS `currency_history`;

CREATE TABLE `currency_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `currencyCode` varchar(10) DEFAULT NULL,
  `currencyName` varchar(100) DEFAULT NULL,
  `regionCode` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `currency_history` */

/*Table structure for table `data_to_be_changed_history` */

DROP TABLE IF EXISTS `data_to_be_changed_history`;

CREATE TABLE `data_to_be_changed_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `data_to_be_changed_history` */

/*Table structure for table `dataview_audit_history` */

DROP TABLE IF EXISTS `dataview_audit_history`;

CREATE TABLE `dataview_audit_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accessTime` datetime DEFAULT NULL,
  `entityName` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dataview_audit_history` */

/*Table structure for table `debarment_reasons_history` */

DROP TABLE IF EXISTS `debarment_reasons_history`;

CREATE TABLE `debarment_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `debarment_reasons_history` */

/*Table structure for table `debarment_request_details_history` */

DROP TABLE IF EXISTS `debarment_request_details_history`;

CREATE TABLE `debarment_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` datetime DEFAULT NULL,
  `toDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `debarmentReasonId` bigint(20) DEFAULT NULL,
  `initiatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `debarment_request_details_history` */

/*Table structure for table `deficit_credit_history` */

DROP TABLE IF EXISTS `deficit_credit_history`;

CREATE TABLE `deficit_credit_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `deficitPoints` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `gradeId` bigint(20) DEFAULT NULL,
  `gradeGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `deficit_credit_history` */

/*Table structure for table `deficit_credit_transaction_history` */

DROP TABLE IF EXISTS `deficit_credit_transaction_history`;

CREATE TABLE `deficit_credit_transaction_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `deficitCredited` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  `evalDetailSequenceId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `deficit_credit_transaction_history` */

/*Table structure for table `department_history` */

DROP TABLE IF EXISTS `department_history`;

CREATE TABLE `department_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `deptName` varchar(255) DEFAULT NULL,
  `deptType` varchar(10) DEFAULT NULL,
  `hasSubDepartment` tinyint(1) DEFAULT NULL,
  `hodEndDate` date DEFAULT NULL,
  `hodStartDate` date DEFAULT NULL,
  `serialId` varchar(255) DEFAULT NULL,
  `shortCode` varchar(10) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `parentDepartmentId` bigint(20) DEFAULT NULL,
  `hodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `department_history` */

/*Table structure for table `dependent_bill_type_history` */

DROP TABLE IF EXISTS `dependent_bill_type_history`;

CREATE TABLE `dependent_bill_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `dependent_bill_type_history` */

/*Table structure for table `designations_history` */

DROP TABLE IF EXISTS `designations_history`;

CREATE TABLE `designations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `designations_history` */

/*Table structure for table `disciplinary_actions_history` */

DROP TABLE IF EXISTS `disciplinary_actions_history`;

CREATE TABLE `disciplinary_actions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actionTaken` varchar(255) DEFAULT NULL,
  `dateOfAction` datetime DEFAULT NULL,
  `details` varchar(255) DEFAULT NULL,
  `incidentDate` date DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `disciplinary_actions_history` */

/*Table structure for table `discount_code_history` */

DROP TABLE IF EXISTS `discount_code_history`;

CREATE TABLE `discount_code_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `discountCode` varchar(255) DEFAULT NULL,
  `whetherAdhoc` tinyint(1) DEFAULT NULL,
  `whetherFixedAmount` tinyint(1) DEFAULT NULL,
  `whetherPercentage` tinyint(1) DEFAULT NULL,
  `whetherRuleBased` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `discount_code_history` */

/*Table structure for table `distribution_list_cf_data_history` */

DROP TABLE IF EXISTS `distribution_list_cf_data_history`;

CREATE TABLE `distribution_list_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `distributionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `distribution_list_cf_data_history` */

/*Table structure for table `distribution_list_history` */

DROP TABLE IF EXISTS `distribution_list_history`;

CREATE TABLE `distribution_list_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `createdDate` date DEFAULT NULL,
  `distributionListType` varchar(255) DEFAULT NULL,
  `listName` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `whetherAutoApprove` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  `createdBy` bigint(20) DEFAULT NULL,
  `distributionModeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `distribution_list_history` */

/*Table structure for table `distribution_mode_history` */

DROP TABLE IF EXISTS `distribution_mode_history`;

CREATE TABLE `distribution_mode_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `modeName` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `distribution_mode_history` */

/*Table structure for table `document_rules_history` */

DROP TABLE IF EXISTS `document_rules_history`;

CREATE TABLE `document_rules_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `rule` varchar(255) DEFAULT NULL,
  `ruleDescription` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `serviceRequestSettingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `document_rules_history` */

/*Table structure for table `document_types_history` */

DROP TABLE IF EXISTS `document_types_history`;

CREATE TABLE `document_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `document_types_history` */

/*Table structure for table `documents_history` */

DROP TABLE IF EXISTS `documents_history`;

CREATE TABLE `documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `documentName` varchar(255) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `submissionDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `createdBy` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `documents_history` */

/*Table structure for table `draft_grade_distribution_history` */

DROP TABLE IF EXISTS `draft_grade_distribution_history`;

CREATE TABLE `draft_grade_distribution_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `distributionStatus` varchar(10) DEFAULT NULL,
  `entryDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  `evalDetailSequenceId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `enteredBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `draft_grade_distribution_history` */

/*Table structure for table `drop_down_history` */

DROP TABLE IF EXISTS `drop_down_history`;

CREATE TABLE `drop_down_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `drop_down_history` */

/*Table structure for table `education_data_to_be_changed_history` */

DROP TABLE IF EXISTS `education_data_to_be_changed_history`;

CREATE TABLE `education_data_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `educationalHistoryId` bigint(20) DEFAULT NULL,
  `examConductedBy` varchar(255) DEFAULT NULL,
  `examResult` varchar(255) DEFAULT NULL,
  `yearPassed` varchar(255) DEFAULT NULL,
  `examPassedId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FK152AEA737BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FK152AEA737BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `education_data_to_be_changed_history` */

/*Table structure for table `education_histories_history` */

DROP TABLE IF EXISTS `education_histories_history`;

CREATE TABLE `education_histories_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enrollmentNumber` varchar(255) DEFAULT NULL,
  `examConductedBy` varchar(255) DEFAULT NULL,
  `examResult` varchar(255) DEFAULT NULL,
  `whetherExistingStudent` tinyint(1) DEFAULT NULL,
  `yearPassed` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `examPassedId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `education_histories_history` */

/*Table structure for table `enq_address_history` */

DROP TABLE IF EXISTS `enq_address_history`;

CREATE TABLE `enq_address_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `addressCategory` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_address_history` */

/*Table structure for table `enq_assignment_hours_history` */

DROP TABLE IF EXISTS `enq_assignment_hours_history`;

CREATE TABLE `enq_assignment_hours_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `workingFromTime` time DEFAULT NULL,
  `workingToTime` time DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_assignment_hours_history` */

/*Table structure for table `enq_closure_reason_history` */

DROP TABLE IF EXISTS `enq_closure_reason_history`;

CREATE TABLE `enq_closure_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `closureDate` date DEFAULT NULL,
  `reasonRemark` varchar(255) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `enqAdmissionDetailsId` bigint(20) DEFAULT NULL,
  `closureReasonId` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  `enqStudentDetailsId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_closure_reason_history` */

/*Table structure for table `enq_default_user_history` */

DROP TABLE IF EXISTS `enq_default_user_history`;

CREATE TABLE `enq_default_user_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `defaultUserId` bigint(20) DEFAULT NULL,
  `enquiryTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_default_user_history` */

/*Table structure for table `enq_exams_details_history` */

DROP TABLE IF EXISTS `enq_exams_details_history`;

CREATE TABLE `enq_exams_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `examResult` varchar(10) DEFAULT NULL,
  `examStatus` varchar(5) DEFAULT NULL,
  `programConductedBy` varchar(100) DEFAULT NULL,
  `programExamType` varchar(35) DEFAULT NULL,
  `programYear` int(11) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `qualifyingProgramId` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_exams_details_history` */

/*Table structure for table `enq_followup_history` */

DROP TABLE IF EXISTS `enq_followup_history`;

CREATE TABLE `enq_followup_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actualFollowUpDate` date DEFAULT NULL,
  `followUpDate` date DEFAULT NULL,
  `followUpNo` smallint(6) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  `assignTo` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_followup_history` */

/*Table structure for table `enq_intermediate_type_history` */

DROP TABLE IF EXISTS `enq_intermediate_type_history`;

CREATE TABLE `enq_intermediate_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `whetherDefault` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_intermediate_type_history` */

/*Table structure for table `enq_negative_list_history` */

DROP TABLE IF EXISTS `enq_negative_list_history`;

CREATE TABLE `enq_negative_list_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `primaryeEmailId` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_negative_list_history` */

/*Table structure for table `enq_priority_history` */

DROP TABLE IF EXISTS `enq_priority_history`;

CREATE TABLE `enq_priority_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `priority` varchar(45) DEFAULT NULL,
  `whetherDefault` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_priority_history` */

/*Table structure for table `enq_program_master_history` */

DROP TABLE IF EXISTS `enq_program_master_history`;

CREATE TABLE `enq_program_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `programCode` varchar(45) DEFAULT NULL,
  `programName` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_program_master_history` */

/*Table structure for table `enq_referrer_type_history` */

DROP TABLE IF EXISTS `enq_referrer_type_history`;

CREATE TABLE `enq_referrer_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `referrerType` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_referrer_type_history` */

/*Table structure for table `enq_reopen_reason_history` */

DROP TABLE IF EXISTS `enq_reopen_reason_history`;

CREATE TABLE `enq_reopen_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `reasonRemark` varchar(255) DEFAULT NULL,
  `reopenDate` date DEFAULT NULL,
  `whethetDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `enqAdmissionDetailsId` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  `enqStudentDetailsId` bigint(20) DEFAULT NULL,
  `reopenReasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_reopen_reason_history` */

/*Table structure for table `enq_student_details_history` */

DROP TABLE IF EXISTS `enq_student_details_history`;

CREATE TABLE `enq_student_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applnAcademicYearFor` varchar(8) DEFAULT NULL,
  `bloodGroup` varchar(10) DEFAULT NULL,
  `fatherEmployed` tinyint(1) DEFAULT NULL,
  `fatherFirstName` varchar(35) DEFAULT NULL,
  `fatherLastName` varchar(35) DEFAULT NULL,
  `fatherMiddleName` varchar(35) DEFAULT NULL,
  `gender` varchar(6) DEFAULT NULL,
  `motherEmployed` tinyint(1) DEFAULT NULL,
  `motherFirstName` varchar(35) DEFAULT NULL,
  `motherLastName` varchar(35) DEFAULT NULL,
  `motherMiddleName` varchar(35) DEFAULT NULL,
  `studentDateOfBirth` date DEFAULT NULL,
  `studentFirstName` varchar(50) DEFAULT NULL,
  `studentLastName` varchar(50) DEFAULT NULL,
  `studentMiddleName` varchar(50) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `whetherSiblingStudying` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `sibiling1AdmissionId` bigint(20) DEFAULT NULL,
  `sibiling2AdmissionId` bigint(20) DEFAULT NULL,
  `sibiling3AdmissionId` bigint(20) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  `familyIncomeId` bigint(20) DEFAULT NULL,
  `reservationCategoryId` bigint(20) DEFAULT NULL,
  `fatherEmployeeId` bigint(20) DEFAULT NULL,
  `motherEmployeeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enq_student_details_history` */

/*Table structure for table `enquiry_cf_data_history` */

DROP TABLE IF EXISTS `enquiry_cf_data_history`;

CREATE TABLE `enquiry_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `enquiryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enquiry_cf_data_history` */

/*Table structure for table `enquiry_exam_detail_cf_data_history` */

DROP TABLE IF EXISTS `enquiry_exam_detail_cf_data_history`;

CREATE TABLE `enquiry_exam_detail_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `examDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enquiry_exam_detail_cf_data_history` */

/*Table structure for table `enquiry_history` */

DROP TABLE IF EXISTS `enquiry_history`;

CREATE TABLE `enquiry_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `categoryField1` varchar(15) DEFAULT NULL,
  `categoryField2` varchar(15) DEFAULT NULL,
  `categoryField3` varchar(15) DEFAULT NULL,
  `categoryField4` varchar(15) DEFAULT NULL,
  `categoryField5` varchar(15) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `enquiryDate` date DEFAULT NULL,
  `firstName` varchar(35) DEFAULT NULL,
  `followUpDate` date DEFAULT NULL,
  `lastName` varchar(35) DEFAULT NULL,
  `middleName` varchar(35) DEFAULT NULL,
  `noOfFollowup` int(11) DEFAULT NULL,
  `notificationError` varchar(1) DEFAULT NULL,
  `refUserName` varchar(50) DEFAULT NULL,
  `registeredByType` varchar(35) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(1) DEFAULT NULL,
  `timeTakenForCompletion` int(11) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `enqIntermediateStageId` bigint(20) DEFAULT NULL,
  `enqPriorityId` bigint(20) DEFAULT NULL,
  `enqReferrerTypeId` bigint(20) DEFAULT NULL,
  `enquirySourceId` bigint(20) DEFAULT NULL,
  `enquiryTypeId` bigint(20) DEFAULT NULL,
  `followUpUser` bigint(20) DEFAULT NULL,
  `refEnquirerId` bigint(20) DEFAULT NULL,
  `refUserId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `registeredBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enquiry_history` */

/*Table structure for table `enquiry_source_history` */

DROP TABLE IF EXISTS `enquiry_source_history`;

CREATE TABLE `enquiry_source_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enquirySource` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enquiry_source_history` */

/*Table structure for table `enquiry_student_address_history` */

DROP TABLE IF EXISTS `enquiry_student_address_history`;

CREATE TABLE `enquiry_student_address_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `enqStudentDetailsId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enquiry_student_address_history` */

/*Table structure for table `enquiry_type_history` */

DROP TABLE IF EXISTS `enquiry_type_history`;

CREATE TABLE `enquiry_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `enquiryTypeName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `enquiry_type_history` */

/*Table structure for table `entity_field_meta_data_history` */

DROP TABLE IF EXISTS `entity_field_meta_data_history`;

CREATE TABLE `entity_field_meta_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dataType` varchar(255) DEFAULT NULL,
  `displayCode` varchar(255) DEFAULT NULL,
  `displayOrder` bigint(20) DEFAULT NULL,
  `whetherMandatory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `entityTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `entity_field_meta_data_history` */

/*Table structure for table `entity_setting_history` */

DROP TABLE IF EXISTS `entity_setting_history`;

CREATE TABLE `entity_setting_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `defaultValue` varchar(50) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  `fieldCode` varchar(50) DEFAULT NULL,
  `fieldDataTypeCode` varchar(10) DEFAULT NULL,
  `fieldLabel` varchar(50) DEFAULT NULL,
  `mandatory` tinyint(1) DEFAULT NULL,
  `typeCode` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `entity_setting_history` */

/*Table structure for table `entity_type_history` */

DROP TABLE IF EXISTS `entity_type_history`;

CREATE TABLE `entity_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `entityCode` varchar(100) DEFAULT NULL,
  `displayCode` varchar(100) DEFAULT NULL,
  `entityName` varchar(100) DEFAULT NULL,
  `whetherConfigured` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `entity_type_history` */

/*Table structure for table `eval_group_center_history` */

DROP TABLE IF EXISTS `eval_group_center_history`;

CREATE TABLE `eval_group_center_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  `centerId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_group_center_history` */

/*Table structure for table `eval_group_criteria_history` */

DROP TABLE IF EXISTS `eval_group_criteria_history`;

CREATE TABLE `eval_group_criteria_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evalCriteria` varchar(35) DEFAULT NULL,
  `evalCriteriaQuery` varchar(255) DEFAULT NULL,
  `evalCriteriaStatus` tinyint(1) DEFAULT NULL,
  `evalCriteriaWaived` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_group_criteria_history` */

/*Table structure for table `eval_group_sch_date_history` */

DROP TABLE IF EXISTS `eval_group_sch_date_history`;

CREATE TABLE `eval_group_sch_date_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `scheduleDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_group_sch_date_history` */

/*Table structure for table `eval_group_seat_type_history` */

DROP TABLE IF EXISTS `eval_group_seat_type_history`;

CREATE TABLE `eval_group_seat_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_group_seat_type_history` */

/*Table structure for table `eval_group_sequences_history` */

DROP TABLE IF EXISTS `eval_group_sequences_history`;

CREATE TABLE `eval_group_sequences_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centers` varchar(4) DEFAULT NULL,
  `disableTimeSlot` varchar(255) DEFAULT NULL,
  `evaluationStage` varchar(45) DEFAULT NULL,
  `whetherCourseOrganazationCategory` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `categoryId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  `externalCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_group_sequences_history` */

/*Table structure for table `eval_seq_detail_history` */

DROP TABLE IF EXISTS `eval_seq_detail_history`;

CREATE TABLE `eval_seq_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `detailSequenceDesc` varchar(255) DEFAULT NULL,
  `detailSequenceNumber` varchar(45) DEFAULT NULL,
  `evalInMarksOrGrade` varchar(45) DEFAULT NULL,
  `exceptionRuleAgenda` varchar(255) DEFAULT NULL,
  `exceptionRuleAgendaDescription` varchar(255) DEFAULT NULL,
  `feeBillingDate` date DEFAULT NULL,
  `feedbackQuestionnaire` varchar(45) DEFAULT NULL,
  `gradeType` varchar(45) DEFAULT NULL,
  `mandatoryForAttendance` tinyint(1) DEFAULT NULL,
  `mandatoryForEvaluation` tinyint(1) DEFAULT NULL,
  `maxGrade` varchar(255) DEFAULT NULL,
  `maxMarks` int(11) DEFAULT NULL,
  `maxMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `minGrade` varchar(255) DEFAULT NULL,
  `minMarks` int(11) DEFAULT NULL,
  `minMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `modeOfAdministration` varchar(45) DEFAULT NULL,
  `noOfQPRequired` int(11) DEFAULT NULL,
  `notificationNoOfDays` int(11) DEFAULT NULL,
  `notificationType` varchar(45) DEFAULT NULL,
  `partOfEvaluationGroup` tinyint(1) DEFAULT NULL,
  `plannedDate` date DEFAULT NULL,
  `plannedOn` datetime DEFAULT NULL,
  `plannedTill` datetime DEFAULT NULL,
  `randomSelectionApplicable` tinyint(1) DEFAULT NULL,
  `revaluationType` varchar(45) DEFAULT NULL,
  `starttime` datetime DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `testAdministrationMode` varchar(45) DEFAULT NULL,
  `timeInMinutes` int(11) DEFAULT NULL,
  `weightage` int(11) DEFAULT NULL,
  `whetherAnsAvailableForReview` tinyint(1) DEFAULT NULL,
  `whetherBatches` tinyint(1) DEFAULT NULL,
  `whetherDetailSeqEquivalent` tinyint(1) DEFAULT NULL,
  `whetherEvalAnonymous` tinyint(1) DEFAULT NULL,
  `whetherExceptionToTime` tinyint(1) DEFAULT NULL,
  `whetherLimitedSetOfStudent` tinyint(1) DEFAULT NULL,
  `whetherObjectTypeQuestions` tinyint(1) DEFAULT NULL,
  `whetherPassingCritical` tinyint(1) DEFAULT NULL,
  `whetherPrimaryDetailSequence` tinyint(1) DEFAULT NULL,
  `whetherResultApproved` tinyint(1) DEFAULT NULL,
  `whetherShowInMarksheet` tinyint(1) DEFAULT NULL,
  `whetherSurpriseTest` tinyint(1) DEFAULT NULL,
  `whetherWrittenTest` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  `evalDetailSeqEquivalentId` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `secondaryDetailSequenceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_seq_detail_history` */

/*Table structure for table `eval_sequence_logistics_history` */

DROP TABLE IF EXISTS `eval_sequence_logistics_history`;

CREATE TABLE `eval_sequence_logistics_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceRelevant` tinyint(1) DEFAULT NULL,
  `centerLogisticsRequired` tinyint(1) DEFAULT NULL,
  `questionaPaperRequired` tinyint(1) DEFAULT NULL,
  `staffLogisticRequired` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_sequence_logistics_history` */

/*Table structure for table `eval_sequence_rules_history` */

DROP TABLE IF EXISTS `eval_sequence_rules_history`;

CREATE TABLE `eval_sequence_rules_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `ruleDescription` varchar(255) DEFAULT NULL,
  `ruleName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseEvalQuePaperId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `eval_sequence_rules_history` */

/*Table structure for table `evaluation_group_applicant_document_history` */

DROP TABLE IF EXISTS `evaluation_group_applicant_document_history`;

CREATE TABLE `evaluation_group_applicant_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `evaluationGroupDocumentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_group_applicant_document_history` */

/*Table structure for table `evaluation_group_applicant_history` */

DROP TABLE IF EXISTS `evaluation_group_applicant_history`;

CREATE TABLE `evaluation_group_applicant_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicationNumber` varchar(255) DEFAULT NULL,
  `applicationStatus` varchar(100) DEFAULT NULL,
  `centerStatus` varchar(100) DEFAULT NULL,
  `hallticket` varchar(255) DEFAULT NULL,
  `roomAllocationStatus` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_group_applicant_history` */

/*Table structure for table `evaluation_group_applicant_sequence_history` */

DROP TABLE IF EXISTS `evaluation_group_applicant_sequence_history`;

CREATE TABLE `evaluation_group_applicant_sequence_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupApplicantId` bigint(20) DEFAULT NULL,
  `evaluationDetailSequenceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_group_applicant_sequence_history` */

/*Table structure for table `evaluation_group_center_master_history` */

DROP TABLE IF EXISTS `evaluation_group_center_master_history`;

CREATE TABLE `evaluation_group_center_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `centerId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_group_center_master_history` */

/*Table structure for table `evaluation_group_document_history` */

DROP TABLE IF EXISTS `evaluation_group_document_history`;

CREATE TABLE `evaluation_group_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `documentType` varchar(45) DEFAULT NULL,
  `droolsRule` varchar(255) DEFAULT NULL,
  `droolsRuleDescription` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_group_document_history` */

/*Table structure for table `evaluation_group_history` */

DROP TABLE IF EXISTS `evaluation_group_history`;

CREATE TABLE `evaluation_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `ageMax` int(11) DEFAULT NULL,
  `ageMin` int(11) DEFAULT NULL,
  `applicationFlag` varchar(255) DEFAULT NULL,
  `applicationStartDate` date DEFAULT NULL,
  `applicationTillDate` date DEFAULT NULL,
  `centerType` varchar(255) DEFAULT NULL,
  `droolsRuleRanking` varchar(255) DEFAULT NULL,
  `droolsRuleRankingDescription` varchar(255) DEFAULT NULL,
  `durationOfEachBatch` int(11) DEFAULT NULL,
  `entryCriteria` varchar(255) DEFAULT NULL,
  `entryCriteriaDescription` varchar(255) DEFAULT NULL,
  `evaluationGroupCode` varchar(255) DEFAULT NULL,
  `evaluationGroupStatus` varchar(255) DEFAULT NULL,
  `evaluationStage` varchar(45) DEFAULT NULL,
  `examdateFrom` date DEFAULT NULL,
  `examdateTill` date DEFAULT NULL,
  `exitCriteria` varchar(255) DEFAULT NULL,
  `exitCriteriaDescription` varchar(255) DEFAULT NULL,
  `feePlanBillingDate` date DEFAULT NULL,
  `hallTicketGenerationRequired` tinyint(1) DEFAULT NULL,
  `intervalBetweenBatches` int(11) DEFAULT NULL,
  `maxAttempts` int(11) DEFAULT NULL,
  `numberOfBatchesInADay` int(11) DEFAULT NULL,
  `startTimeOfFirstBatch` datetime DEFAULT NULL,
  `studentCanChoosePartOfEvaluationGroup` tinyint(1) DEFAULT NULL,
  `studentRescheduleTillDate` date DEFAULT NULL,
  `whetherMultipleBatches` tinyint(1) DEFAULT NULL,
  `whetherOnlineSubmission` tinyint(1) DEFAULT NULL,
  `whetherResultsApproved` tinyint(1) DEFAULT NULL,
  `whetherStudentReschedule` tinyint(1) DEFAULT NULL,
  `whetherStudentSelectCenter` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approverId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `hallTicketDistributionModeId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_group_history` */

/*Table structure for table `evaluation_plan_batches_history` */

DROP TABLE IF EXISTS `evaluation_plan_batches_history`;

CREATE TABLE `evaluation_plan_batches_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_batches_history` */

/*Table structure for table `evaluation_plan_history` */

DROP TABLE IF EXISTS `evaluation_plan_history`;

CREATE TABLE `evaluation_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationPlanNumber` varchar(255) DEFAULT NULL,
  `evaluationPlanType` varchar(45) DEFAULT NULL,
  `evaluationStage` varchar(45) DEFAULT NULL,
  `externalOrganizationName` varchar(50) DEFAULT NULL,
  `isWeightagesRelevant` tinyint(1) DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `whetherInheritplan` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `inheritFromEvaluationPlan` bigint(20) DEFAULT NULL,
  `categoryId` bigint(20) DEFAULT NULL,
  `externalCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_history` */

/*Table structure for table `evaluation_plan_level_one_history` */

DROP TABLE IF EXISTS `evaluation_plan_level_one_history`;

CREATE TABLE `evaluation_plan_level_one_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `gradeType` varchar(255) DEFAULT NULL,
  `levelName` varchar(100) DEFAULT NULL,
  `levelValue` int(11) DEFAULT NULL,
  `marksOrGrade` varchar(255) DEFAULT NULL,
  `maxMarksOrGrade` varchar(255) DEFAULT NULL,
  `maxMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `minMarksOrGrade` varchar(255) DEFAULT NULL,
  `minMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `whetherPassingCritical` tinyint(1) DEFAULT NULL,
  `whetherShowInMarksheet` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_level_one_history` */

/*Table structure for table `evaluation_plan_level_one_rank_history` */

DROP TABLE IF EXISTS `evaluation_plan_level_one_rank_history`;

CREATE TABLE `evaluation_plan_level_one_rank_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveMarks` double DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `gradePoint` double DEFAULT NULL,
  `marksObtainedFrom` bigint(20) DEFAULT NULL,
  `obtainedMarks` double DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evaluationPlanLevelOneId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_level_one_rank_history` */

/*Table structure for table `evaluation_plan_level_two_history` */

DROP TABLE IF EXISTS `evaluation_plan_level_two_history`;

CREATE TABLE `evaluation_plan_level_two_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `gradeType` varchar(255) DEFAULT NULL,
  `levelName` varchar(100) DEFAULT NULL,
  `levelValue` int(11) DEFAULT NULL,
  `marksOrGrade` varchar(255) DEFAULT NULL,
  `maxMarksOrGrade` varchar(255) DEFAULT NULL,
  `maxMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `minMarksOrGrade` varchar(255) DEFAULT NULL,
  `minMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `whetherPassingCritical` tinyint(1) DEFAULT NULL,
  `whetherShowInMarksheet` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalPlanLevelOneId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_level_two_history` */

/*Table structure for table `evaluation_plan_level_two_rank_history` */

DROP TABLE IF EXISTS `evaluation_plan_level_two_rank_history`;

CREATE TABLE `evaluation_plan_level_two_rank_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveMarks` double DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `gradePoint` double DEFAULT NULL,
  `marksObtainedFrom` bigint(20) DEFAULT NULL,
  `obtainedMarks` double DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evaluationPlanLevelTwoId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_level_two_rank_history` */

/*Table structure for table `evaluation_plan_other_category_history` */

DROP TABLE IF EXISTS `evaluation_plan_other_category_history`;

CREATE TABLE `evaluation_plan_other_category_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `categoryName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_other_category_history` */

/*Table structure for table `evaluation_plan_other_sub_category_history` */

DROP TABLE IF EXISTS `evaluation_plan_other_sub_category_history`;

CREATE TABLE `evaluation_plan_other_sub_category_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `subCategoryName` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `categoryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_other_sub_category_history` */

/*Table structure for table `evaluation_plan_rank_history` */

DROP TABLE IF EXISTS `evaluation_plan_rank_history`;

CREATE TABLE `evaluation_plan_rank_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveMarks` double DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `gradePoint` double DEFAULT NULL,
  `marksObtainedFrom` bigint(20) DEFAULT NULL,
  `obtainedMarks` double DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_rank_history` */

/*Table structure for table `evaluation_plan_students_history` */

DROP TABLE IF EXISTS `evaluation_plan_students_history`;

CREATE TABLE `evaluation_plan_students_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `groupNumber` varchar(255) DEFAULT NULL,
  `plannedDate` date DEFAULT NULL,
  `plannedTime` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_students_history` */

/*Table structure for table `evaluation_plan_topic_history` */

DROP TABLE IF EXISTS `evaluation_plan_topic_history`;

CREATE TABLE `evaluation_plan_topic_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `maxMarks` int(11) DEFAULT NULL,
  `minMarks` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_plan_topic_history` */

/*Table structure for table `evaluation_program_rank_history` */

DROP TABLE IF EXISTS `evaluation_program_rank_history`;

CREATE TABLE `evaluation_program_rank_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `CGPA` double DEFAULT NULL,
  `evaluationPlanType` varchar(255) DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `gradePoint` double DEFAULT NULL,
  `marksObtainedFrom` bigint(20) DEFAULT NULL,
  `obtainedMarks` double DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `SGPA` double DEFAULT NULL,
  `stage` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `programBatchPeriodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_program_rank_history` */

/*Table structure for table `evaluation_rule_history` */

DROP TABLE IF EXISTS `evaluation_rule_history`;

CREATE TABLE `evaluation_rule_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `businessRule` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ruleName` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `ruleAppliedForLevelFour` bigint(20) DEFAULT NULL,
  `ruleAppliedForLevelOne` bigint(20) DEFAULT NULL,
  `ruleAppliedForLevelThree` bigint(20) DEFAULT NULL,
  `ruleAppliedForLevelTwo` bigint(20) DEFAULT NULL,
  `ruleAppliedForLevelZero` bigint(20) DEFAULT NULL,
  `ruleAppliedOnLevelFour` bigint(20) DEFAULT NULL,
  `ruleAppliedOnLevelOne` bigint(20) DEFAULT NULL,
  `ruleAppliedOnLevelThree` bigint(20) DEFAULT NULL,
  `ruleAppliedOnLevelTwo` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_rule_history` */

/*Table structure for table `evaluation_sec_sequences_history` */

DROP TABLE IF EXISTS `evaluation_sec_sequences_history`;

CREATE TABLE `evaluation_sec_sequences_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `sequenceName` varchar(30) DEFAULT NULL,
  `sequenceShortName` varchar(6) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_sec_sequences_history` */

/*Table structure for table `evaluation_sequence_history` */

DROP TABLE IF EXISTS `evaluation_sequence_history`;

CREATE TABLE `evaluation_sequence_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evalSequenceWeightage` int(11) DEFAULT NULL,
  `gradeType` varchar(255) DEFAULT NULL,
  `marksOrGrade` varchar(255) DEFAULT NULL,
  `maxMarksOrGrade` varchar(255) DEFAULT NULL,
  `maxMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `minMarksOrGrade` varchar(255) DEFAULT NULL,
  `minMarksOrGradeAward` varchar(255) DEFAULT NULL,
  `numberOfAssessments` int(11) DEFAULT NULL,
  `numberOfAssessmentsClosed` int(11) DEFAULT NULL,
  `numberOfAssessmentsCompleted` int(11) DEFAULT NULL,
  `regularDroolsRule` varchar(255) DEFAULT NULL,
  `regularDroolsRuleDesc` varchar(255) DEFAULT NULL,
  `repetitionDroolsRule` varchar(255) DEFAULT NULL,
  `repetitionDroolsRuleDesc` varchar(255) DEFAULT NULL,
  `whetherAttendanceRelevant` tinyint(1) DEFAULT NULL,
  `whetherExamCenterLogistics` tinyint(1) DEFAULT NULL,
  `whetherPassingCritical` tinyint(1) DEFAULT NULL,
  `whetherQPApplicable` tinyint(1) DEFAULT NULL,
  `whetherShowInMarksheet` tinyint(1) DEFAULT NULL,
  `whetherStaffLogistics` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalPlanLevelTwoId` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_sequence_history` */

/*Table structure for table `evaluation_sequence_rank_history` */

DROP TABLE IF EXISTS `evaluation_sequence_rank_history`;

CREATE TABLE `evaluation_sequence_rank_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `effectiveMarks` double DEFAULT NULL,
  `grade` varchar(255) DEFAULT NULL,
  `gradePoint` double DEFAULT NULL,
  `marksObtainedFrom` bigint(20) DEFAULT NULL,
  `obtainedMarks` double DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evaluationSequenceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_sequence_rank_history` */

/*Table structure for table `evaluation_sub_type_history` */

DROP TABLE IF EXISTS `evaluation_sub_type_history`;

CREATE TABLE `evaluation_sub_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationSubType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_sub_type_history` */

/*Table structure for table `evaluation_type_course_history` */

DROP TABLE IF EXISTS `evaluation_type_course_history`;

CREATE TABLE `evaluation_type_course_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `completionStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_type_course_history` */

/*Table structure for table `evaluation_type_history` */

DROP TABLE IF EXISTS `evaluation_type_history`;

CREATE TABLE `evaluation_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_type_history` */

/*Table structure for table `evaluation_type_program_history` */

DROP TABLE IF EXISTS `evaluation_type_program_history`;

CREATE TABLE `evaluation_type_program_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `completionStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `evaluation_type_program_history` */

/*Table structure for table `exam_center_history` */

DROP TABLE IF EXISTS `exam_center_history`;

CREATE TABLE `exam_center_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `allowAllocationBySupervisor` tinyint(1) DEFAULT NULL,
  `centerCapacity` int(11) DEFAULT NULL,
  `centerName` varchar(100) DEFAULT NULL,
  `centerType` varchar(150) DEFAULT NULL,
  `centreCode` varchar(6) DEFAULT NULL,
  `noOfRooms` int(11) DEFAULT NULL,
  `stageType` varchar(20) DEFAULT NULL,
  `whetherActive` tinyint(1) DEFAULT NULL,
  `whetherRoomCapacitySame` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `centerAddressId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  `resourceTypeId` bigint(20) DEFAULT NULL,
  `centerResponsibleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_center_history` */

/*Table structure for table `exam_centre_change_req_types_history` */

DROP TABLE IF EXISTS `exam_centre_change_req_types_history`;

CREATE TABLE `exam_centre_change_req_types_history` (
  `examRequestTypeDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `currentExamBatchId` bigint(20) DEFAULT NULL,
  `currentExamCentreId` bigint(20) DEFAULT NULL,
  `expectedExamBatchId` bigint(20) DEFAULT NULL,
  `expectedExamCentreId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`examRequestTypeDetailId`,`REV`),
  KEY `FK252E9BE27BF72940` (`examRequestTypeDetailId`,`REV`),
  CONSTRAINT `FK252E9BE27BF72940` FOREIGN KEY (`examRequestTypeDetailId`, `REV`) REFERENCES `exam_request_type_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_centre_change_req_types_history` */

/*Table structure for table `exam_date_change_req_types_history` */

DROP TABLE IF EXISTS `exam_date_change_req_types_history`;

CREATE TABLE `exam_date_change_req_types_history` (
  `examRequestTypeDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `expectedExamDate` datetime DEFAULT NULL,
  `currentExamBatchId` bigint(20) DEFAULT NULL,
  `expectedExamBatchId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`examRequestTypeDetailId`,`REV`),
  KEY `FK42D3956F7BF72940` (`examRequestTypeDetailId`,`REV`),
  CONSTRAINT `FK42D3956F7BF72940` FOREIGN KEY (`examRequestTypeDetailId`, `REV`) REFERENCES `exam_request_type_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_date_change_req_types_history` */

/*Table structure for table `exam_leave_req_types_history` */

DROP TABLE IF EXISTS `exam_leave_req_types_history`;

CREATE TABLE `exam_leave_req_types_history` (
  `examRequestTypeDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `currentExamCentreId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`examRequestTypeDetailId`,`REV`),
  KEY `FK60D221457BF72940` (`examRequestTypeDetailId`,`REV`),
  CONSTRAINT `FK60D221457BF72940` FOREIGN KEY (`examRequestTypeDetailId`, `REV`) REFERENCES `exam_request_type_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_leave_req_types_history` */

/*Table structure for table `exam_leave_request_details_history` */

DROP TABLE IF EXISTS `exam_leave_request_details_history`;

CREATE TABLE `exam_leave_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centerType` varchar(255) DEFAULT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `examLeaveReason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `currentExamCentreId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_leave_request_details_history` */

/*Table structure for table `exam_logistics_details_history` */

DROP TABLE IF EXISTS `exam_logistics_details_history`;

CREATE TABLE `exam_logistics_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evalQuestionPaper` varchar(6) DEFAULT NULL,
  `noOfQPapersIssued` int(11) DEFAULT NULL,
  `noOfQuestionPaperReturned` int(11) DEFAULT NULL,
  `NoOfQuestionPapersUsed` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `logisticId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_logistics_details_history` */

/*Table structure for table `exam_logistics_history` */

DROP TABLE IF EXISTS `exam_logistics_history`;

CREATE TABLE `exam_logistics_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centerType` varchar(18) DEFAULT NULL,
  `logisticDate` date DEFAULT NULL,
  `timeSlot` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  `centerId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_logistics_history` */

/*Table structure for table `exam_malpractice_type_history` */

DROP TABLE IF EXISTS `exam_malpractice_type_history`;

CREATE TABLE `exam_malpractice_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `malPracticeType` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_malpractice_type_history` */

/*Table structure for table `exam_paper_reval_req_types_history` */

DROP TABLE IF EXISTS `exam_paper_reval_req_types_history`;

CREATE TABLE `exam_paper_reval_req_types_history` (
  `examRequestTypeDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `whetherCompletePaper` tinyint(1) DEFAULT NULL,
  `questionNo` varchar(255) DEFAULT NULL,
  `questionNoPart` varchar(255) DEFAULT NULL,
  `questionNoPart1` varchar(255) DEFAULT NULL,
  `totalMarks` int(11) DEFAULT NULL,
  PRIMARY KEY (`examRequestTypeDetailId`,`REV`),
  KEY `FKC389BD297BF72940` (`examRequestTypeDetailId`,`REV`),
  CONSTRAINT `FKC389BD297BF72940` FOREIGN KEY (`examRequestTypeDetailId`, `REV`) REFERENCES `exam_request_type_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_paper_reval_req_types_history` */

/*Table structure for table `exam_passed_history` */

DROP TABLE IF EXISTS `exam_passed_history`;

CREATE TABLE `exam_passed_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_passed_history` */

/*Table structure for table `exam_related_request_details_history` */

DROP TABLE IF EXISTS `exam_related_request_details_history`;

CREATE TABLE `exam_related_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `requestTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_related_request_details_history` */

/*Table structure for table `exam_request_type_details_history` */

DROP TABLE IF EXISTS `exam_request_type_details_history`;

CREATE TABLE `exam_request_type_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `examRequestType` varchar(255) DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_request_type_details_history` */

/*Table structure for table `exam_room_allocation_history` */

DROP TABLE IF EXISTS `exam_room_allocation_history`;

CREATE TABLE `exam_room_allocation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `externalRoomId` bigint(20) DEFAULT NULL,
  `groupDateBatchCenterId` bigint(20) DEFAULT NULL,
  `internalRoomId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_room_allocation_history` */

/*Table structure for table `exam_room_invigilator_allocation_history` */

DROP TABLE IF EXISTS `exam_room_invigilator_allocation_history`;

CREATE TABLE `exam_room_invigilator_allocation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roomAllocationId` bigint(20) DEFAULT NULL,
  `InvigilatorId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_room_invigilator_allocation_history` */

/*Table structure for table `exam_room_student_allocation_history` */

DROP TABLE IF EXISTS `exam_room_student_allocation_history`;

CREATE TABLE `exam_room_student_allocation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roomAllocationId` bigint(20) DEFAULT NULL,
  `timeSlotId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_room_student_allocation_history` */

/*Table structure for table `exam_timeslot_history` */

DROP TABLE IF EXISTS `exam_timeslot_history`;

CREATE TABLE `exam_timeslot_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `centerId` bigint(20) DEFAULT NULL,
  `groupDateBatchCenterId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_timeslot_history` */

/*Table structure for table `exam_withdrawal_request_details_history` */

DROP TABLE IF EXISTS `exam_withdrawal_request_details_history`;

CREATE TABLE `exam_withdrawal_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centerType` varchar(255) DEFAULT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `examWithdrawalReason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `currentExamCentreId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `exam_withdrawal_request_details_history` */

/*Table structure for table `examination_repetition_history` */

DROP TABLE IF EXISTS `examination_repetition_history`;

CREATE TABLE `examination_repetition_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvalStatus` varchar(255) DEFAULT NULL,
  `courseCompletionStatus` varchar(45) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `repetitionFor` varchar(45) DEFAULT NULL,
  `repetitionType` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `approvedById` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `equivEvalDetailSeqId` bigint(20) DEFAULT NULL,
  `evalDetailSeqId` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `repetitionCourseVariantId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `examination_repetition_history` */

/*Table structure for table `examination_request_history` */

DROP TABLE IF EXISTS `examination_request_history`;

CREATE TABLE `examination_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `examRequestType` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `executionRequestId` bigint(20) DEFAULT NULL,
  `requestFollowUpId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `examination_request_history` */

/*Table structure for table `examination_result_history` */

DROP TABLE IF EXISTS `examination_result_history`;

CREATE TABLE `examination_result_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicationNumber` varchar(255) DEFAULT NULL,
  `applicationStatus` varchar(100) DEFAULT NULL,
  `centerStatus` varchar(100) DEFAULT NULL,
  `effectiveMarks` double DEFAULT NULL,
  `evaluationGroupStatus` varchar(100) DEFAULT NULL,
  `examResultStatus` varchar(255) DEFAULT NULL,
  `examinorRemark` varchar(255) DEFAULT NULL,
  `feesStatus` varchar(100) DEFAULT NULL,
  `finalDescription` varchar(255) DEFAULT NULL,
  `finalGrade` varchar(255) DEFAULT NULL,
  `finalMarks` double DEFAULT NULL,
  `graceMarksGiven` double DEFAULT NULL,
  `gradePoints` double DEFAULT NULL,
  `hallticket` varchar(255) DEFAULT NULL,
  `malPracticeAction` varchar(255) DEFAULT NULL,
  `netMarksGiven` double DEFAULT NULL,
  `penultyMarksGiven` double DEFAULT NULL,
  `questionPaperCode` varchar(6) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `revaluerRemark` varchar(255) DEFAULT NULL,
  `reviewerRemark` varchar(255) DEFAULT NULL,
  `roomAllocationStatus` varchar(100) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `totalMarksGiven` double DEFAULT NULL,
  `whetherExamAttended` tinyint(1) DEFAULT NULL,
  `whetherMalpracticeReported` tinyint(1) DEFAULT NULL,
  `whetherRevaluation` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evaluationDetailSequenceId` bigint(20) DEFAULT NULL,
  `logisticId` bigint(20) DEFAULT NULL,
  `malpracticeTypeId` bigint(20) DEFAULT NULL,
  `malPracticeReportedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `examination_result_history` */

/*Table structure for table `examiner_allocation_history` */

DROP TABLE IF EXISTS `examiner_allocation_history`;

CREATE TABLE `examiner_allocation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalPlanDetailSeqId` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `examiner_allocation_history` */

/*Table structure for table `examiner_feedback_history` */

DROP TABLE IF EXISTS `examiner_feedback_history`;

CREATE TABLE `examiner_feedback_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationPlanType` varchar(10) DEFAULT NULL,
  `feedbackPattern` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationSeqId` bigint(20) DEFAULT NULL,
  `evalTypeId` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `examiner_feedback_history` */

/*Table structure for table `execution_details_history` */

DROP TABLE IF EXISTS `execution_details_history`;

CREATE TABLE `execution_details_history` (
  `type` varchar(31) NOT NULL,
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `executionDate` datetime DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `closureReasonId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `handoverDate` datetime DEFAULT NULL,
  `handoverModeId` bigint(20) DEFAULT NULL,
  `whetherPartlyWaived` tinyint(1) DEFAULT NULL,
  `waiverAmount` decimal(3,2) DEFAULT NULL,
  `waiverPercentage` decimal(19,2) DEFAULT NULL,
  `whetherApproved` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `execution_details_history` */

/*Table structure for table `execution_request_history` */

DROP TABLE IF EXISTS `execution_request_history`;

CREATE TABLE `execution_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `closureReason` int(11) DEFAULT NULL,
  `closureRemarks` varchar(255) DEFAULT NULL,
  `followupCommonId` int(11) DEFAULT NULL,
  `requestExecutionMode` int(11) DEFAULT NULL,
  `requestExecutionOn` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `execution_request_history` */

/*Table structure for table `experience_types_history` */

DROP TABLE IF EXISTS `experience_types_history`;

CREATE TABLE `experience_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `experience_types_history` */

/*Table structure for table `extended_documents_history` */

DROP TABLE IF EXISTS `extended_documents_history`;

CREATE TABLE `extended_documents_history` (
  `documentId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `inspectionDate` date DEFAULT NULL,
  `whetherElectronic` tinyint(1) DEFAULT NULL,
  `whetherInspectionDone` tinyint(1) DEFAULT NULL,
  `whetherInspectionRequired` tinyint(1) DEFAULT NULL,
  `whetherReturnable` tinyint(1) DEFAULT NULL,
  `modeOfReturn` varchar(255) DEFAULT NULL,
  `modeOfSubmission` varchar(255) DEFAULT NULL,
  `returnedDate` datetime DEFAULT NULL,
  `returnedToName` varchar(255) DEFAULT NULL,
  `validTillDate` datetime DEFAULT NULL,
  `inspectionDoneBy` bigint(20) DEFAULT NULL,
  `responsibleUserId` bigint(20) DEFAULT NULL,
  `returnedBy` bigint(20) DEFAULT NULL,
  `returnedToUserId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`documentId`,`REV`),
  KEY `FK78338087891B54A2` (`documentId`,`REV`),
  CONSTRAINT `FK78338087891B54A2` FOREIGN KEY (`documentId`, `REV`) REFERENCES `documents_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `extended_documents_history` */

/*Table structure for table `external_course_assessment_history` */

DROP TABLE IF EXISTS `external_course_assessment_history`;

CREATE TABLE `external_course_assessment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `assessmentType` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `externalCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `external_course_assessment_history` */

/*Table structure for table `external_course_master_history` */

DROP TABLE IF EXISTS `external_course_master_history`;

CREATE TABLE `external_course_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `externalCourseCode` varchar(45) DEFAULT NULL,
  `externalCourseName` varchar(255) DEFAULT NULL,
  `externalOrganizationName` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `external_course_master_history` */

/*Table structure for table `external_resources_history` */

DROP TABLE IF EXISTS `external_resources_history`;

CREATE TABLE `external_resources_history` (
  `resourceId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `concernedPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`resourceId`,`REV`),
  KEY `FKED276506AA5F9848` (`resourceId`,`REV`),
  CONSTRAINT `FKED276506AA5F9848` FOREIGN KEY (`resourceId`, `REV`) REFERENCES `resources_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `external_resources_history` */

/*Table structure for table `extracurricular_activity_history` */

DROP TABLE IF EXISTS `extracurricular_activity_history`;

CREATE TABLE `extracurricular_activity_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `activityName` varchar(255) DEFAULT NULL,
  `activityYear` int(11) DEFAULT NULL,
  `whetherCurrentOrganization` tinyint(1) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `performance` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `activityType` bigint(20) DEFAULT NULL,
  `communityId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `extracurricular_activity_history` */

/*Table structure for table `extracurricular_to_be_changed_history` */

DROP TABLE IF EXISTS `extracurricular_to_be_changed_history`;

CREATE TABLE `extracurricular_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `activityName` varchar(255) DEFAULT NULL,
  `activityTypeId` bigint(20) DEFAULT NULL,
  `activityYear` int(11) DEFAULT NULL,
  `communityId` bigint(20) DEFAULT NULL,
  `extraCurricularActivityId` bigint(20) DEFAULT NULL,
  `whetherCurrentOrganization` tinyint(1) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `performance` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FK10B946367BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FK10B946367BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `extracurricular_to_be_changed_history` */

/*Table structure for table `fac_course_account_detail_history` */

DROP TABLE IF EXISTS `fac_course_account_detail_history`;

CREATE TABLE `fac_course_account_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountMappingBasic` varchar(35) DEFAULT NULL,
  `controlAccount` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fac_course_account_detail_history` */

/*Table structure for table `fac_course_comp_acc_detail_history` */

DROP TABLE IF EXISTS `fac_course_comp_acc_detail_history`;

CREATE TABLE `fac_course_comp_acc_detail_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountMappingBasic` varchar(35) DEFAULT NULL,
  `controlAccount` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fac_course_comp_acc_detail_history` */

/*Table structure for table `fac_data_change_request_history` */

DROP TABLE IF EXISTS `fac_data_change_request_history`;

CREATE TABLE `fac_data_change_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `changeDays` tinyint(4) DEFAULT NULL,
  `changeDescriptions` varchar(255) DEFAULT NULL,
  `changeDocuments` varchar(40) DEFAULT NULL,
  `changeDocumentsProofGiven` tinyint(1) DEFAULT NULL,
  `changeDocumentsProofReqd` tinyint(1) DEFAULT NULL,
  `changeStatusActive` tinyint(1) DEFAULT NULL,
  `closedOn` date DEFAULT NULL,
  `closureReason` varchar(3) DEFAULT NULL,
  `dataGrouptoChange` varchar(2) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `requestDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fac_data_change_request_history` */

/*Table structure for table `fac_default_control_account_history` */

DROP TABLE IF EXISTS `fac_default_control_account_history`;

CREATE TABLE `fac_default_control_account_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountMappingBasic` varchar(35) DEFAULT NULL,
  `controlAccount` int(11) DEFAULT NULL,
  `facultyType` varchar(2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `facultyAccountId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fac_default_control_account_history` */

/*Table structure for table `fac_perform_param_history` */

DROP TABLE IF EXISTS `fac_perform_param_history`;

CREATE TABLE `fac_perform_param_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `parameterName` varchar(100) DEFAULT NULL,
  `parameterValue` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fac_perform_param_history` */

/*Table structure for table `fac_type_account_details_history` */

DROP TABLE IF EXISTS `fac_type_account_details_history`;

CREATE TABLE `fac_type_account_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `facultyType` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fac_type_account_details_history` */

/*Table structure for table `faculty_account_history` */

DROP TABLE IF EXISTS `faculty_account_history`;

CREATE TABLE `faculty_account_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `individualControlAccountFlag` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountconfigId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_account_history` */

/*Table structure for table `faculty_attendance_dashboard_date_wise_history` */

DROP TABLE IF EXISTS `faculty_attendance_dashboard_date_wise_history`;

CREATE TABLE `faculty_attendance_dashboard_date_wise_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `absentPercentage` int(11) DEFAULT NULL,
  `absentRecords` bigint(20) DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `presentPercentage` int(11) DEFAULT NULL,
  `presentRecords` bigint(20) DEFAULT NULL,
  `totalRecords` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_attendance_dashboard_date_wise_history` */

/*Table structure for table `faculty_attendance_dashboard_faculty_wise_history` */

DROP TABLE IF EXISTS `faculty_attendance_dashboard_faculty_wise_history`;

CREATE TABLE `faculty_attendance_dashboard_faculty_wise_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `absentPercentage` int(11) DEFAULT NULL,
  `absentRecords` bigint(20) DEFAULT NULL,
  `presentPercentage` int(11) DEFAULT NULL,
  `presentRecords` bigint(20) DEFAULT NULL,
  `totalRecords` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_attendance_dashboard_faculty_wise_history` */

/*Table structure for table `faculty_cheques_history` */

DROP TABLE IF EXISTS `faculty_cheques_history`;

CREATE TABLE `faculty_cheques_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `checkDate` date DEFAULT NULL,
  `drawnOn` varchar(100) DEFAULT NULL,
  `installmentNo` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_cheques_history` */

/*Table structure for table `faculty_course_attendance_details_history` */

DROP TABLE IF EXISTS `faculty_course_attendance_details_history`;

CREATE TABLE `faculty_course_attendance_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceStatus` varchar(45) DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `updatedAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `attendanceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_course_attendance_details_history` */

/*Table structure for table `faculty_course_attendance_history` */

DROP TABLE IF EXISTS `faculty_course_attendance_history`;

CREATE TABLE `faculty_course_attendance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `fromTime` datetime DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `updatedAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `componentId` bigint(20) DEFAULT NULL,
  `variantId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_course_attendance_history` */

/*Table structure for table `faculty_documents_history` */

DROP TABLE IF EXISTS `faculty_documents_history`;

CREATE TABLE `faculty_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_documents_history` */

/*Table structure for table `faculty_fee_plan_history` */

DROP TABLE IF EXISTS `faculty_fee_plan_history`;

CREATE TABLE `faculty_fee_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `planName` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_fee_plan_history` */

/*Table structure for table `faculty_feedback_details_history` */

DROP TABLE IF EXISTS `faculty_feedback_details_history`;

CREATE TABLE `faculty_feedback_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feedbackId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_feedback_details_history` */

/*Table structure for table `faculty_feedback_history` */

DROP TABLE IF EXISTS `faculty_feedback_history`;

CREATE TABLE `faculty_feedback_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `completionDate` date DEFAULT NULL,
  `feedbackGivenBy` varchar(10) DEFAULT NULL,
  `feedbackGivenTo` varchar(10) DEFAULT NULL,
  `feedbackStatus` tinyint(1) DEFAULT NULL,
  `feedbackType` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_feedback_history` */

/*Table structure for table `faculty_payment_settings_history` */

DROP TABLE IF EXISTS `faculty_payment_settings_history`;

CREATE TABLE `faculty_payment_settings_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `academicYear` int(11) DEFAULT NULL,
  `billDate` date DEFAULT NULL,
  `dueDate` date DEFAULT NULL,
  `paymentBasic` varchar(15) DEFAULT NULL,
  `rate` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_payment_settings_history` */

/*Table structure for table `faculty_performance_history` */

DROP TABLE IF EXISTS `faculty_performance_history`;

CREATE TABLE `faculty_performance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `assessmentStatus` varchar(10) DEFAULT NULL,
  `assessmentYear` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `performanceParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_performance_history` */

/*Table structure for table `faculty_profile_history` */

DROP TABLE IF EXISTS `faculty_profile_history`;

CREATE TABLE `faculty_profile_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `isFilled` tinyint(1) DEFAULT NULL,
  `isMandatory` tinyint(1) DEFAULT NULL,
  `tabName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_profile_history` */

/*Table structure for table `faculty_program_attendance_history` */

DROP TABLE IF EXISTS `faculty_program_attendance_history`;

CREATE TABLE `faculty_program_attendance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceStatus` varchar(25) DEFAULT NULL,
  `attendanceType` varchar(20) DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `fromTime` datetime DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `updatedAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_program_attendance_history` */

/*Table structure for table `faculty_topic_assignment_history` */

DROP TABLE IF EXISTS `faculty_topic_assignment_history`;

CREATE TABLE `faculty_topic_assignment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `facultyAssignSequence` int(11) DEFAULT NULL,
  `whetherAlternateFaculty` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `topicId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `alternateFacultyId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `faculty_topic_assignment_history` */

/*Table structure for table `feature_history` */

DROP TABLE IF EXISTS `feature_history`;

CREATE TABLE `feature_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `displayCode` varchar(20) DEFAULT NULL,
  `featureName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `systemModuleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `feature_history` */

/*Table structure for table `feature_privilege_history` */

DROP TABLE IF EXISTS `feature_privilege_history`;

CREATE TABLE `feature_privilege_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `featureId` bigint(20) DEFAULT NULL,
  `privilegeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `feature_privilege_history` */

/*Table structure for table `fee_adjustment_details_history` */

DROP TABLE IF EXISTS `fee_adjustment_details_history`;

CREATE TABLE `fee_adjustment_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustedAmount` double DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `balanceAmount` double DEFAULT NULL,
  `voucherMode` varchar(255) DEFAULT NULL,
  `voucherType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFeeRuleStageId` bigint(20) DEFAULT NULL,
  `billHeaderId` bigint(20) DEFAULT NULL,
  `billServiceReceivedId` bigint(20) DEFAULT NULL,
  `adjustmentMasterId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_adjustment_details_history` */

/*Table structure for table `fee_adjustment_master_history` */

DROP TABLE IF EXISTS `fee_adjustment_master_history`;

CREATE TABLE `fee_adjustment_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustedAmount` double DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `balanceAmount` double DEFAULT NULL,
  `voucherMode` varchar(255) DEFAULT NULL,
  `voucherType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFeeRuleStageId` bigint(20) DEFAULT NULL,
  `billHeaderId` bigint(20) DEFAULT NULL,
  `paymentHeaderId` bigint(20) DEFAULT NULL,
  `receiptHeaderId` bigint(20) DEFAULT NULL,
  `instrumentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_adjustment_master_history` */

/*Table structure for table `fee_config_modes_history` */

DROP TABLE IF EXISTS `fee_config_modes_history`;

CREATE TABLE `fee_config_modes_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `paymentMode` varchar(35) DEFAULT NULL,
  `whetherRefundMode` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_config_modes_history` */

/*Table structure for table `fee_dependant_head_config_history` */

DROP TABLE IF EXISTS `fee_dependant_head_config_history`;

CREATE TABLE `fee_dependant_head_config_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `amountType` varchar(255) DEFAULT NULL,
  `farmula` varchar(255) DEFAULT NULL,
  `percentageValue` double DEFAULT NULL,
  `whetherInclusive` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `depandantHeadId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  `thirdPartyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_dependant_head_config_history` */

/*Table structure for table `fee_details_history` */

DROP TABLE IF EXISTS `fee_details_history`;

CREATE TABLE `fee_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_details_history` */

/*Table structure for table `fee_discount_history` */

DROP TABLE IF EXISTS `fee_discount_history`;

CREATE TABLE `fee_discount_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `discountOn` varchar(255) DEFAULT NULL,
  `discountValue` double DEFAULT NULL,
  `rule` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `discountCode` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_discount_history` */

/*Table structure for table `fee_heads_history` */

DROP TABLE IF EXISTS `fee_heads_history`;

CREATE TABLE `fee_heads_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeHeadName` varchar(35) DEFAULT NULL,
  `feeHeadStatus` tinyint(1) DEFAULT NULL,
  `whetherDependentFeeHead` tinyint(1) DEFAULT NULL,
  `whetherDiscountFeeHead` tinyint(1) DEFAULT NULL,
  `whetherLateFeeHead` tinyint(1) DEFAULT NULL,
  `whetherNormalFeeHead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_heads_history` */

/*Table structure for table `fee_ledger_master_history` */

DROP TABLE IF EXISTS `fee_ledger_master_history`;

CREATE TABLE `fee_ledger_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `ledgerName` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_ledger_master_history` */

/*Table structure for table `fee_notifications_history` */

DROP TABLE IF EXISTS `fee_notifications_history`;

CREATE TABLE `fee_notifications_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `notificationType` varchar(4) DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_notifications_history` */

/*Table structure for table `fee_payment_modes_history` */

DROP TABLE IF EXISTS `fee_payment_modes_history`;

CREATE TABLE `fee_payment_modes_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `paymentModeName` varchar(200) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_payment_modes_history` */

/*Table structure for table `fee_payments_history` */

DROP TABLE IF EXISTS `fee_payments_history`;

CREATE TABLE `fee_payments_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePaymentModeId` bigint(20) DEFAULT NULL,
  `feeConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_payments_history` */

/*Table structure for table `fee_plan_acad_locations_history` */

DROP TABLE IF EXISTS `fee_plan_acad_locations_history`;

CREATE TABLE `fee_plan_acad_locations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastBilledDate` date DEFAULT NULL,
  `mappingStatus` varchar(255) DEFAULT NULL,
  `whetherGenerateBillForPaymentSchedule` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_acad_locations_history` */

/*Table structure for table `fee_plan_cf_data_history` */

DROP TABLE IF EXISTS `fee_plan_cf_data_history`;

CREATE TABLE `fee_plan_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_cf_data_history` */

/*Table structure for table `fee_plan_documents_history` */

DROP TABLE IF EXISTS `fee_plan_documents_history`;

CREATE TABLE `fee_plan_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_documents_history` */

/*Table structure for table `fee_plan_history` */

DROP TABLE IF EXISTS `fee_plan_history`;

CREATE TABLE `fee_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicableFor` varchar(255) DEFAULT NULL,
  `feePlanDocument` varchar(255) DEFAULT NULL,
  `feePlanId` varchar(255) DEFAULT NULL,
  `feePlanName` varchar(255) DEFAULT NULL,
  `feePlanStatus` varchar(255) DEFAULT NULL,
  `mappingStatus` varchar(255) DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `whetherServiceReceivable` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `feePlanType` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `serviceId` bigint(20) DEFAULT NULL,
  `approver` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_history` */

/*Table structure for table `fee_plan_persons_covered_history` */

DROP TABLE IF EXISTS `fee_plan_persons_covered_history`;

CREATE TABLE `fee_plan_persons_covered_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feePersonIdType` varchar(255) DEFAULT NULL,
  `joinDate` date DEFAULT NULL,
  `joinSequence` bigint(20) DEFAULT NULL,
  `lastBilledDate` date DEFAULT NULL,
  `withdrawalDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_persons_covered_history` */

/*Table structure for table `fee_plan_rule_stage_history` */

DROP TABLE IF EXISTS `fee_plan_rule_stage_history`;

CREATE TABLE `fee_plan_rule_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `status` char(1) DEFAULT NULL,
  `whetherGenerateBillForPaymentSchedule` tinyint(1) DEFAULT NULL,
  `whetherSingleBillForMultiSponsors` tinyint(1) DEFAULT NULL,
  `whetherSingleInstrumentForMultiHeads` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  `selectionStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_rule_stage_history` */

/*Table structure for table `fee_plan_rules_cf_data_history` */

DROP TABLE IF EXISTS `fee_plan_rules_cf_data_history`;

CREATE TABLE `fee_plan_rules_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_rules_cf_data_history` */

/*Table structure for table `fee_plan_rules_history` */

DROP TABLE IF EXISTS `fee_plan_rules_history`;

CREATE TABLE `fee_plan_rules_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `documentRequired` tinyint(1) DEFAULT NULL,
  `feePlanSequence` int(11) DEFAULT NULL,
  `feeRuleDesc` varchar(255) DEFAULT NULL,
  `feeSpecificLinkType` varchar(255) DEFAULT NULL,
  `rule` varchar(150) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_rules_history` */

/*Table structure for table `fee_plan_submission_sch_history` */

DROP TABLE IF EXISTS `fee_plan_submission_sch_history`;

CREATE TABLE `fee_plan_submission_sch_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `billingDate` date DEFAULT NULL,
  `billingMonth` varchar(255) DEFAULT NULL,
  `billingType` varchar(255) DEFAULT NULL,
  `configuredParticipants` int(11) DEFAULT NULL,
  `coverageEndDate` date DEFAULT NULL,
  `coverageStartDate` date DEFAULT NULL,
  `dueDate` date DEFAULT NULL,
  `dueDays` int(11) DEFAULT NULL,
  `lastBilledDate` date DEFAULT NULL,
  `monthSequence` int(11) DEFAULT NULL,
  `noOfMonth` int(11) DEFAULT NULL,
  `noOfSession` int(11) DEFAULT NULL,
  `participantsFeeBillFor` varchar(255) DEFAULT NULL,
  `paymentPeriod` varchar(255) DEFAULT NULL,
  `periodStartDate` date DEFAULT NULL,
  `periodType` varchar(255) DEFAULT NULL,
  `sequence` int(11) DEFAULT NULL,
  `sessionBillFor` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_submission_sch_history` */

/*Table structure for table `fee_plan_submission_seq_history` */

DROP TABLE IF EXISTS `fee_plan_submission_seq_history`;

CREATE TABLE `fee_plan_submission_seq_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `sequence` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_submission_seq_history` */

/*Table structure for table `fee_plan_type_history` */

DROP TABLE IF EXISTS `fee_plan_type_history`;

CREATE TABLE `fee_plan_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feePlanType` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_plan_type_history` */

/*Table structure for table `fee_refund_modes_history` */

DROP TABLE IF EXISTS `fee_refund_modes_history`;

CREATE TABLE `fee_refund_modes_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `refundModeName` varchar(200) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_refund_modes_history` */

/*Table structure for table `fee_refunds_history` */

DROP TABLE IF EXISTS `fee_refunds_history`;

CREATE TABLE `fee_refunds_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `refund` varchar(35) DEFAULT NULL,
  `refundRules` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeRefundModeId` bigint(20) DEFAULT NULL,
  `feeConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_refunds_history` */

/*Table structure for table `fee_related_request_details_history` */

DROP TABLE IF EXISTS `fee_related_request_details_history`;

CREATE TABLE `fee_related_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `discountType` varchar(255) DEFAULT NULL,
  `feeRequestAgainst` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `requestDate` date DEFAULT NULL,
  `requestFor` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `waiverAmountApproved` double DEFAULT NULL,
  `waiverAmountRequested` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFeeRuleStageId` bigint(20) DEFAULT NULL,
  `discountCodeId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_related_request_details_history` */

/*Table structure for table `fee_request_history` */

DROP TABLE IF EXISTS `fee_request_history`;

CREATE TABLE `fee_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dueDate` date DEFAULT NULL,
  `feeAmount` int(11) DEFAULT NULL,
  `requestReason` longtext,
  `requestType` varchar(10) DEFAULT NULL,
  `waiverAmount` int(11) DEFAULT NULL,
  `waiverPercent` varchar(6) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_request_history` */

/*Table structure for table `fee_request_sponsored_students_history` */

DROP TABLE IF EXISTS `fee_request_sponsored_students_history`;

CREATE TABLE `fee_request_sponsored_students_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeRelatedRequestDetailId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_request_sponsored_students_history` */

/*Table structure for table `fee_rule_documents_history` */

DROP TABLE IF EXISTS `fee_rule_documents_history`;

CREATE TABLE `fee_rule_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `feeRuleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_rule_documents_history` */

/*Table structure for table `fee_sch_details_history` */

DROP TABLE IF EXISTS `fee_sch_details_history`;

CREATE TABLE `fee_sch_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `billDay` int(11) DEFAULT NULL,
  `dueDay` int(11) DEFAULT NULL,
  `installmentName` varchar(35) DEFAULT NULL,
  `installmentType` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeScheduleStudentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_sch_details_history` */

/*Table structure for table `fee_schedule_student_history` */

DROP TABLE IF EXISTS `fee_schedule_student_history`;

CREATE TABLE `fee_schedule_student_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeSubmissionSchId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_schedule_student_history` */

/*Table structure for table `fee_stage_head_config_cf_data_history` */

DROP TABLE IF EXISTS `fee_stage_head_config_cf_data_history`;

CREATE TABLE `fee_stage_head_config_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_stage_head_config_cf_data_history` */

/*Table structure for table `fee_stage_head_config_history` */

DROP TABLE IF EXISTS `fee_stage_head_config_history`;

CREATE TABLE `fee_stage_head_config_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amountType` varchar(255) DEFAULT NULL,
  `discountType` varchar(255) DEFAULT NULL,
  `feeAmount` double DEFAULT NULL,
  `feeHeadPercentageValue` int(11) DEFAULT NULL,
  `feeHeadSequence` bigint(20) DEFAULT NULL,
  `formulaForPercentage` varchar(255) DEFAULT NULL,
  `lateFeeType` varchar(255) DEFAULT NULL,
  `noOfFeePayment` int(11) DEFAULT NULL,
  `paymentPeriod` varchar(255) DEFAULT NULL,
  `prorataPeriod` varchar(255) DEFAULT NULL,
  `refundableNature` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `whetherInstallPostDated` tinyint(1) DEFAULT NULL,
  `whetherProrataBilling` tinyint(1) DEFAULT NULL,
  `whetherRefundAvailable` tinyint(1) DEFAULT NULL,
  `whetherSplitPayment` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  `feeHeadForPercentage` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `parentFeeHeadId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_stage_head_config_history` */

/*Table structure for table `fee_stage_master_history` */

DROP TABLE IF EXISTS `fee_stage_master_history`;

CREATE TABLE `fee_stage_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `stageName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanType` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_stage_master_history` */

/*Table structure for table `fee_third_parties_history` */

DROP TABLE IF EXISTS `fee_third_parties_history`;

CREATE TABLE `fee_third_parties_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `addressText` varchar(255) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(255) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fee_third_parties_history` */

/*Table structure for table `feedback_questions_history` */

DROP TABLE IF EXISTS `feedback_questions_history`;

CREATE TABLE `feedback_questions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feedback` varchar(255) DEFAULT NULL,
  `feedbackStatus` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feedBackId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `feedback_questions_history` */

/*Table structure for table `fine_request_details_history` */

DROP TABLE IF EXISTS `fine_request_details_history`;

CREATE TABLE `fine_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `recommendedFine` decimal(19,2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `fine_request_details_history` */

/*Table structure for table `followup_details_history` */

DROP TABLE IF EXISTS `followup_details_history`;

CREATE TABLE `followup_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actualFollowupDate` datetime DEFAULT NULL,
  `documentProofStatus` varchar(255) DEFAULT NULL,
  `nextFollowupDate` datetime DEFAULT NULL,
  `plannedFollowupDate` datetime DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `whetherLatest` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approverUserId` bigint(20) DEFAULT NULL,
  `assigneeUserId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `followup_details_history` */

/*Table structure for table `form_field_display_settings_history` */

DROP TABLE IF EXISTS `form_field_display_settings_history`;

CREATE TABLE `form_field_display_settings_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `isVisible` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `formFieldInfoId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_field_display_settings_history` */

/*Table structure for table `form_field_helptext_lang_translation_history` */

DROP TABLE IF EXISTS `form_field_helptext_lang_translation_history`;

CREATE TABLE `form_field_helptext_lang_translation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `formFieldHelpText` varchar(255) DEFAULT NULL,
  `formFieldLabel` varchar(255) DEFAULT NULL,
  `languageCode` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `formFieldDisplaySettingsId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_field_helptext_lang_translation_history` */

/*Table structure for table `form_field_info_history` */

DROP TABLE IF EXISTS `form_field_info_history`;

CREATE TABLE `form_field_info_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `defaultValue` varchar(255) DEFAULT NULL,
  `formAliasName` varchar(255) DEFAULT NULL,
  `formFieldId` varchar(255) DEFAULT NULL,
  `formFieldInputType` varchar(255) DEFAULT NULL,
  `formFieldName` varchar(255) DEFAULT NULL,
  `isLocked` tinyint(1) DEFAULT NULL,
  `isMandatory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `form_field_info_history` */

/*Table structure for table `free_form_request_categories_history` */

DROP TABLE IF EXISTS `free_form_request_categories_history`;

CREATE TABLE `free_form_request_categories_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `free_form_request_categories_history` */

/*Table structure for table `free_form_request_details_history` */

DROP TABLE IF EXISTS `free_form_request_details_history`;

CREATE TABLE `free_form_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `freeFormRequestCategoryId` bigint(20) DEFAULT NULL,
  `freeFormRequestTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `free_form_request_details_history` */

/*Table structure for table `free_form_request_types_history` */

DROP TABLE IF EXISTS `free_form_request_types_history`;

CREATE TABLE `free_form_request_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `categoryId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `free_form_request_types_history` */

/*Table structure for table `free_format_request_history` */

DROP TABLE IF EXISTS `free_format_request_history`;

CREATE TABLE `free_format_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `requestDetails` varchar(35) DEFAULT NULL,
  `requestType` varchar(12) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `executionRequestId` bigint(20) DEFAULT NULL,
  `requestFollowUpId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `free_format_request_history` */

/*Table structure for table `grade_distribution_details_history` */

DROP TABLE IF EXISTS `grade_distribution_details_history`;

CREATE TABLE `grade_distribution_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `entryDate` date DEFAULT NULL,
  `percentFrom` double DEFAULT NULL,
  `percentTo` double DEFAULT NULL,
  `percentTotalFrom` double DEFAULT NULL,
  `percentTotalTo` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `distributionId` bigint(20) DEFAULT NULL,
  `gradeId` bigint(20) DEFAULT NULL,
  `enteredBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `grade_distribution_details_history` */

/*Table structure for table `grade_group_history` */

DROP TABLE IF EXISTS `grade_group_history`;

CREATE TABLE `grade_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `groupName` varchar(20) DEFAULT NULL,
  `maxPercent` int(11) DEFAULT NULL,
  `minPercent` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `grade_group_history` */

/*Table structure for table `grade_history` */

DROP TABLE IF EXISTS `grade_history`;

CREATE TABLE `grade_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `gradeName` varchar(20) DEFAULT NULL,
  `gradePoint` double DEFAULT NULL,
  `gradeRangeFrom` float DEFAULT NULL,
  `gradeRangeTo` float DEFAULT NULL,
  `gradeStatus` varchar(11) DEFAULT NULL,
  `gradeType` varchar(20) DEFAULT NULL,
  `hasGroup` tinyint(1) DEFAULT NULL,
  `maxPercent` int(11) DEFAULT NULL,
  `minPercent` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `grade_history` */

/*Table structure for table `grade_type_history` */

DROP TABLE IF EXISTS `grade_type_history`;

CREATE TABLE `grade_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `gradeType` varchar(255) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `grade_type_history` */

/*Table structure for table `grades_group_history` */

DROP TABLE IF EXISTS `grades_group_history`;

CREATE TABLE `grades_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `gradeId` bigint(20) DEFAULT NULL,
  `gradeGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `grades_group_history` */

/*Table structure for table `group_batch_seat_type_history` */

DROP TABLE IF EXISTS `group_batch_seat_type_history`;

CREATE TABLE `group_batch_seat_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `group_batch_seat_type_history` */

/*Table structure for table `group_date_batch_center_history` */

DROP TABLE IF EXISTS `group_date_batch_center_history`;

CREATE TABLE `group_date_batch_center_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalGroupSchCenterId` bigint(20) DEFAULT NULL,
  `evalGroupSchDateId` bigint(20) DEFAULT NULL,
  `evalGroupSchBatchId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `group_date_batch_center_history` */

/*Table structure for table `group_hw_assignment_documents_history` */

DROP TABLE IF EXISTS `group_hw_assignment_documents_history`;

CREATE TABLE `group_hw_assignment_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `groupHomeworkAssignmentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `group_hw_assignment_documents_history` */

/*Table structure for table `group_hw_assignment_history` */

DROP TABLE IF EXISTS `group_hw_assignment_history`;

CREATE TABLE `group_hw_assignment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `gradeObtained` varchar(255) DEFAULT NULL,
  `groupName` varchar(255) DEFAULT NULL,
  `markObtained` int(11) DEFAULT NULL,
  `markesGrade` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `resubmissionDate` datetime DEFAULT NULL,
  `submissionDate` datetime DEFAULT NULL,
  `submissionStatus` varchar(255) DEFAULT NULL,
  `whetherGroupLeader` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `hwAssignmentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `group_hw_assignment_history` */

/*Table structure for table `group_schedule_batch_history` */

DROP TABLE IF EXISTS `group_schedule_batch_history`;

CREATE TABLE `group_schedule_batch_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `batchName` varchar(255) DEFAULT NULL,
  `timeFrom` datetime DEFAULT NULL,
  `timeTo` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `evalSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `group_schedule_batch_history` */

/*Table structure for table `guestfaculty_sessions_history` */

DROP TABLE IF EXISTS `guestfaculty_sessions_history`;

CREATE TABLE `guestfaculty_sessions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeType` char(1) DEFAULT NULL,
  `payVoucherRef` varchar(10) DEFAULT NULL,
  `sessionAmount` int(11) DEFAULT NULL,
  `sessionAmountCurrency` varchar(10) DEFAULT NULL,
  `sessionDate` date DEFAULT NULL,
  `sessionDateSlot` tinyint(4) DEFAULT NULL,
  `voucherRef` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `guestfaculty_sessions_history` */

/*Table structure for table `hod_history_history` */

DROP TABLE IF EXISTS `hod_history_history`;

CREATE TABLE `hod_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `departmentId` bigint(20) DEFAULT NULL,
  `hod` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `hod_history_history` */

/*Table structure for table `home_work_assignment_cf_data_history` */

DROP TABLE IF EXISTS `home_work_assignment_cf_data_history`;

CREATE TABLE `home_work_assignment_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `homeWorkAssignmentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `home_work_assignment_cf_data_history` */

/*Table structure for table `iau_accounting_history` */

DROP TABLE IF EXISTS `iau_accounting_history`;

CREATE TABLE `iau_accounting_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `companyCode` varchar(10) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountConfigId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `iau_accounting_history` */

/*Table structure for table `id_format_alphanumeric_history` */

DROP TABLE IF EXISTS `id_format_alphanumeric_history`;

CREATE TABLE `id_format_alphanumeric_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `startFrom` bigint(20) DEFAULT NULL,
  `suffix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`),
  KEY `FK2083E668ECCF3A9E` (`id`,`REV`),
  CONSTRAINT `FK2083E668ECCF3A9E` FOREIGN KEY (`id`, `REV`) REFERENCES `id_format_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `id_format_alphanumeric_history` */

/*Table structure for table `id_format_dynamic_history` */

DROP TABLE IF EXISTS `id_format_dynamic_history`;

CREATE TABLE `id_format_dynamic_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `resultKey` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`),
  KEY `FKA957FFF0ECCF3A9E` (`id`,`REV`),
  CONSTRAINT `FKA957FFF0ECCF3A9E` FOREIGN KEY (`id`, `REV`) REFERENCES `id_format_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `id_format_dynamic_history` */

/*Table structure for table `id_format_history` */

DROP TABLE IF EXISTS `id_format_history`;

CREATE TABLE `id_format_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `seqNo` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `id_format_history` */

/*Table structure for table `id_format_running_no_history` */

DROP TABLE IF EXISTS `id_format_running_no_history`;

CREATE TABLE `id_format_running_no_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `startFrom` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`),
  KEY `FK95B7F9BAECCF3A9E` (`id`,`REV`),
  CONSTRAINT `FK95B7F9BAECCF3A9E` FOREIGN KEY (`id`, `REV`) REFERENCES `id_format_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `id_format_running_no_history` */

/*Table structure for table `incident_types_history` */

DROP TABLE IF EXISTS `incident_types_history`;

CREATE TABLE `incident_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `incident_types_history` */

/*Table structure for table `incidents_history` */

DROP TABLE IF EXISTS `incidents_history`;

CREATE TABLE `incidents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actionTaken` varchar(255) DEFAULT NULL,
  `honourName` varchar(255) DEFAULT NULL,
  `incidentDate` datetime DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `reportedByUserId` varchar(255) DEFAULT NULL,
  `reportedByUserName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `incidentTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `incidents_history` */

/*Table structure for table `income_slabs_history` */

DROP TABLE IF EXISTS `income_slabs_history`;

CREATE TABLE `income_slabs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `incomeSlab` varchar(50) DEFAULT NULL,
  `incomeType` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `income_slabs_history` */

/*Table structure for table `installment_details_history` */

DROP TABLE IF EXISTS `installment_details_history`;

CREATE TABLE `installment_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `installmentDueDate` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `whetherBillGenerated` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeRelatedRequestDetailId` bigint(20) DEFAULT NULL,
  `installmentExecutionDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `installment_details_history` */

/*Table structure for table `internal_resources_history` */

DROP TABLE IF EXISTS `internal_resources_history`;

CREATE TABLE `internal_resources_history` (
  `resourceId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `hasSharedAcadLoc` tinyint(1) DEFAULT NULL,
  `whetherBookingAllowed` tinyint(1) DEFAULT NULL,
  `childResourceId` bigint(20) DEFAULT NULL,
  `parentResourceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`resourceId`,`REV`),
  KEY `FKCAA9AF78AA5F9848` (`resourceId`,`REV`),
  CONSTRAINT `FKCAA9AF78AA5F9848` FOREIGN KEY (`resourceId`, `REV`) REFERENCES `resources_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `internal_resources_history` */

/*Table structure for table `kys_data_history` */

DROP TABLE IF EXISTS `kys_data_history`;

CREATE TABLE `kys_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `daysOverdue` int(11) DEFAULT NULL,
  `lastSubmissionDate` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `submissionDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `kys_data_history` */

/*Table structure for table `lack_of_attendance_course_history` */

DROP TABLE IF EXISTS `lack_of_attendance_course_history`;

CREATE TABLE `lack_of_attendance_course_history` (
  `REV` int(11) NOT NULL,
  `lackOfAttendanceRequestDetailId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`REV`,`lackOfAttendanceRequestDetailId`,`courseId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `lack_of_attendance_course_history` */

/*Table structure for table `lack_of_attendance_req_types_history` */

DROP TABLE IF EXISTS `lack_of_attendance_req_types_history`;

CREATE TABLE `lack_of_attendance_req_types_history` (
  `examRequestTypeDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  PRIMARY KEY (`examRequestTypeDetailId`,`REV`),
  KEY `FKF8A74EDD7BF72940` (`examRequestTypeDetailId`,`REV`),
  CONSTRAINT `FKF8A74EDD7BF72940` FOREIGN KEY (`examRequestTypeDetailId`, `REV`) REFERENCES `exam_request_type_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `lack_of_attendance_req_types_history` */

/*Table structure for table `lack_of_attendance_request_details_history` */

DROP TABLE IF EXISTS `lack_of_attendance_request_details_history`;

CREATE TABLE `lack_of_attendance_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lessAttendanceReason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `lack_of_attendance_request_details_history` */

/*Table structure for table `lack_of_other_criteria_history` */

DROP TABLE IF EXISTS `lack_of_other_criteria_history`;

CREATE TABLE `lack_of_other_criteria_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvalSoughtFor` varchar(255) DEFAULT NULL,
  `lackOfCriteriaReason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `lack_of_other_criteria_history` */

/*Table structure for table `late_fee_history` */

DROP TABLE IF EXISTS `late_fee_history`;

CREATE TABLE `late_fee_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lateFeeOneTimeValue` double DEFAULT NULL,
  `lateFeePerDayValue` double DEFAULT NULL,
  `lateFeeRule` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lateFeeHeadId` bigint(20) DEFAULT NULL,
  `feeStageConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `late_fee_history` */

/*Table structure for table `leave_report_history` */

DROP TABLE IF EXISTS `leave_report_history`;

CREATE TABLE `leave_report_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceType` varchar(35) DEFAULT NULL,
  `dateOfAbsence` date DEFAULT NULL,
  `fromTime` datetime DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `leaveRequestDetailsId` bigint(20) DEFAULT NULL,
  `leaveStatusId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  `userGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_report_history` */

/*Table structure for table `leave_request_details_history` */

DROP TABLE IF EXISTS `leave_request_details_history`;

CREATE TABLE `leave_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` datetime DEFAULT NULL,
  `toDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_request_details_history` */

/*Table structure for table `leave_request_history` */

DROP TABLE IF EXISTS `leave_request_history`;

CREATE TABLE `leave_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `requestFrom` date DEFAULT NULL,
  `requestTo` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `executionRequestId` bigint(20) DEFAULT NULL,
  `requestFollowUpId` bigint(20) DEFAULT NULL,
  `requestId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_request_history` */

/*Table structure for table `leave_status_history` */

DROP TABLE IF EXISTS `leave_status_history`;

CREATE TABLE `leave_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `leaveStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_status_history` */

/*Table structure for table `leave_transaction_details_history` */

DROP TABLE IF EXISTS `leave_transaction_details_history`;

CREATE TABLE `leave_transaction_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromTime` varchar(10) DEFAULT NULL,
  `leaveDate` date DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `toTime` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `transactionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_transaction_details_history` */

/*Table structure for table `leave_transaction_history` */

DROP TABLE IF EXISTS `leave_transaction_history`;

CREATE TABLE `leave_transaction_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvalDate` datetime DEFAULT NULL,
  `leaveType` varchar(10) DEFAULT NULL,
  `noOfDays` int(11) DEFAULT NULL,
  `reason` varchar(20) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `leave_transaction_history` */

/*Table structure for table `location_addresses_history` */

DROP TABLE IF EXISTS `location_addresses_history`;

CREATE TABLE `location_addresses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `locationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `location_addresses_history` */

/*Table structure for table `locations_history` */

DROP TABLE IF EXISTS `locations_history`;

CREATE TABLE `locations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `locationName` varchar(255) DEFAULT NULL,
  `shortCode` varchar(10) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `organizationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `locations_history` */

/*Table structure for table `master_time_table_history` */

DROP TABLE IF EXISTS `master_time_table_history`;

CREATE TABLE `master_time_table_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `calendarSlotId` bigint(20) DEFAULT NULL,
  `classRoomId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `master_time_table_history` */

/*Table structure for table `media_history` */

DROP TABLE IF EXISTS `media_history`;

CREATE TABLE `media_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(35) DEFAULT NULL,
  `mediaName` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `media_history` */

/*Table structure for table `medical_condition_types_history` */

DROP TABLE IF EXISTS `medical_condition_types_history`;

CREATE TABLE `medical_condition_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `medical_condition_types_history` */

/*Table structure for table `medical_data_to_be_changed_history` */

DROP TABLE IF EXISTS `medical_data_to_be_changed_history`;

CREATE TABLE `medical_data_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `consultingDoctor` varchar(255) DEFAULT NULL,
  `dateSince` date DEFAULT NULL,
  `medicalCondition` varchar(255) DEFAULT NULL,
  `medicalHistoryId` bigint(20) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `conditionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FKA8C3ADEA7BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FKA8C3ADEA7BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `medical_data_to_be_changed_history` */

/*Table structure for table `medical_history_history` */

DROP TABLE IF EXISTS `medical_history_history`;

CREATE TABLE `medical_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `consultingDoctor` varchar(255) DEFAULT NULL,
  `dateSince` date DEFAULT NULL,
  `medicalCondition` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `medicalConditonId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `medical_history_history` */

/*Table structure for table `module_usage_history` */

DROP TABLE IF EXISTS `module_usage_history`;

CREATE TABLE `module_usage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `menuOption` varchar(35) DEFAULT NULL,
  `timeOfUsage` time DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `moduleId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `module_usage_history` */

/*Table structure for table `months_history` */

DROP TABLE IF EXISTS `months_history`;

CREATE TABLE `months_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `monthName` varchar(255) DEFAULT NULL,
  `monthSequence` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `months_history` */

/*Table structure for table `nationalities_history` */

DROP TABLE IF EXISTS `nationalities_history`;

CREATE TABLE `nationalities_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `nationalities_history` */

/*Table structure for table `occupation_history` */

DROP TABLE IF EXISTS `occupation_history`;

CREATE TABLE `occupation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `occupationName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `occupation_history` */

/*Table structure for table `organization_addresses_history` */

DROP TABLE IF EXISTS `organization_addresses_history`;

CREATE TABLE `organization_addresses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `organizationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_addresses_history` */

/*Table structure for table `organization_cf_data_history` */

DROP TABLE IF EXISTS `organization_cf_data_history`;

CREATE TABLE `organization_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `organizationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_cf_data_history` */

/*Table structure for table `organization_settings_history` */

DROP TABLE IF EXISTS `organization_settings_history`;

CREATE TABLE `organization_settings_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `orgSettingvalue` varchar(25) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `entitySettingId` bigint(20) DEFAULT NULL,
  `organizationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_settings_history` */

/*Table structure for table `organization_supervisory_units_history` */

DROP TABLE IF EXISTS `organization_supervisory_units_history`;

CREATE TABLE `organization_supervisory_units_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `shortCode` varchar(15) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `structureTypeCode` varchar(10) DEFAULT NULL,
  `unitName` varchar(60) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `organizationId` bigint(20) DEFAULT NULL,
  `organizationUnitTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_supervisory_units_history` */

/*Table structure for table `organization_unit_alps_history` */

DROP TABLE IF EXISTS `organization_unit_alps_history`;

CREATE TABLE `organization_unit_alps_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationPuirposeId` bigint(20) DEFAULT NULL,
  `organizationUnitId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_unit_alps_history` */

/*Table structure for table `organization_unit_settings_history` */

DROP TABLE IF EXISTS `organization_unit_settings_history`;

CREATE TABLE `organization_unit_settings_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `unitSettingValue` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `entitySettingId` bigint(20) DEFAULT NULL,
  `organizationUnitId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_unit_settings_history` */

/*Table structure for table `organization_unit_types_history` */

DROP TABLE IF EXISTS `organization_unit_types_history`;

CREATE TABLE `organization_unit_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `typeName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_unit_types_history` */

/*Table structure for table `organization_units_history` */

DROP TABLE IF EXISTS `organization_units_history`;

CREATE TABLE `organization_units_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `Status` tinyint(1) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `unitName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `organizationSupervisoryUnitId` bigint(20) DEFAULT NULL,
  `parentOrganizationUnitId` bigint(20) DEFAULT NULL,
  `ownerId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organization_units_history` */

/*Table structure for table `organizations_history` */

DROP TABLE IF EXISTS `organizations_history`;

CREATE TABLE `organizations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `activeDBPath` varchar(255) DEFAULT NULL,
  `archiveDBPath` varchar(255) DEFAULT NULL,
  `orgName` varchar(255) DEFAULT NULL,
  `typeCode` varchar(15) DEFAULT NULL,
  `whetherEnrollmentAllowed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `organizations_history` */

/*Table structure for table `passing_outs_history` */

DROP TABLE IF EXISTS `passing_outs_history`;

CREATE TABLE `passing_outs_history` (
  `completionId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `passingOutStatus` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`completionId`,`REV`),
  KEY `FKC48C6488BE3F3224` (`completionId`,`REV`),
  CONSTRAINT `FKC48C6488BE3F3224` FOREIGN KEY (`completionId`, `REV`) REFERENCES `completions_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `passing_outs_history` */

/*Table structure for table `pay_bill_fee_plan_stg_history` */

DROP TABLE IF EXISTS `pay_bill_fee_plan_stg_history`;

CREATE TABLE `pay_bill_fee_plan_stg_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `instrumentNo` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `pay_bill_fee_plan_stg_history` */

/*Table structure for table `payment_adjust_refund_history` */

DROP TABLE IF EXISTS `payment_adjust_refund_history`;

CREATE TABLE `payment_adjust_refund_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustmentAmount` float DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billFacultyPaymentId` bigint(20) DEFAULT NULL,
  `payBillFeePlanStgId` bigint(20) DEFAULT NULL,
  `paymentModeInstrumentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payment_adjust_refund_history` */

/*Table structure for table `payment_header_history` */

DROP TABLE IF EXISTS `payment_header_history`;

CREATE TABLE `payment_header_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double(20,2) DEFAULT NULL,
  `integratedWithTally` tinyint(1) DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `paymentType` varchar(255) DEFAULT NULL,
  `paymentUniqueNumber` int(11) DEFAULT NULL,
  `paymentVoucherNo` varchar(255) DEFAULT NULL,
  `tallyVoucherId` int(11) DEFAULT NULL,
  `transactionDate` date DEFAULT NULL,
  `voucherMode` varchar(255) DEFAULT NULL,
  `voucherType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `thirdPartyId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `paymentBank` bigint(20) DEFAULT NULL,
  `paymentCash` bigint(20) DEFAULT NULL,
  `paymentFor` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payment_header_history` */

/*Table structure for table `payment_mode_instrument_history` */

DROP TABLE IF EXISTS `payment_mode_instrument_history`;

CREATE TABLE `payment_mode_instrument_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `instrumentNo` varchar(15) DEFAULT NULL,
  `instrumentType` varchar(10) DEFAULT NULL,
  `paymentMode` varchar(18) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `paymentHeaderId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `payment_mode_instrument_history` */

/*Table structure for table `pdc_adjustment_history` */

DROP TABLE IF EXISTS `pdc_adjustment_history`;

CREATE TABLE `pdc_adjustment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `installmentNo` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `pdcId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `pdc_adjustment_history` */

/*Table structure for table `person_addresses_history` */

DROP TABLE IF EXISTS `person_addresses_history`;

CREATE TABLE `person_addresses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherPrimary` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `addressTypeId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `person_addresses_history` */

/*Table structure for table `person_communities_history` */

DROP TABLE IF EXISTS `person_communities_history`;

CREATE TABLE `person_communities_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `exitDate` datetime DEFAULT NULL,
  `whetherOpted` tinyint(1) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `communityId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `person_communities_history` */

/*Table structure for table `person_relationships_history` */

DROP TABLE IF EXISTS `person_relationships_history`;

CREATE TABLE `person_relationships_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `relationship` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `relatedPersonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `person_relationships_history` */

/*Table structure for table `person_services_history` */

DROP TABLE IF EXISTS `person_services_history`;

CREATE TABLE `person_services_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amountToBePaid` decimal(19,2) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `whetherMandatory` tinyint(1) DEFAULT NULL,
  `whetherOpted` tinyint(1) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `serviceIdentifier` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `serviceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `person_services_history` */

/*Table structure for table `personal_data_request_details_history` */

DROP TABLE IF EXISTS `personal_data_request_details_history`;

CREATE TABLE `personal_data_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `dataToBeChangedId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `personal_data_request_details_history` */

/*Table structure for table `personal_data_to_be_changed_history` */

DROP TABLE IF EXISTS `personal_data_to_be_changed_history`;

CREATE TABLE `personal_data_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `accountNumber` varchar(255) DEFAULT NULL,
  `bankDetailId` bigint(20) DEFAULT NULL,
  `bankName` varchar(255) DEFAULT NULL,
  `birthDate` datetime DEFAULT NULL,
  `bloodGroup` varchar(255) DEFAULT NULL,
  `branchName` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `cellCountryCode` varchar(255) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `exitDate` datetime DEFAULT NULL,
  `facultyType` varchar(255) DEFAULT NULL,
  `familyIncome` decimal(19,2) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `IFSCode` varchar(255) DEFAULT NULL,
  `joiningDate` datetime DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `maritalStatus` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `occupation` varchar(255) DEFAULT NULL,
  `personalIncome` decimal(19,2) DEFAULT NULL,
  `photoUrl` varchar(255) DEFAULT NULL,
  `primaryeEmailId` varchar(255) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `relationship` varchar(50) DEFAULT NULL,
  `shortName` varchar(255) DEFAULT NULL,
  `yearsOfExperience` int(11) DEFAULT NULL,
  `castCategoryId` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `departmentId` bigint(20) DEFAULT NULL,
  `designationId` bigint(20) DEFAULT NULL,
  `nationalityId` bigint(20) DEFAULT NULL,
  `religionId` bigint(20) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  `subDepartmentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FKA241CCDB7BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FKA241CCDB7BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `personal_data_to_be_changed_history` */

/*Table structure for table `persons_history` */

DROP TABLE IF EXISTS `persons_history`;

CREATE TABLE `persons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `bloodGroup` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) DEFAULT NULL,
  `employeeId` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `whetherEmployeeOfOrganization` tinyint(1) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `maritalStatus` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `mobileNumber` varchar(255) DEFAULT NULL,
  `occupation` varchar(255) DEFAULT NULL,
  `personalIncome` double DEFAULT NULL,
  `photoUrl` varchar(255) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `shortName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `bankDetailId` bigint(20) DEFAULT NULL,
  `castCategoryId` bigint(20) DEFAULT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `nationalityId` bigint(20) DEFAULT NULL,
  `religionId` bigint(20) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `persons_history` */

/*Table structure for table `picklist_enum_history` */

DROP TABLE IF EXISTS `picklist_enum_history`;

CREATE TABLE `picklist_enum_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `code` varchar(200) DEFAULT NULL,
  `enumType` varchar(200) DEFAULT NULL,
  `enumValue` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `picklist_enum_history` */

/*Table structure for table `placement_request_details_history` */

DROP TABLE IF EXISTS `placement_request_details_history`;

CREATE TABLE `placement_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherWillingForPlacement` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `placementPeriodId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `placement_request_details_history` */

/*Table structure for table `portals_history` */

DROP TABLE IF EXISTS `portals_history`;

CREATE TABLE `portals_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `portalDesc` varchar(20) DEFAULT NULL,
  `portalName` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `portals_history` */

/*Table structure for table `privilege_history` */

DROP TABLE IF EXISTS `privilege_history`;

CREATE TABLE `privilege_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `displayCode` varchar(255) DEFAULT NULL,
  `privilegeName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `privilege_history` */

/*Table structure for table `prog_batch_course_details_history` */

DROP TABLE IF EXISTS `prog_batch_course_details_history`;

CREATE TABLE `prog_batch_course_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `deEnrollReason` varchar(255) DEFAULT NULL,
  `enrollmentRequirement` varchar(10) DEFAULT NULL,
  `isCurrentSection` tinyint(1) DEFAULT NULL,
  `rejectionReason` varchar(255) DEFAULT NULL,
  `requestDate` datetime DEFAULT NULL,
  `whetherCompleted` tinyint(1) DEFAULT NULL,
  `whetherDeEnrolled` tinyint(1) DEFAULT NULL,
  `whetherEnrolled` tinyint(1) DEFAULT NULL,
  `whetherOptional` tinyint(1) DEFAULT NULL,
  `whetherRejected` tinyint(1) DEFAULT NULL,
  `whetherRepeating` tinyint(1) DEFAULT NULL,
  `whetherRequirementReceived` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_batch_course_details_history` */

/*Table structure for table `prog_batch_course_faculty_history` */

DROP TABLE IF EXISTS `prog_batch_course_faculty_history`;

CREATE TABLE `prog_batch_course_faculty_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `alternateFacultyAssignment` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `alternateFacultyId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `progBatchCourseParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_batch_course_faculty_history` */

/*Table structure for table `prog_batch_course_special_history` */

DROP TABLE IF EXISTS `prog_batch_course_special_history`;

CREATE TABLE `prog_batch_course_special_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `specializationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_batch_course_special_history` */

/*Table structure for table `prog_batch_period_config_history` */

DROP TABLE IF EXISTS `prog_batch_period_config_history`;

CREATE TABLE `prog_batch_period_config_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enrollmentLastDate` date DEFAULT NULL,
  `entryCriteriaQuery` varchar(255) DEFAULT NULL,
  `exitCriteriaQuery` varchar(255) DEFAULT NULL,
  `isCurrentPeriodOfProgram` tinyint(1) DEFAULT NULL,
  `isLastPeriodOfProgram` tinyint(1) DEFAULT NULL,
  `KYSEndDate` date DEFAULT NULL,
  `KYSStartDate` date DEFAULT NULL,
  `maxCourses` int(11) DEFAULT NULL,
  `maxCredit` int(11) DEFAULT NULL,
  `minCourses` int(11) DEFAULT NULL,
  `minCredits` int(11) DEFAULT NULL,
  `programPeriodAutoPromotion` char(1) DEFAULT NULL,
  `programPeriodEnd` date DEFAULT NULL,
  `programPeriodEndMessageType` varchar(255) DEFAULT NULL,
  `programPeriodEndNotify` char(1) DEFAULT NULL,
  `programPeriodExternalPromotion` char(1) DEFAULT NULL,
  `programPeriodName` varchar(255) DEFAULT NULL,
  `programPeriodRankBasis` varchar(20) DEFAULT NULL,
  `programPeriodSeq` int(11) DEFAULT NULL,
  `programPeriodStart` date DEFAULT NULL,
  `programPeriodStartMessageType` varchar(255) DEFAULT NULL,
  `programPeriodStartNotify` char(1) DEFAULT NULL,
  `studentCourseSelectionEndDate` date DEFAULT NULL,
  `studentCourseSelectionStartDate` date DEFAULT NULL,
  `whetherPlacementPeriod` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `programPeriodResponsible` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_batch_period_config_history` */

/*Table structure for table `prog_batch_seat_config_history` */

DROP TABLE IF EXISTS `prog_batch_seat_config_history`;

CREATE TABLE `prog_batch_seat_config_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enqSeatType` char(1) DEFAULT NULL,
  `seatCapacity` int(11) DEFAULT NULL,
  `selProcessEndDate` datetime DEFAULT NULL,
  `selProcessNote` varchar(255) DEFAULT NULL,
  `selProcessStartDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `seatTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_batch_seat_config_history` */

/*Table structure for table `prog_period_break_config_cf_data_history` */

DROP TABLE IF EXISTS `prog_period_break_config_cf_data_history`;

CREATE TABLE `prog_period_break_config_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `periodBreakConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_period_break_config_cf_data_history` */

/*Table structure for table `prog_period_break_config_history` */

DROP TABLE IF EXISTS `prog_period_break_config_history`;

CREATE TABLE `prog_period_break_config_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `breakEnd` date DEFAULT NULL,
  `breakName` varchar(20) DEFAULT NULL,
  `breakStart` date DEFAULT NULL,
  `breakStatus` tinyint(1) DEFAULT NULL,
  `breakType` varchar(10) DEFAULT NULL,
  `programPeriodBreakSeq` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `programPeriodSeqId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_period_break_config_history` */

/*Table structure for table `prog_slctn_proc_stage_log_history` */

DROP TABLE IF EXISTS `prog_slctn_proc_stage_log_history`;

CREATE TABLE `prog_slctn_proc_stage_log_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  `programSelectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_proc_stage_log_history` */

/*Table structure for table `prog_slctn_process_admisn_conf_history` */

DROP TABLE IF EXISTS `prog_slctn_process_admisn_conf_history`;

CREATE TABLE `prog_slctn_process_admisn_conf_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `admissionProcessStartDate` date DEFAULT NULL,
  `allowProvisionalAdmission` tinyint(1) DEFAULT NULL,
  `lastDateForAdmission` date DEFAULT NULL,
  `lastDateForConfirmation` date DEFAULT NULL,
  `maxDaysToHoldOfferLetter` int(11) DEFAULT NULL,
  `offerLetterAcceptDaysLimit` int(11) DEFAULT NULL,
  `offerLetterTemplate` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `trialAdmissionEndDate` date DEFAULT NULL,
  `whetherTrialAdmissionAllowed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approverAuthority` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_process_admisn_conf_history` */

/*Table structure for table `prog_slctn_process_checklist_history` */

DROP TABLE IF EXISTS `prog_slctn_process_checklist_history`;

CREATE TABLE `prog_slctn_process_checklist_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicableAt` varchar(50) DEFAULT NULL,
  `checklistItemId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_process_checklist_history` */

/*Table structure for table `prog_slctn_process_document_history` */

DROP TABLE IF EXISTS `prog_slctn_process_document_history`;

CREATE TABLE `prog_slctn_process_document_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `appProcessDocLink` varchar(255) DEFAULT NULL,
  `applicability` varchar(20) DEFAULT NULL,
  `applicabilityRule` varchar(100) DEFAULT NULL,
  `applicableAt` varchar(50) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_process_document_history` */

/*Table structure for table `prog_slctn_process_quota_type_history` */

DROP TABLE IF EXISTS `prog_slctn_process_quota_type_history`;

CREATE TABLE `prog_slctn_process_quota_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `distributionBasis` varchar(50) DEFAULT NULL,
  `maxSeat` int(11) DEFAULT NULL,
  `minSeat` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `whetherMandatory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_process_quota_type_history` */

/*Table structure for table `prog_slctn_process_stage_quota_history` */

DROP TABLE IF EXISTS `prog_slctn_process_stage_quota_history`;

CREATE TABLE `prog_slctn_process_stage_quota_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `maxSeat` int(11) DEFAULT NULL,
  `minSeat` int(11) DEFAULT NULL,
  `overriddenMaxSeat` int(11) DEFAULT NULL,
  `overriddenMinSeat` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programSelProcessQuotaTypeId` bigint(20) DEFAULT NULL,
  `programSelectionProcessStageId` bigint(20) DEFAULT NULL,
  `quotaId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_process_stage_quota_history` */

/*Table structure for table `prog_slctn_stage_quota_overide_history` */

DROP TABLE IF EXISTS `prog_slctn_stage_quota_overide_history`;

CREATE TABLE `prog_slctn_stage_quota_overide_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `overriddenMaxSeat` int(11) DEFAULT NULL,
  `overriddenMinSeat` int(11) DEFAULT NULL,
  `overrideReason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  `programSelectionStageQuotaId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_stage_quota_overide_history` */

/*Table structure for table `prog_slctn_stage_trnsfr_seat_history` */

DROP TABLE IF EXISTS `prog_slctn_stage_trnsfr_seat_history`;

CREATE TABLE `prog_slctn_stage_trnsfr_seat_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `nmbrOfSeat` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `fromProgramSelectionStageQuotaId` bigint(20) DEFAULT NULL,
  `toProgramSelectionStageQuotaId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_slctn_stage_trnsfr_seat_history` */

/*Table structure for table `prog_wd_req_detail_programs_history` */

DROP TABLE IF EXISTS `prog_wd_req_detail_programs_history`;

CREATE TABLE `prog_wd_req_detail_programs_history` (
  `REV` int(11) NOT NULL,
  `programWithdrawReqDetailId` bigint(20) NOT NULL,
  `programId` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`REV`,`programWithdrawReqDetailId`,`programId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `prog_wd_req_detail_programs_history` */

/*Table structure for table `program_batch_course_param_history` */

DROP TABLE IF EXISTS `program_batch_course_param_history`;

CREATE TABLE `program_batch_course_param_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `canStudentWithdraw` tinyint(1) DEFAULT NULL,
  `ceasingLastDate` date DEFAULT NULL,
  `courseEvaluationTotal` int(11) DEFAULT NULL,
  `enrollmentCriteria` varchar(10) DEFAULT NULL,
  `maxSectionEnrollment` int(11) DEFAULT NULL,
  `minSectionEnrollment` int(11) DEFAULT NULL,
  `periods` varchar(10) DEFAULT NULL,
  `whetherCourseRepeatable` tinyint(1) DEFAULT NULL,
  `whetherOptional` tinyint(1) DEFAULT NULL,
  `whetherPrimary` tinyint(1) DEFAULT NULL,
  `whetherStudentSelectionOption` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `progBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `approverId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_batch_course_param_history` */

/*Table structure for table `program_batch_exam_center_history` */

DROP TABLE IF EXISTS `program_batch_exam_center_history`;

CREATE TABLE `program_batch_exam_center_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centerType` varchar(18) DEFAULT NULL,
  `selectionStage` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `examCenterId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_batch_exam_center_history` */

/*Table structure for table `program_batch_exam_history` */

DROP TABLE IF EXISTS `program_batch_exam_history`;

CREATE TABLE `program_batch_exam_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `centerType` varchar(18) DEFAULT NULL,
  `examCode` varchar(10) DEFAULT NULL,
  `examDate` date DEFAULT NULL,
  `studentAttended` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `centerId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_batch_exam_history` */

/*Table structure for table `program_batch_period_cf_data_history` */

DROP TABLE IF EXISTS `program_batch_period_cf_data_history`;

CREATE TABLE `program_batch_period_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `progBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_batch_period_cf_data_history` */

/*Table structure for table `program_batch_seat_type_cf_data_history` */

DROP TABLE IF EXISTS `program_batch_seat_type_cf_data_history`;

CREATE TABLE `program_batch_seat_type_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_batch_seat_type_cf_data_history` */

/*Table structure for table `program_batch_students_history` */

DROP TABLE IF EXISTS `program_batch_students_history`;

CREATE TABLE `program_batch_students_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `entryDate` date DEFAULT NULL,
  `exitDate` date DEFAULT NULL,
  `isCurrentPeriod` tinyint(1) DEFAULT NULL,
  `isCurrentSection` tinyint(1) DEFAULT NULL,
  `isPeriodCompleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `progBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_batch_students_history` */

/*Table structure for table `program_cf_data_history` */

DROP TABLE IF EXISTS `program_cf_data_history`;

CREATE TABLE `program_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_cf_data_history` */

/*Table structure for table `program_classification_history` */

DROP TABLE IF EXISTS `program_classification_history`;

CREATE TABLE `program_classification_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `classificationFieldName` varchar(10) DEFAULT NULL,
  `classificationFieldValue` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_classification_history` */

/*Table structure for table `program_course_faculty_fee_history` */

DROP TABLE IF EXISTS `program_course_faculty_fee_history`;

CREATE TABLE `program_course_faculty_fee_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `feeAmount` int(11) DEFAULT NULL,
  `feeAmountCurrency` int(11) DEFAULT NULL,
  `feeEffectiveFrom` datetime DEFAULT NULL,
  `feeType` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_course_faculty_fee_history` */

/*Table structure for table `program_course_group_history` */

DROP TABLE IF EXISTS `program_course_group_history`;

CREATE TABLE `program_course_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `coursesGroupsId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_course_group_history` */

/*Table structure for table `program_course_section_req_history` */

DROP TABLE IF EXISTS `program_course_section_req_history`;

CREATE TABLE `program_course_section_req_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `fromCourseId` bigint(20) DEFAULT NULL,
  `toCourseId` bigint(20) DEFAULT NULL,
  `executionRequestId` bigint(20) DEFAULT NULL,
  `fromProgramId` bigint(20) DEFAULT NULL,
  `toProgramId` bigint(20) DEFAULT NULL,
  `requestFollowUpId` bigint(20) DEFAULT NULL,
  `fromSectionId` bigint(20) DEFAULT NULL,
  `toSectionId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_course_section_req_history` */

/*Table structure for table `program_courses_history` */

DROP TABLE IF EXISTS `program_courses_history`;

CREATE TABLE `program_courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherOptional` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_courses_history` */

/*Table structure for table `program_group_history` */

DROP TABLE IF EXISTS `program_group_history`;

CREATE TABLE `program_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `groupName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_group_history` */

/*Table structure for table `program_history_history` */

DROP TABLE IF EXISTS `program_history_history`;

CREATE TABLE `program_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `noOfAdmissions` int(11) DEFAULT NULL,
  `noOfApplications` int(11) DEFAULT NULL,
  `noOfOfferedAdmissions` int(11) DEFAULT NULL,
  `noOfProvisionalAdmissions` int(11) DEFAULT NULL,
  `noOfQuotaViolations` int(11) DEFAULT NULL,
  `noOfRejected` int(11) DEFAULT NULL,
  `noOfRejectedAdmissions` int(11) DEFAULT NULL,
  `noOfReplacements` int(11) DEFAULT NULL,
  `noOfSeatsShortForQuota` int(11) DEFAULT NULL,
  `noOfTrialAdmissions` int(11) DEFAULT NULL,
  `noOfWithdrawls` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `progBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `quotaCodeId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_history_history` */

/*Table structure for table `program_period_seq_history` */

DROP TABLE IF EXISTS `program_period_seq_history`;

CREATE TABLE `program_period_seq_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `sequenceName` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programPeriodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_period_seq_history` */

/*Table structure for table `program_period_type_history` */

DROP TABLE IF EXISTS `program_period_type_history`;

CREATE TABLE `program_period_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `typeName` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_period_type_history` */

/*Table structure for table `program_related_course_cf_data_history` */

DROP TABLE IF EXISTS `program_related_course_cf_data_history`;

CREATE TABLE `program_related_course_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `relatedCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_related_course_cf_data_history` */

/*Table structure for table `program_related_course_history` */

DROP TABLE IF EXISTS `program_related_course_history`;

CREATE TABLE `program_related_course_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `courseDescription` varchar(255) DEFAULT NULL,
  `relationType` varchar(255) DEFAULT NULL,
  `setRelation` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `primaryCourseId` bigint(20) DEFAULT NULL,
  `secCourseId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_related_course_history` */

/*Table structure for table `program_selection_process_history` */

DROP TABLE IF EXISTS `program_selection_process_history`;

CREATE TABLE `program_selection_process_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `whetherAdmissionOpen` tinyint(1) DEFAULT NULL,
  `whetherReplacementAllowed` tinyint(1) DEFAULT NULL,
  `whetherSelectionInBatches` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `mandatoryQuotaTypeId` bigint(20) DEFAULT NULL,
  `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `selectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_selection_process_history` */

/*Table structure for table `program_set_deadlines_history` */

DROP TABLE IF EXISTS `program_set_deadlines_history`;

CREATE TABLE `program_set_deadlines_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `courseEndDate` date DEFAULT NULL,
  `courseStartDate` date DEFAULT NULL,
  `enrollmentLastDate` date DEFAULT NULL,
  `requestEndDate` date DEFAULT NULL,
  `requestStartDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `programBatchPeriodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_set_deadlines_history` */

/*Table structure for table `program_slctn_process_stages_history` */

DROP TABLE IF EXISTS `program_slctn_process_stages_history`;

CREATE TABLE `program_slctn_process_stages_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `currentStatus` varchar(50) DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `entryRule` varchar(50) DEFAULT NULL,
  `entryRuleDescription` varchar(255) DEFAULT NULL,
  `exitRule` varchar(50) DEFAULT NULL,
  `exitRuleDescription` varchar(255) DEFAULT NULL,
  `maxSeat` int(11) DEFAULT NULL,
  `minSeat` int(11) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approverAuthority` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_slctn_process_stages_history` */

/*Table structure for table `program_slctn_process_status_history` */

DROP TABLE IF EXISTS `program_slctn_process_status_history`;

CREATE TABLE `program_slctn_process_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programSelectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_slctn_process_status_history` */

/*Table structure for table `program_slctn_stage_statistics_history` */

DROP TABLE IF EXISTS `program_slctn_stage_statistics_history`;

CREATE TABLE `program_slctn_stage_statistics_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `numberOfApplication` bigint(20) DEFAULT NULL,
  `numberOfSelectedStudents` bigint(20) DEFAULT NULL,
  `numberOfStudentsInWaitList` bigint(20) DEFAULT NULL,
  `numberOfStudentsRejected` bigint(20) DEFAULT NULL,
  `numberOfStudentsReplaced` bigint(20) DEFAULT NULL,
  `numberOfStudentsWithdrawn` bigint(20) DEFAULT NULL,
  `violation` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programSelectionProcStageQuota` bigint(20) DEFAULT NULL,
  `programSelectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_slctn_stage_statistics_history` */

/*Table structure for table `program_withdraw_req_details_history` */

DROP TABLE IF EXISTS `program_withdraw_req_details_history`;

CREATE TABLE `program_withdraw_req_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_withdraw_req_details_history` */

/*Table structure for table `program_withdrawal_reasons_history` */

DROP TABLE IF EXISTS `program_withdrawal_reasons_history`;

CREATE TABLE `program_withdrawal_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_withdrawal_reasons_history` */

/*Table structure for table `program_withdrawals_history` */

DROP TABLE IF EXISTS `program_withdrawals_history`;

CREATE TABLE `program_withdrawals_history` (
  `completionId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `tillDate` datetime DEFAULT NULL,
  `reasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`completionId`,`REV`),
  KEY `FKD4E8A978BE3F3224` (`completionId`,`REV`),
  CONSTRAINT `FKD4E8A978BE3F3224` FOREIGN KEY (`completionId`, `REV`) REFERENCES `completions_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_withdrawals_history` */

/*Table structure for table `program_xfer_request_details_history` */

DROP TABLE IF EXISTS `program_xfer_request_details_history`;

CREATE TABLE `program_xfer_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `fromProgramId` bigint(20) DEFAULT NULL,
  `toProgramId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `program_xfer_request_details_history` */

/*Table structure for table `programs_history` */

DROP TABLE IF EXISTS `programs_history`;

CREATE TABLE `programs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `categoryField1` varchar(15) DEFAULT NULL,
  `categoryField2` varchar(15) DEFAULT NULL,
  `categoryField3` varchar(15) DEFAULT NULL,
  `categoryField4` varchar(15) DEFAULT NULL,
  `categoryField5` varchar(15) DEFAULT NULL,
  `isLongDistanceProgram` tinyint(1) DEFAULT NULL,
  `isPeriodTransitionApplicable` tinyint(1) DEFAULT NULL,
  `isSingleCourseProgram` tinyint(1) DEFAULT NULL,
  `programClosureDate` date DEFAULT NULL,
  `programClosureReason` varchar(100) DEFAULT NULL,
  `programCode` varchar(10) DEFAULT NULL,
  `programMarkGrade` varchar(1) DEFAULT NULL,
  `programName` varchar(255) DEFAULT NULL,
  `programNameToBePrint` varchar(255) DEFAULT NULL,
  `programShortName` varchar(35) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` char(1) DEFAULT NULL,
  `whetherCreateNewAdmission` tinyint(1) DEFAULT NULL,
  `whetherSucceedingProgram` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programDepartmentId` bigint(20) DEFAULT NULL,
  `subDepartmentId` bigint(20) DEFAULT NULL,
  `succeedingProgramId` bigint(20) DEFAULT NULL,
  `programGroupId` bigint(20) DEFAULT NULL,
  `approver` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `programs_history` */

/*Table structure for table `promotion_history` */

DROP TABLE IF EXISTS `promotion_history`;

CREATE TABLE `promotion_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvalDate` date DEFAULT NULL,
  `promotionType` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approver` bigint(20) DEFAULT NULL,
  `fromRecordId` bigint(20) DEFAULT NULL,
  `toRecordId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `promotion_history` */

/*Table structure for table `questions_history` */

DROP TABLE IF EXISTS `questions_history`;

CREATE TABLE `questions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `displayOrder` bigint(20) DEFAULT NULL,
  `questionCode` varchar(255) DEFAULT NULL,
  `questionText` varchar(255) DEFAULT NULL,
  `questionType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `questions_history` */

/*Table structure for table `quota_history` */

DROP TABLE IF EXISTS `quota_history`;

CREATE TABLE `quota_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicabilityRule` varchar(100) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `displayOrder` bigint(20) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ruleDescription` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `quota_history` */

/*Table structure for table `quota_validity_history` */

DROP TABLE IF EXISTS `quota_validity_history`;

CREATE TABLE `quota_validity_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `validFrom` datetime DEFAULT NULL,
  `validTill` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `quotaId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `quota_validity_history` */

/*Table structure for table `re_exam_request_details_history` */

DROP TABLE IF EXISTS `re_exam_request_details_history`;

CREATE TABLE `re_exam_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approvalRequiredReason` varchar(255) DEFAULT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `currentExamBatchId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `re_exam_request_details_history` */

/*Table structure for table `reasons_history` */

DROP TABLE IF EXISTS `reasons_history`;

CREATE TABLE `reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `reasons_history` */

/*Table structure for table `rec_bill_fee_plan_stg_history` */

DROP TABLE IF EXISTS `rec_bill_fee_plan_stg_history`;

CREATE TABLE `rec_bill_fee_plan_stg_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `instrumentNo` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `rec_bill_fee_plan_stg_history` */

/*Table structure for table `receipt_adjustment_history` */

DROP TABLE IF EXISTS `receipt_adjustment_history`;

CREATE TABLE `receipt_adjustment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `recBillFeePlanStgId` bigint(20) DEFAULT NULL,
  `receiptPayInstrumentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `receipt_adjustment_history` */

/*Table structure for table `receipt_header_history` */

DROP TABLE IF EXISTS `receipt_header_history`;

CREATE TABLE `receipt_header_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `integratedWithTally` tinyint(1) DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `receiptNo` varchar(255) DEFAULT NULL,
  `receiptType` varchar(255) DEFAULT NULL,
  `receiptUniqueNumber` int(11) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `tallyVoucherId` int(11) DEFAULT NULL,
  `transactionDate` date DEFAULT NULL,
  `transactionType` varchar(10) DEFAULT NULL,
  `voucherMode` varchar(255) DEFAULT NULL,
  `voucherType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `depositedBank` bigint(20) DEFAULT NULL,
  `depositedCash` bigint(20) DEFAULT NULL,
  `thirdPartyId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `receiptFor` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `receipt_header_history` */

/*Table structure for table `receipt_payment_instrument_history` */

DROP TABLE IF EXISTS `receipt_payment_instrument_history`;

CREATE TABLE `receipt_payment_instrument_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `instrumentDate` date DEFAULT NULL,
  `instrumentNo` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `instrumentBank` bigint(20) DEFAULT NULL,
  `paymentHeaderId` bigint(20) DEFAULT NULL,
  `paymentMode` bigint(20) DEFAULT NULL,
  `receiptHeaderId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `receipt_payment_instrument_history` */

/*Table structure for table `reexamination_req_types_history` */

DROP TABLE IF EXISTS `reexamination_req_types_history`;

CREATE TABLE `reexamination_req_types_history` (
  `examRequestTypeDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `currentExamDate` datetime DEFAULT NULL,
  `currentExamBatchId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`examRequestTypeDetailId`,`REV`),
  KEY `FKBFEDDECC7BF72940` (`examRequestTypeDetailId`,`REV`),
  CONSTRAINT `FKBFEDDECC7BF72940` FOREIGN KEY (`examRequestTypeDetailId`, `REV`) REFERENCES `exam_request_type_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `reexamination_req_types_history` */

/*Table structure for table `refund_details_history` */

DROP TABLE IF EXISTS `refund_details_history`;

CREATE TABLE `refund_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amountPaid` float DEFAULT NULL,
  `depositedIn` varchar(10) DEFAULT NULL,
  `drawnOn` date DEFAULT NULL,
  `instrumentAmount` int(11) DEFAULT NULL,
  `instrumentDate` date DEFAULT NULL,
  `instrumentNo` int(11) DEFAULT NULL,
  `paymentMode` varchar(2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `billRefundHeaderId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `refund_details_history` */

/*Table structure for table `refund_reasons_history` */

DROP TABLE IF EXISTS `refund_reasons_history`;

CREATE TABLE `refund_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `reasonCode` varchar(255) DEFAULT NULL,
  `reasonStatus` varchar(255) DEFAULT NULL,
  `reasonTitle` varchar(255) DEFAULT NULL,
  `reasonType` varchar(255) DEFAULT NULL,
  `ruleAgenda` varchar(50) DEFAULT NULL,
  `ruleDescription` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `refund_reasons_history` */

/*Table structure for table `relations_data_to_be_changed_history` */

DROP TABLE IF EXISTS `relations_data_to_be_changed_history`;

CREATE TABLE `relations_data_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `birthDate` datetime DEFAULT NULL,
  `bloodGroup` varchar(255) DEFAULT NULL,
  `emailId` varchar(255) DEFAULT NULL,
  `employeeId` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `whetherEmployeeOfOrganization` tinyint(1) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `maritalStatus` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `mobileNumber` varchar(255) DEFAULT NULL,
  `occupation` varchar(255) DEFAULT NULL,
  `personalIncome` decimal(19,2) DEFAULT NULL,
  `photoUrl` varchar(255) DEFAULT NULL,
  `relationship` varchar(255) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FK5D192C47BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FK5D192C47BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `relations_data_to_be_changed_history` */

/*Table structure for table `religions_history` */

DROP TABLE IF EXISTS `religions_history`;

CREATE TABLE `religions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `religions_history` */

/*Table structure for table `reopen_reason_history` */

DROP TABLE IF EXISTS `reopen_reason_history`;

CREATE TABLE `reopen_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `reasonCode` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `reopen_reason_history` */

/*Table structure for table `repeat_stu_detail_seq_history` */

DROP TABLE IF EXISTS `repeat_stu_detail_seq_history`;

CREATE TABLE `repeat_stu_detail_seq_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationPlanNo` varchar(15) DEFAULT NULL,
  `evaluationType` varchar(18) DEFAULT NULL,
  `feeAmount` int(11) DEFAULT NULL,
  `status` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `evalDetailSeqId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `repeatationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `repeat_stu_detail_seq_history` */

/*Table structure for table `repeating_course_comp_history` */

DROP TABLE IF EXISTS `repeating_course_comp_history`;

CREATE TABLE `repeating_course_comp_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `repeatationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `repeating_course_comp_history` */

/*Table structure for table `repeating_student_history` */

DROP TABLE IF EXISTS `repeating_student_history`;

CREATE TABLE `repeating_student_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationPlanNo` varchar(15) DEFAULT NULL,
  `evaluationType` varchar(18) DEFAULT NULL,
  `feeAmount` int(11) DEFAULT NULL,
  `repeatationType` varchar(10) DEFAULT NULL,
  `repetitionType` varchar(15) DEFAULT NULL,
  `status` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  `evalDetailSeqId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `repeating_student_history` */

/*Table structure for table `replacement_list_history` */

DROP TABLE IF EXISTS `replacement_list_history`;

CREATE TABLE `replacement_list_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `replacementStatus` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicantToBeReplacedId` bigint(20) DEFAULT NULL,
  `applicantToBeSelectedId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `replacement_list_history` */

/*Table structure for table `report_audit_history` */

DROP TABLE IF EXISTS `report_audit_history`;

CREATE TABLE `report_audit_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `reportAccessTime` datetime DEFAULT NULL,
  `reportOutputType` varchar(35) DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `systemReportId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `report_audit_history` */

/*Table structure for table `req_against_bill_details_history` */

DROP TABLE IF EXISTS `req_against_bill_details_history`;

CREATE TABLE `req_against_bill_details_history` (
  `feeRelatedRequestDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `billHeaderId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`feeRelatedRequestDetailId`,`REV`),
  KEY `FK62E12B1E48E85700` (`feeRelatedRequestDetailId`,`REV`),
  CONSTRAINT `FK62E12B1E48E85700` FOREIGN KEY (`feeRelatedRequestDetailId`, `REV`) REFERENCES `fee_related_request_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `req_against_bill_details_history` */

/*Table structure for table `req_against_feehead_details_history` */

DROP TABLE IF EXISTS `req_against_feehead_details_history`;

CREATE TABLE `req_against_feehead_details_history` (
  `feeRelatedRequestDetailId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`feeRelatedRequestDetailId`,`REV`),
  KEY `FKBD9E7B9F48E85700` (`feeRelatedRequestDetailId`,`REV`),
  CONSTRAINT `FKBD9E7B9F48E85700` FOREIGN KEY (`feeRelatedRequestDetailId`, `REV`) REFERENCES `fee_related_request_details_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `req_against_feehead_details_history` */

/*Table structure for table `req_documents_submitted_history` */

DROP TABLE IF EXISTS `req_documents_submitted_history`;

CREATE TABLE `req_documents_submitted_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `changeDocumentsName` varchar(40) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `req_documents_submitted_history` */

/*Table structure for table `request_followup_history` */

DROP TABLE IF EXISTS `request_followup_history`;

CREATE TABLE `request_followup_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `actualFlwDate` date DEFAULT NULL,
  `approverRemarks` varchar(255) DEFAULT NULL,
  `followUpRemarks` varchar(255) DEFAULT NULL,
  `nextFollowUpDate` date DEFAULT NULL,
  `plannedFollowupDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  `approverId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `request_followup_history` */

/*Table structure for table `request_for_installment_history` */

DROP TABLE IF EXISTS `request_for_installment_history`;

CREATE TABLE `request_for_installment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `installmentAmount` int(11) DEFAULT NULL,
  `installmentDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `request_for_installment_history` */

/*Table structure for table `request_handover_modes_history` */

DROP TABLE IF EXISTS `request_handover_modes_history`;

CREATE TABLE `request_handover_modes_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `request_handover_modes_history` */

/*Table structure for table `request_status_history` */

DROP TABLE IF EXISTS `request_status_history`;

CREATE TABLE `request_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `serviceRequestStage` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `request_status_history` */

/*Table structure for table `request_type_categories_history` */

DROP TABLE IF EXISTS `request_type_categories_history`;

CREATE TABLE `request_type_categories_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `serviceRequestCategory` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `requestTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `request_type_categories_history` */

/*Table structure for table `request_types_history` */

DROP TABLE IF EXISTS `request_types_history`;

CREATE TABLE `request_types_history` (
  `type` varchar(31) NOT NULL,
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `requestTypeCode` varchar(255) DEFAULT NULL,
  `requestTypeName` varchar(255) DEFAULT NULL,
  `serviceRequestGroup` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feeRelatedCategory` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `request_types_history` */

/*Table structure for table `res_unavail_infos_history` */

DROP TABLE IF EXISTS `res_unavail_infos_history`;

CREATE TABLE `res_unavail_infos_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `reasonId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `res_unavail_infos_history` */

/*Table structure for table `res_unavail_reason_history` */

DROP TABLE IF EXISTS `res_unavail_reason_history`;

CREATE TABLE `res_unavail_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `res_unavail_reason_history` */

/*Table structure for table `reservation_category_history` */

DROP TABLE IF EXISTS `reservation_category_history`;

CREATE TABLE `reservation_category_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `categoryCode` varchar(10) DEFAULT NULL,
  `categoryDescription` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `reservation_category_history` */

/*Table structure for table `resource_types_history` */

DROP TABLE IF EXISTS `resource_types_history`;

CREATE TABLE `resource_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `resourceGroup` varchar(10) DEFAULT NULL,
  `typeName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `resource_types_history` */

/*Table structure for table `resources_history` */

DROP TABLE IF EXISTS `resources_history`;

CREATE TABLE `resources_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `availabilityStatus` varchar(255) DEFAULT NULL,
  `capacity` int(11) DEFAULT NULL,
  `categoryCode` varchar(10) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  `landMark` varchar(20) DEFAULT NULL,
  `resourceName` varchar(20) DEFAULT NULL,
  `nameToBePrinted` varchar(10) DEFAULT NULL,
  `resourceDescription` varchar(255) DEFAULT NULL,
  `resourceGroup` varchar(15) DEFAULT NULL,
  `shortName` varchar(15) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `whetherConflictAcceptable` tinyint(1) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `whetherDependent` tinyint(1) DEFAULT NULL,
  `whetherSharingAllowed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `resourceTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `resources_history` */

/*Table structure for table `result_details_history` */

DROP TABLE IF EXISTS `result_details_history`;

CREATE TABLE `result_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `errorCode` varchar(10) DEFAULT NULL,
  `graceMarksGiven` float DEFAULT NULL,
  `marksGiven` float DEFAULT NULL,
  `negativeMarksGiven` float DEFAULT NULL,
  `penultyMarksGiven` int(11) DEFAULT NULL,
  `questionPart` varchar(6) DEFAULT NULL,
  `questionPart1` varchar(6) DEFAULT NULL,
  `wrongMarksGiven` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `examinationResultId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `result_details_history` */

/*Table structure for table `revaluation_exam_paper_request_details_history` */

DROP TABLE IF EXISTS `revaluation_exam_paper_request_details_history`;

CREATE TABLE `revaluation_exam_paper_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `questionNo` bigint(20) DEFAULT NULL,
  `questionNoPart` bigint(20) DEFAULT NULL,
  `questionNoPart1` bigint(20) DEFAULT NULL,
  `totalMarks` bigint(20) DEFAULT NULL,
  `whetherQuestionWise` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `evaluationSequenceDetailId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `revaluation_exam_paper_request_details_history` */

/*Table structure for table `role_portals_history` */

DROP TABLE IF EXISTS `role_portals_history`;

CREATE TABLE `role_portals_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `portalId` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `role_portals_history` */

/*Table structure for table `role_privileges_history` */

DROP TABLE IF EXISTS `role_privileges_history`;

CREATE TABLE `role_privileges_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `granted` tinyint(1) DEFAULT NULL,
  `whetherOverrideAllowed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `featurePrivilegeId` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `role_privileges_history` */

/*Table structure for table `roles_history` */

DROP TABLE IF EXISTS `roles_history`;

CREATE TABLE `roles_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `createdOn` datetime DEFAULT NULL,
  `roleDesc` longtext,
  `roleName` varchar(35) DEFAULT NULL,
  `serialNumber` varchar(10) DEFAULT NULL,
  `whetherDeletable` tinyint(1) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `whetherEditable` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `roles_history` */

/*Table structure for table `salutations_history` */

DROP TABLE IF EXISTS `salutations_history`;

CREATE TABLE `salutations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `salutationName` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `salutations_history` */

/*Table structure for table `scholarship_academy_locations_history` */

DROP TABLE IF EXISTS `scholarship_academy_locations_history`;

CREATE TABLE `scholarship_academy_locations_history` (
  `REV` int(11) NOT NULL,
  `scholarshipId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `id` bigint(20) NOT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_academy_locations_history` */

/*Table structure for table `scholarship_account_details_history` */

DROP TABLE IF EXISTS `scholarship_account_details_history`;

CREATE TABLE `scholarship_account_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `controlAccount` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_account_details_history` */

/*Table structure for table `scholarship_awardees_history` */

DROP TABLE IF EXISTS `scholarship_awardees_history`;

CREATE TABLE `scholarship_awardees_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `appliedOn` date DEFAULT NULL,
  `awardedOn` date DEFAULT NULL,
  `scholarshipAmount` double DEFAULT NULL,
  `validFrom` date DEFAULT NULL,
  `validUpto` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_awardees_history` */

/*Table structure for table `scholarship_batches_history` */

DROP TABLE IF EXISTS `scholarship_batches_history`;

CREATE TABLE `scholarship_batches_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_batches_history` */

/*Table structure for table `scholarship_courses_history` */

DROP TABLE IF EXISTS `scholarship_courses_history`;

CREATE TABLE `scholarship_courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_courses_history` */

/*Table structure for table `scholarship_history` */

DROP TABLE IF EXISTS `scholarship_history`;

CREATE TABLE `scholarship_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `adjustmentAllowed` tinyint(1) DEFAULT NULL,
  `allowConcessionCandidate` tinyint(1) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `applicationMode` varchar(3) DEFAULT NULL,
  `disbursementMode` varchar(3) DEFAULT NULL,
  `droolAgenda` varchar(150) DEFAULT NULL,
  `droolAgendaDescription` varchar(255) DEFAULT NULL,
  `maxNoAwardees` int(11) DEFAULT NULL,
  `paymentType` varchar(3) DEFAULT NULL,
  `scholarshipAmountType` varchar(3) DEFAULT NULL,
  `scholarshipCode` varchar(150) DEFAULT NULL,
  `scholarshipName` varchar(150) DEFAULT NULL,
  `scholarshipStatus` tinyint(1) DEFAULT NULL,
  `scholarshipType` varchar(3) DEFAULT NULL,
  `selectionType` varchar(3) DEFAULT NULL,
  `validityInMonth` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `scholarshipOrganizationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_history` */

/*Table structure for table `scholarship_installments_history` */

DROP TABLE IF EXISTS `scholarship_installments_history`;

CREATE TABLE `scholarship_installments_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `durationInMonth` int(11) DEFAULT NULL,
  `periodName` varchar(150) DEFAULT NULL,
  `periodSequence` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_installments_history` */

/*Table structure for table `scholarship_organizations_history` */

DROP TABLE IF EXISTS `scholarship_organizations_history`;

CREATE TABLE `scholarship_organizations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `organizationName` varchar(150) DEFAULT NULL,
  `organizationType` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_organizations_history` */

/*Table structure for table `scholarship_programs_history` */

DROP TABLE IF EXISTS `scholarship_programs_history`;

CREATE TABLE `scholarship_programs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_programs_history` */

/*Table structure for table `scholarship_request_details_history` */

DROP TABLE IF EXISTS `scholarship_request_details_history`;

CREATE TABLE `scholarship_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `awardDate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_request_details_history` */

/*Table structure for table `scholarship_transactions_history` */

DROP TABLE IF EXISTS `scholarship_transactions_history`;

CREATE TABLE `scholarship_transactions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `instrumentDate` date DEFAULT NULL,
  `instrumentDrawnOn` varchar(150) DEFAULT NULL,
  `instrumentNo` varchar(50) DEFAULT NULL,
  `transactionAmount` double DEFAULT NULL,
  `transactionDate` datetime DEFAULT NULL,
  `transactionNote` varchar(255) DEFAULT NULL,
  `transactionType` varchar(3) DEFAULT NULL,
  `voucherReference` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `scholarshipAwardeeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `scholarship_transactions_history` */

/*Table structure for table `seat_types_history` */

DROP TABLE IF EXISTS `seat_types_history`;

CREATE TABLE `seat_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `seatCode` varchar(10) DEFAULT NULL,
  `seatDescription` varchar(30) DEFAULT NULL,
  `seatName` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `seat_types_history` */

/*Table structure for table `section_cf_data_history` */

DROP TABLE IF EXISTS `section_cf_data_history`;

CREATE TABLE `section_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `section_cf_data_history` */

/*Table structure for table `section_xfer_request_details_history` */

DROP TABLE IF EXISTS `section_xfer_request_details_history`;

CREATE TABLE `section_xfer_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `isTransferRelatedProgram` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `fromSectionId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `toSectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `section_xfer_request_details_history` */

/*Table structure for table `sections_history` */

DROP TABLE IF EXISTS `sections_history`;

CREATE TABLE `sections_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `alternateName` longtext,
  `maxCapacity` int(11) DEFAULT NULL,
  `minCapacity` int(11) DEFAULT NULL,
  `sectionCode` longtext,
  `sectionRule` longtext,
  `studentCourseEnrollmentCriteria` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roomId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sections_history` */

/*Table structure for table `selection_override_history` */

DROP TABLE IF EXISTS `selection_override_history`;

CREATE TABLE `selection_override_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `overrideDate` date DEFAULT NULL,
  `reasonForOverride` varchar(255) DEFAULT NULL,
  `whetherOverrideQuota` tinyint(1) DEFAULT NULL,
  `whetherTransSeatType` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `seatTypeId` bigint(20) DEFAULT NULL,
  `selectStageId` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `selection_override_history` */

/*Table structure for table `selection_stage_history` */

DROP TABLE IF EXISTS `selection_stage_history`;

CREATE TABLE `selection_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `stageName` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `selection_stage_history` */

/*Table structure for table `seq_academy_location_history` */

DROP TABLE IF EXISTS `seq_academy_location_history`;

CREATE TABLE `seq_academy_location_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationType` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `sequenceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `seq_academy_location_history` */

/*Table structure for table `sequence_header_history` */

DROP TABLE IF EXISTS `sequence_header_history`;

CREATE TABLE `sequence_header_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `prefixNumber` varchar(45) DEFAULT NULL,
  `sequenceCode` varchar(10) DEFAULT NULL,
  `sequenceName` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sequence_header_history` */

/*Table structure for table `service_history` */

DROP TABLE IF EXISTS `service_history`;

CREATE TABLE `service_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `billFaculty` varchar(255) DEFAULT NULL,
  `facilityAvailable` tinyint(1) DEFAULT NULL,
  `serviceCode` varchar(255) DEFAULT NULL,
  `serviceDescription` varchar(18) DEFAULT NULL,
  `serviceName` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_history` */

/*Table structure for table `service_locations_history` */

DROP TABLE IF EXISTS `service_locations_history`;

CREATE TABLE `service_locations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
  `serviceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_locations_history` */

/*Table structure for table `service_received_history` */

DROP TABLE IF EXISTS `service_received_history`;

CREATE TABLE `service_received_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `contactPerson` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `serviceName` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_received_history` */

/*Table structure for table `service_request_details_history` */

DROP TABLE IF EXISTS `service_request_details_history`;

CREATE TABLE `service_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `requestDate` datetime DEFAULT NULL,
  `requesterType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `enteredByUserId` bigint(20) DEFAULT NULL,
  `requesterUserId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_request_details_history` */

/*Table structure for table `service_request_documents_history` */

DROP TABLE IF EXISTS `service_request_documents_history`;

CREATE TABLE `service_request_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_request_documents_history` */

/*Table structure for table `service_request_history` */

DROP TABLE IF EXISTS `service_request_history`;

CREATE TABLE `service_request_history` (
  `type` varchar(31) NOT NULL,
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dueDate` datetime DEFAULT NULL,
  `executionDate` datetime DEFAULT NULL,
  `whetherWithdrawn` tinyint(1) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `requestDate` datetime DEFAULT NULL,
  `requestId` varchar(255) DEFAULT NULL,
  `requesterType` varchar(255) DEFAULT NULL,
  `serviceRequestStage` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `assigneeId` bigint(20) DEFAULT NULL,
  `enteredBy` bigint(20) DEFAULT NULL,
  `requestStatusId` bigint(20) DEFAULT NULL,
  `requester` bigint(20) DEFAULT NULL,
  `serviceRequestSettingId` bigint(20) DEFAULT NULL,
  `complaintTypeSettingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_request_history` */

/*Table structure for table `service_request_setting_status_history` */

DROP TABLE IF EXISTS `service_request_setting_status_history`;

CREATE TABLE `service_request_setting_status_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `requestStatusId` bigint(20) DEFAULT NULL,
  `serviceRequestSettingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_request_setting_status_history` */

/*Table structure for table `service_request_settings_history` */

DROP TABLE IF EXISTS `service_request_settings_history`;

CREATE TABLE `service_request_settings_history` (
  `type` varchar(31) NOT NULL,
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `billingPreference` varchar(255) DEFAULT NULL,
  `whetherAutoApprove` tinyint(1) DEFAULT NULL,
  `whetherFeeApplicable` tinyint(1) DEFAULT NULL,
  `serviceRequestCategory` varchar(255) DEFAULT NULL,
  `requestType` varchar(255) DEFAULT NULL,
  `sla` int(11) DEFAULT NULL,
  `subRequestType` varchar(255) DEFAULT NULL,
  `whetherDocumentRequired` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `defaultApproverUserId` bigint(20) DEFAULT NULL,
  `defaultAssigneeUserId` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  `feePlanTypeId` bigint(20) DEFAULT NULL,
  `feePlanStageId` bigint(20) DEFAULT NULL,
  `freeFormRequestTypeId` bigint(20) DEFAULT NULL,
  `feeRelatedRequestTypeId` bigint(20) DEFAULT NULL,
  `requestTypeId` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_request_settings_history` */

/*Table structure for table `service_request_vol_documents_history` */

DROP TABLE IF EXISTS `service_request_vol_documents_history`;

CREATE TABLE `service_request_vol_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_request_vol_documents_history` */

/*Table structure for table `service_sw_request_details_history` */

DROP TABLE IF EXISTS `service_sw_request_details_history`;

CREATE TABLE `service_sw_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `validFromDate` datetime DEFAULT NULL,
  `whetherSubscribed` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `service_sw_request_details_history` */

/*Table structure for table `session_attedance_history` */

DROP TABLE IF EXISTS `session_attedance_history`;

CREATE TABLE `session_attedance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `whetherCompleteDay` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseTopicSessionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `session_attedance_history` */

/*Table structure for table `slctn_process_history` */

DROP TABLE IF EXISTS `slctn_process_history`;

CREATE TABLE `slctn_process_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `quotaTypeRemark` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_process_history` */

/*Table structure for table `slctn_process_quota_type_history` */

DROP TABLE IF EXISTS `slctn_process_quota_type_history`;

CREATE TABLE `slctn_process_quota_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `selectionProcessId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_process_quota_type_history` */

/*Table structure for table `slctn_process_stage_eval_param_history` */

DROP TABLE IF EXISTS `slctn_process_stage_eval_param_history`;

CREATE TABLE `slctn_process_stage_eval_param_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationType` varchar(20) DEFAULT NULL,
  `includePrevsStagePerformance` tinyint(1) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `ruleForGradeTomark` varchar(100) DEFAULT NULL,
  `whetherAutomatic` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_process_stage_eval_param_history` */

/*Table structure for table `slctn_process_stage_history` */

DROP TABLE IF EXISTS `slctn_process_stage_history`;

CREATE TABLE `slctn_process_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `committeeApprovalRequired` tinyint(1) DEFAULT NULL,
  `expNumberOfDays` int(11) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `stageOrder` bigint(20) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `validTill` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `selectionProcessId` bigint(20) DEFAULT NULL,
  `stageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_process_stage_history` */

/*Table structure for table `slctn_stage_cndtnl_marks_history` */

DROP TABLE IF EXISTS `slctn_stage_cndtnl_marks_history`;

CREATE TABLE `slctn_stage_cndtnl_marks_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marks` float DEFAULT NULL,
  `rule` varchar(100) DEFAULT NULL,
  `ruleDescription` varchar(255) DEFAULT NULL,
  `ruleName` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `stageEvalParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_stage_cndtnl_marks_history` */

/*Table structure for table `slctn_stage_documents_history` */

DROP TABLE IF EXISTS `slctn_stage_documents_history`;

CREATE TABLE `slctn_stage_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `documentFor` varchar(100) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `rule` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_stage_documents_history` */

/*Table structure for table `slctn_stage_eval_prm_weightage_history` */

DROP TABLE IF EXISTS `slctn_stage_eval_prm_weightage_history`;

CREATE TABLE `slctn_stage_eval_prm_weightage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `evaluationParameter` varchar(100) DEFAULT NULL,
  `maxMarks` float DEFAULT NULL,
  `weightage` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `stageEvalParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_stage_eval_prm_weightage_history` */

/*Table structure for table `slctn_stage_prvs_weightage_history` */

DROP TABLE IF EXISTS `slctn_stage_prvs_weightage_history`;

CREATE TABLE `slctn_stage_prvs_weightage_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `weightage` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `previousStageId` bigint(20) DEFAULT NULL,
  `stageEvalParamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_stage_prvs_weightage_history` */

/*Table structure for table `slctn_stage_resource_plan_history` */

DROP TABLE IF EXISTS `slctn_stage_resource_plan_history`;

CREATE TABLE `slctn_stage_resource_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `resourseCategory` varchar(35) DEFAULT NULL,
  `resourceGroup` varchar(50) DEFAULT NULL,
  `resourceQuantity` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `resourceTypeId` bigint(20) DEFAULT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `slctn_stage_resource_plan_history` */

/*Table structure for table `specialization_group_history` */

DROP TABLE IF EXISTS `specialization_group_history`;

CREATE TABLE `specialization_group_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  `specializationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `specialization_group_history` */

/*Table structure for table `specialization_history` */

DROP TABLE IF EXISTS `specialization_history`;

CREATE TABLE `specialization_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `specializationCode` varchar(255) DEFAULT NULL,
  `specializationDescription` varchar(255) DEFAULT NULL,
  `specializationName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `specialization_history` */

/*Table structure for table `sponsor_account_details_history` */

DROP TABLE IF EXISTS `sponsor_account_details_history`;

CREATE TABLE `sponsor_account_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `controlAccount` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountingConfigId` bigint(20) DEFAULT NULL,
  `configControlAccountId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsor_account_details_history` */

/*Table structure for table `sponsor_contacts_history` */

DROP TABLE IF EXISTS `sponsor_contacts_history`;

CREATE TABLE `sponsor_contacts_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `contactName` varchar(100) DEFAULT NULL,
  `designation` varchar(25) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsor_contacts_history` */

/*Table structure for table `sponsor_receipt_disbursments_history` */

DROP TABLE IF EXISTS `sponsor_receipt_disbursments_history`;

CREATE TABLE `sponsor_receipt_disbursments_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `instrumentDate` date DEFAULT NULL,
  `instrumentDrawnOn` varchar(18) DEFAULT NULL,
  `instrumentNo` varchar(10) DEFAULT NULL,
  `transactionAmount` float DEFAULT NULL,
  `transactionDate` date DEFAULT NULL,
  `transactionNote` varchar(255) DEFAULT NULL,
  `transactionType` char(1) DEFAULT NULL,
  `voucherReference` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsor_receipt_disbursments_history` */

/*Table structure for table `sponsors_history` */

DROP TABLE IF EXISTS `sponsors_history`;

CREATE TABLE `sponsors_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `consolidationAllowed` tinyint(1) DEFAULT NULL,
  `sponsorName` varchar(150) DEFAULT NULL,
  `sponsorStatus` tinyint(1) DEFAULT NULL,
  `sponsorType` varchar(3) DEFAULT NULL,
  `sponsorshipCode` varchar(15) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsors_history` */

/*Table structure for table `sponsorship_awarded_items_history` */

DROP TABLE IF EXISTS `sponsorship_awarded_items_history`;

CREATE TABLE `sponsorship_awarded_items_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `awardDate` date DEFAULT NULL,
  `totalFeeHeadAmount` float DEFAULT NULL,
  `totalSponsoredAmount` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `sponsorshipAwardeeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsorship_awarded_items_history` */

/*Table structure for table `sponsorship_awardees_history` */

DROP TABLE IF EXISTS `sponsorship_awardees_history`;

CREATE TABLE `sponsorship_awardees_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsorship_awardees_history` */

/*Table structure for table `sponsorship_installments_history` */

DROP TABLE IF EXISTS `sponsorship_installments_history`;

CREATE TABLE `sponsorship_installments_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `amountType` varchar(255) DEFAULT NULL,
  `sponsorshipPercentage` float DEFAULT NULL,
  `feeplanSubSchedId` bigint(20) DEFAULT NULL,
  `sponsorshipAwardedItemId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sponsorship_installments_history` */

/*Table structure for table `srvc_sw_req_detail_s_services_history` */

DROP TABLE IF EXISTS `srvc_sw_req_detail_s_services_history`;

CREATE TABLE `srvc_sw_req_detail_s_services_history` (
  `REV` int(11) NOT NULL,
  `serviceSWRequestDetailId` bigint(20) NOT NULL,
  `subscribedServiceId` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`REV`,`serviceSWRequestDetailId`,`subscribedServiceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `srvc_sw_req_detail_s_services_history` */

/*Table structure for table `srvc_sw_req_detail_w_services_history` */

DROP TABLE IF EXISTS `srvc_sw_req_detail_w_services_history`;

CREATE TABLE `srvc_sw_req_detail_w_services_history` (
  `REV` int(11) NOT NULL,
  `serviceSWRequestDetailId` bigint(20) NOT NULL,
  `withdrawnServiceId` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`REV`,`serviceSWRequestDetailId`,`withdrawnServiceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `srvc_sw_req_detail_w_services_history` */

/*Table structure for table `staffs_history` */

DROP TABLE IF EXISTS `staffs_history`;

CREATE TABLE `staffs_history` (
  `userId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `exitDate` date DEFAULT NULL,
  `facultyType` varchar(255) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `whetherActivated` tinyint(1) DEFAULT NULL,
  `whetherFaculty` tinyint(1) DEFAULT NULL,
  `yearsOfExperience` int(11) DEFAULT NULL,
  `departmentId` bigint(20) DEFAULT NULL,
  `designationId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `subDepartmentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`userId`,`REV`),
  KEY `FK7B3FE1E83304DC82` (`userId`,`REV`),
  CONSTRAINT `FK7B3FE1E83304DC82` FOREIGN KEY (`userId`, `REV`) REFERENCES `users_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `staffs_history` */

/*Table structure for table `stage_resource_plan_history` */

DROP TABLE IF EXISTS `stage_resource_plan_history`;

CREATE TABLE `stage_resource_plan_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `resourceCategoryType` varchar(10) DEFAULT NULL,
  `responsibility` varchar(15) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `timeFrom` varchar(10) DEFAULT NULL,
  `timeTo` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `processStageId` bigint(20) DEFAULT NULL,
  `resourceTypeId` bigint(20) DEFAULT NULL,
  `employeeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `stage_resource_plan_history` */

/*Table structure for table `standard_master_history` */

DROP TABLE IF EXISTS `standard_master_history`;

CREATE TABLE `standard_master_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `droolsAgenda` varchar(255) DEFAULT NULL,
  `masterName` varchar(255) DEFAULT NULL,
  `moduleName` varchar(255) DEFAULT NULL,
  `tableName` varchar(255) DEFAULT NULL,
  `whetherChild` tinyint(1) DEFAULT NULL,
  `whetherParent` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `childMaster` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `standard_master_history` */

/*Table structure for table `standard_master_items_history` */

DROP TABLE IF EXISTS `standard_master_items_history`;

CREATE TABLE `standard_master_items_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dbFieldName` varchar(255) DEFAULT NULL,
  `diaplayOrder` int(11) DEFAULT NULL,
  `emunType` varchar(50) DEFAULT NULL,
  `fieldLabel` varchar(255) DEFAULT NULL,
  `fieldType` varchar(50) DEFAULT NULL,
  `fkDisplayField` varchar(255) DEFAULT NULL,
  `fkFieldName` varchar(255) DEFAULT NULL,
  `fkTable` varchar(255) DEFAULT NULL,
  `wheherNullable` tinyint(1) DEFAULT NULL,
  `whetherForeignKey` tinyint(1) DEFAULT NULL,
  `whetherReadOnly` tinyint(1) DEFAULT NULL,
  `whetherShortCode` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `standardMasterId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `standard_master_items_history` */

/*Table structure for table `structure_leaf_node_history` */

DROP TABLE IF EXISTS `structure_leaf_node_history`;

CREATE TABLE `structure_leaf_node_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `instructionQuestionSubPart` varchar(255) DEFAULT NULL,
  `marks` double DEFAULT NULL,
  `negativeMarks` double DEFAULT NULL,
  `questionSubPartName` varchar(45) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `whetherCompulsory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `structureLevelThreeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `structure_leaf_node_history` */

/*Table structure for table `structure_level_one_history` */

DROP TABLE IF EXISTS `structure_level_one_history`;

CREATE TABLE `structure_level_one_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `instructionOptionGroup` varchar(255) DEFAULT NULL,
  `optionGroupMarks` double DEFAULT NULL,
  `optionGroupName` varchar(45) DEFAULT NULL,
  `totalMarksTobeanswered` double DEFAULT NULL,
  `totalQuestion` int(11) DEFAULT NULL,
  `totalQuestionTobeAnswered` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `structure_level_one_history` */

/*Table structure for table `structure_level_three_history` */

DROP TABLE IF EXISTS `structure_level_three_history`;

CREATE TABLE `structure_level_three_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `instructionQuestionPart` varchar(255) DEFAULT NULL,
  `marks` double DEFAULT NULL,
  `negativeMarks` double DEFAULT NULL,
  `questionPartName` varchar(45) DEFAULT NULL,
  `totalMarksTobeAnswered` double DEFAULT NULL,
  `totalQuestionSubPartTobeAnswered` int(11) DEFAULT NULL,
  `totalSubPart` int(11) DEFAULT NULL,
  `whetherCompulsory` varchar(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `structureLevelTwoId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `structure_level_three_history` */

/*Table structure for table `structure_level_two_history` */

DROP TABLE IF EXISTS `structure_level_two_history`;

CREATE TABLE `structure_level_two_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `complexity` varchar(45) DEFAULT NULL,
  `instructionQuestion` varchar(255) DEFAULT NULL,
  `marks` double DEFAULT NULL,
  `negativeMarks` double DEFAULT NULL,
  `questionNumber` varchar(45) DEFAULT NULL,
  `totalMarksTobeanswered` double DEFAULT NULL,
  `totalParts` int(11) DEFAULT NULL,
  `totalQuestionPartTobeAnswered` int(11) DEFAULT NULL,
  `whetherCompulsory` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `structureLevelOneId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `structure_level_two_history` */

/*Table structure for table `stu_account_receipts_history` */

DROP TABLE IF EXISTS `stu_account_receipts_history`;

CREATE TABLE `stu_account_receipts_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `accountDescription` varchar(255) DEFAULT NULL,
  `currencyBaseAmount` decimal(18,0) DEFAULT NULL,
  `debitCredit` char(1) DEFAULT NULL,
  `documentDate` date DEFAULT NULL,
  `documentNo` int(11) DEFAULT NULL,
  `instrumentAmt` decimal(18,0) DEFAULT NULL,
  `instrumentDate` date DEFAULT NULL,
  `instrumentDrawnOn` varchar(18) DEFAULT NULL,
  `instrumentNo` varchar(18) DEFAULT NULL,
  `narration` varchar(255) DEFAULT NULL,
  `ourBankAccount` varchar(20) DEFAULT NULL,
  `payMode` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `currencyBaseId` bigint(20) DEFAULT NULL,
  `currencyId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `stu_account_receipts_history` */

/*Table structure for table `student_account_history` */

DROP TABLE IF EXISTS `student_account_history`;

CREATE TABLE `student_account_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `individualControlAccountFlag` tinyint(1) DEFAULT NULL,
  `studentControlAccountPerm` varchar(10) DEFAULT NULL,
  `studentControlAccountTemp` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `accountConfigId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_account_history` */

/*Table structure for table `student_attendance_dashboard_section_wise_history` */

DROP TABLE IF EXISTS `student_attendance_dashboard_section_wise_history`;

CREATE TABLE `student_attendance_dashboard_section_wise_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `absentPercentage` int(11) DEFAULT NULL,
  `absentRecords` bigint(20) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `presentPercentage` int(11) DEFAULT NULL,
  `presentRecords` bigint(20) DEFAULT NULL,
  `totalRecords` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `componentId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_attendance_dashboard_section_wise_history` */

/*Table structure for table `student_attendance_dashboard_student_wise_history` */

DROP TABLE IF EXISTS `student_attendance_dashboard_student_wise_history`;

CREATE TABLE `student_attendance_dashboard_student_wise_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `absentPercentage` int(11) DEFAULT NULL,
  `absentRecords` bigint(20) DEFAULT NULL,
  `presentPercentage` int(11) DEFAULT NULL,
  `presentRecords` bigint(20) DEFAULT NULL,
  `totalRecords` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_attendance_dashboard_student_wise_history` */

/*Table structure for table `student_attendance_details_history` */

DROP TABLE IF EXISTS `student_attendance_details_history`;

CREATE TABLE `student_attendance_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `timeFrom` varchar(10) DEFAULT NULL,
  `timeTo` varchar(10) DEFAULT NULL,
  `whetherPresent` varchar(3) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `attendanceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_attendance_details_history` */

/*Table structure for table `student_attendance_history` */

DROP TABLE IF EXISTS `student_attendance_history`;

CREATE TABLE `student_attendance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceType` varchar(35) DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `whetherCompleteDay` tinyint(1) DEFAULT NULL,
  `whetherCourseSection` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_attendance_history` */

/*Table structure for table `student_cert_request_history` */

DROP TABLE IF EXISTS `student_cert_request_history`;

CREATE TABLE `student_cert_request_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `requestIsOrginal` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  `executionRequestId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `requestFollowUpId` bigint(20) DEFAULT NULL,
  `serviceRequestId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_cert_request_history` */

/*Table structure for table `student_course_attendance_details_history` */

DROP TABLE IF EXISTS `student_course_attendance_details_history`;

CREATE TABLE `student_course_attendance_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceStatus` varchar(25) DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `updatedAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `attendanceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_course_attendance_details_history` */

/*Table structure for table `student_course_attendance_history` */

DROP TABLE IF EXISTS `student_course_attendance_history`;

CREATE TABLE `student_course_attendance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `fromTime` datetime DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `updatedAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseComponentId` bigint(20) DEFAULT NULL,
  `variantId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_course_attendance_history` */

/*Table structure for table `student_course_enrollment_history` */

DROP TABLE IF EXISTS `student_course_enrollment_history`;

CREATE TABLE `student_course_enrollment_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enrollmentDate` datetime DEFAULT NULL,
  `exitDate` datetime DEFAULT NULL,
  `isCurrentSection` tinyint(1) DEFAULT NULL,
  `marksObtained` double DEFAULT NULL,
  `sectionType` varchar(19) DEFAULT NULL,
  `whetherAudit` tinyint(1) DEFAULT NULL,
  `whetherCourseExempted` tinyint(1) DEFAULT NULL,
  `whetherFailed` tinyint(1) DEFAULT NULL,
  `whetherOptional` tinyint(1) DEFAULT NULL,
  `whetherPassed` tinyint(1) DEFAULT NULL,
  `whetherRepeating` tinyint(1) DEFAULT NULL,
  `whetherSpecialized` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_course_enrollment_history` */

/*Table structure for table `student_distribution_list_cf_data_history` */

DROP TABLE IF EXISTS `student_distribution_list_cf_data_history`;

CREATE TABLE `student_distribution_list_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `distributionListId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_distribution_list_cf_data_history` */

/*Table structure for table `student_distribution_list_history` */

DROP TABLE IF EXISTS `student_distribution_list_history`;

CREATE TABLE `student_distribution_list_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `approveDate` datetime DEFAULT NULL,
  `approveFlag` tinyint(1) DEFAULT NULL,
  `approveReason` varchar(255) DEFAULT NULL,
  `consignmentRef` varchar(255) DEFAULT NULL,
  `receivedDate` datetime DEFAULT NULL,
  `recivingStatus` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `returnDate` datetime DEFAULT NULL,
  `sendingStatus` varchar(255) DEFAULT NULL,
  `sentDate` datetime DEFAULT NULL,
  `sentSequence` bigint(20) DEFAULT NULL,
  `serviceProvider` varchar(255) DEFAULT NULL,
  `whetherReturn` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  `distributionListId` bigint(20) DEFAULT NULL,
  `handoverTo` bigint(20) DEFAULT NULL,
  `senderId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_distribution_list_history` */

/*Table structure for table `student_documents_history` */

DROP TABLE IF EXISTS `student_documents_history`;

CREATE TABLE `student_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `documentTypeId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_documents_history` */

/*Table structure for table `student_exam_history` */

DROP TABLE IF EXISTS `student_exam_history`;

CREATE TABLE `student_exam_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `enrollmentNo` varchar(10) DEFAULT NULL,
  `examPassed` varchar(35) DEFAULT NULL,
  `examResult` varchar(8) DEFAULT NULL,
  `passingYear` date DEFAULT NULL,
  `studentType` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `conductedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_exam_history` */

/*Table structure for table `student_exam_subject_history` */

DROP TABLE IF EXISTS `student_exam_subject_history`;

CREATE TABLE `student_exam_subject_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marksGrades` varchar(10) DEFAULT NULL,
  `subjectsName` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `studentExamId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_exam_subject_history` */

/*Table structure for table `student_faculty_attendance_history` */

DROP TABLE IF EXISTS `student_faculty_attendance_history`;

CREATE TABLE `student_faculty_attendance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_faculty_attendance_history` */

/*Table structure for table `student_feedback_details_history` */

DROP TABLE IF EXISTS `student_feedback_details_history`;

CREATE TABLE `student_feedback_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `studentFeedbackId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_feedback_details_history` */

/*Table structure for table `student_feedback_history` */

DROP TABLE IF EXISTS `student_feedback_history`;

CREATE TABLE `student_feedback_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `completionDate` date DEFAULT NULL,
  `feedbackType` varchar(10) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `feedbackGivenBy` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `feedbackGivenTo` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_feedback_history` */

/*Table structure for table `student_pdc_history` */

DROP TABLE IF EXISTS `student_pdc_history`;

CREATE TABLE `student_pdc_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `drawnOn` varchar(100) DEFAULT NULL,
  `installmentNo` int(11) DEFAULT NULL,
  `pdcDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_pdc_history` */

/*Table structure for table `student_program_attendance_details_history` */

DROP TABLE IF EXISTS `student_program_attendance_details_history`;

CREATE TABLE `student_program_attendance_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceStatus` varchar(25) DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `updateAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `attendanceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_program_attendance_details_history` */

/*Table structure for table `student_program_attendance_history` */

DROP TABLE IF EXISTS `student_program_attendance_history`;

CREATE TABLE `student_program_attendance_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `attendanceType` varchar(20) DEFAULT NULL,
  `dateOfAttendance` date DEFAULT NULL,
  `fromTime` datetime DEFAULT NULL,
  `readByDashboard` tinyint(1) DEFAULT NULL,
  `toTime` datetime DEFAULT NULL,
  `updatedAfterRead` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_program_attendance_history` */

/*Table structure for table `student_promotions_history` */

DROP TABLE IF EXISTS `student_promotions_history`;

CREATE TABLE `student_promotions_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `reasonForPromoton` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `status` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_promotions_history` */

/*Table structure for table `student_revaluation_history` */

DROP TABLE IF EXISTS `student_revaluation_history`;

CREATE TABLE `student_revaluation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `revaluationDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `requestId` bigint(20) DEFAULT NULL,
  `employeeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_revaluation_history` */

/*Table structure for table `student_stakeholders_history` */

DROP TABLE IF EXISTS `student_stakeholders_history`;

CREATE TABLE `student_stakeholders_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `bloodGroup` varchar(8) DEFAULT NULL,
  `firstName` varchar(25) DEFAULT NULL,
  `gender` varchar(8) DEFAULT NULL,
  `lastName` varchar(25) DEFAULT NULL,
  `maritalStatus` char(1) DEFAULT NULL,
  `middleName` varchar(25) DEFAULT NULL,
  `occupation` varchar(18) DEFAULT NULL,
  `parentType` char(1) DEFAULT NULL,
  `relationship` varchar(18) DEFAULT NULL,
  `status` char(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `applicationId` bigint(20) DEFAULT NULL,
  `incomeId` bigint(20) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `employeeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_stakeholders_history` */

/*Table structure for table `student_trans_terminate_history` */

DROP TABLE IF EXISTS `student_trans_terminate_history`;

CREATE TABLE `student_trans_terminate_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `debarmentFrom` date DEFAULT NULL,
  `debarmentTo` date DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `studentRemark` varchar(255) DEFAULT NULL,
  `whetherDebarment` tinyint(1) DEFAULT NULL,
  `whetherTermination` tinyint(1) DEFAULT NULL,
  `whetherTransfer` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `executionRequestId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `requestFollowUpId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `initiatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `student_trans_terminate_history` */

/*Table structure for table `students_history` */

DROP TABLE IF EXISTS `students_history`;

CREATE TABLE `students_history` (
  `userId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `whetherAppliedForPlacement` tinyint(1) DEFAULT NULL,
  `whetherMidtermJoinee` tinyint(1) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`userId`,`REV`),
  KEY `FK84AE38ED3304DC82` (`userId`,`REV`),
  CONSTRAINT `FK84AE38ED3304DC82` FOREIGN KEY (`userId`, `REV`) REFERENCES `users_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `students_history` */

/*Table structure for table `subject_mark_info_history` */

DROP TABLE IF EXISTS `subject_mark_info_history`;

CREATE TABLE `subject_mark_info_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marks` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `educationHistoryId` bigint(20) DEFAULT NULL,
  `subjectId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `subject_mark_info_history` */

/*Table structure for table `subject_mark_to_be_changed_history` */

DROP TABLE IF EXISTS `subject_mark_to_be_changed_history`;

CREATE TABLE `subject_mark_to_be_changed_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marks` int(11) DEFAULT NULL,
  `subjectId` bigint(20) DEFAULT NULL,
  `subjectMarkInfoId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `dataToBeChangedId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `subject_mark_to_be_changed_history` */

/*Table structure for table `subjects_history` */

DROP TABLE IF EXISTS `subjects_history`;

CREATE TABLE `subjects_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `subjects_history` */

/*Table structure for table `supervisor_allocation_history` */

DROP TABLE IF EXISTS `supervisor_allocation_history`;

CREATE TABLE `supervisor_allocation_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `groupDateBatchCenterId` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `supervisor_allocation_history` */

/*Table structure for table `system_menu_history` */

DROP TABLE IF EXISTS `system_menu_history`;

CREATE TABLE `system_menu_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `displayCode` varchar(50) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  `iconCls` varchar(255) DEFAULT NULL,
  `launchView` varchar(255) DEFAULT NULL,
  `menuColorCls` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `featurePrivilegeId` bigint(20) DEFAULT NULL,
  `portalId` bigint(20) DEFAULT NULL,
  `parentMenuId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `system_menu_history` */

/*Table structure for table `system_modules_history` */

DROP TABLE IF EXISTS `system_modules_history`;

CREATE TABLE `system_modules_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `displayCode` varchar(20) DEFAULT NULL,
  `moduleDesc` varchar(35) DEFAULT NULL,
  `moduleName` varchar(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `portalId` bigint(20) DEFAULT NULL,
  `parentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `system_modules_history` */

/*Table structure for table `system_reports_history` */

DROP TABLE IF EXISTS `system_reports_history`;

CREATE TABLE `system_reports_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `moduleName` varchar(35) DEFAULT NULL,
  `reportName` varchar(35) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `system_reports_history` */

/*Table structure for table `temp_emp_leave_history` */

DROP TABLE IF EXISTS `temp_emp_leave_history`;

CREATE TABLE `temp_emp_leave_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `leaveDate` date DEFAULT NULL,
  `whetherOnLeave` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_emp_leave_history` */

/*Table structure for table `temp_terminations_history` */

DROP TABLE IF EXISTS `temp_terminations_history`;

CREATE TABLE `temp_terminations_history` (
  `completionId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `studentRemark` varchar(255) DEFAULT NULL,
  `tillDate` datetime DEFAULT NULL,
  `reasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`completionId`,`REV`),
  KEY `FK426189CFBE3F3224` (`completionId`,`REV`),
  CONSTRAINT `FK426189CFBE3F3224` FOREIGN KEY (`completionId`, `REV`) REFERENCES `completions_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `temp_terminations_history` */

/*Table structure for table `termination_reasons_history` */

DROP TABLE IF EXISTS `termination_reasons_history`;

CREATE TABLE `termination_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `termination_reasons_history` */

/*Table structure for table `termination_request_details_history` */

DROP TABLE IF EXISTS `termination_request_details_history`;

CREATE TABLE `termination_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `studentRemark` varchar(255) DEFAULT NULL,
  `terminationRemark` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `initiatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `terminationReasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `termination_request_details_history` */

/*Table structure for table `terminations_history` */

DROP TABLE IF EXISTS `terminations_history`;

CREATE TABLE `terminations_history` (
  `completionId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `studentRemark` varchar(255) DEFAULT NULL,
  `reasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`completionId`,`REV`),
  KEY `FKD17E4644BE3F3224` (`completionId`,`REV`),
  CONSTRAINT `FKD17E4644BE3F3224` FOREIGN KEY (`completionId`, `REV`) REFERENCES `completions_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `terminations_history` */

/*Table structure for table `topic_depth_history` */

DROP TABLE IF EXISTS `topic_depth_history`;

CREATE TABLE `topic_depth_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `depthType` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `topic_depth_history` */

/*Table structure for table `training_category_history` */

DROP TABLE IF EXISTS `training_category_history`;

CREATE TABLE `training_category_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `training_category_history` */

/*Table structure for table `transaction_type_certificates_history` */

DROP TABLE IF EXISTS `transaction_type_certificates_history`;

CREATE TABLE `transaction_type_certificates_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `certificateId` bigint(20) DEFAULT NULL,
  `transactionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `transaction_type_certificates_history` */

/*Table structure for table `transaction_type_checklists_history` */

DROP TABLE IF EXISTS `transaction_type_checklists_history`;

CREATE TABLE `transaction_type_checklists_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `checklistItemId` bigint(20) DEFAULT NULL,
  `transactionTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `transaction_type_checklists_history` */

/*Table structure for table `transaction_types_history` */

DROP TABLE IF EXISTS `transaction_types_history`;

CREATE TABLE `transaction_types_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `completionTransactionType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `transaction_types_history` */

/*Table structure for table `transfer_reasons_history` */

DROP TABLE IF EXISTS `transfer_reasons_history`;

CREATE TABLE `transfer_reasons_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `transfer_reasons_history` */

/*Table structure for table `transfer_request_details_history` */

DROP TABLE IF EXISTS `transfer_request_details_history`;

CREATE TABLE `transfer_request_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `transferReasonId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `transfer_request_details_history` */

/*Table structure for table `transfers_history` */

DROP TABLE IF EXISTS `transfers_history`;

CREATE TABLE `transfers_history` (
  `completionId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `tillDate` datetime DEFAULT NULL,
  `reasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`completionId`,`REV`),
  KEY `FK347D693DBE3F3224` (`completionId`,`REV`),
  CONSTRAINT `FK347D693DBE3F3224` FOREIGN KEY (`completionId`, `REV`) REFERENCES `completions_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `transfers_history` */

/*Table structure for table `user_acad_loc_program_courses_history` */

DROP TABLE IF EXISTS `user_acad_loc_program_courses_history`;

CREATE TABLE `user_acad_loc_program_courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `userAcadLocProgramId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_acad_loc_program_courses_history` */

/*Table structure for table `user_acad_loc_programs_history` */

DROP TABLE IF EXISTS `user_acad_loc_programs_history`;

CREATE TABLE `user_acad_loc_programs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `userAcademyLocationsId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_acad_loc_programs_history` */

/*Table structure for table `user_acad_loc_role_privileges_history` */

DROP TABLE IF EXISTS `user_acad_loc_role_privileges_history`;

CREATE TABLE `user_acad_loc_role_privileges_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `rolePrivilegeId` bigint(20) DEFAULT NULL,
  `userAcadLocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_acad_loc_role_privileges_history` */

/*Table structure for table `user_acad_loc_roles_history` */

DROP TABLE IF EXISTS `user_acad_loc_roles_history`;

CREATE TABLE `user_acad_loc_roles_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL,
  `userAcadLocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_acad_loc_roles_history` */

/*Table structure for table `user_academy_locations_history` */

DROP TABLE IF EXISTS `user_academy_locations_history`;

CREATE TABLE `user_academy_locations_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `programCoursePermissionType` varchar(255) DEFAULT NULL,
  `tillDate` date DEFAULT NULL,
  `whetherPrimary` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_academy_locations_history` */

/*Table structure for table `user_account_locked_history` */

DROP TABLE IF EXISTS `user_account_locked_history`;

CREATE TABLE `user_account_locked_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lockedDate` datetime DEFAULT NULL,
  `lockedReason` varchar(250) DEFAULT NULL,
  `releaseDate` datetime DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_account_locked_history` */

/*Table structure for table `user_cf_data_history` */

DROP TABLE IF EXISTS `user_cf_data_history`;

CREATE TABLE `user_cf_data_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_cf_data_history` */

/*Table structure for table `user_courses_history` */

DROP TABLE IF EXISTS `user_courses_history`;

CREATE TABLE `user_courses_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  `userProgramId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_courses_history` */

/*Table structure for table `user_groups_history` */

DROP TABLE IF EXISTS `user_groups_history`;

CREATE TABLE `user_groups_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `userGroupName` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_groups_history` */

/*Table structure for table `user_login_history_history` */

DROP TABLE IF EXISTS `user_login_history_history`;

CREATE TABLE `user_login_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `accessToken` varchar(255) DEFAULT NULL,
  `ipAddress` varchar(255) DEFAULT NULL,
  `loginTime` datetime DEFAULT NULL,
  `logoutTime` datetime DEFAULT NULL,
  `timeSpent` double DEFAULT NULL,
  `whetherLatest` tinyint(1) DEFAULT NULL,
  `whetherTimeout` tinyint(1) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_login_history_history` */

/*Table structure for table `user_password_history_history` */

DROP TABLE IF EXISTS `user_password_history_history`;

CREATE TABLE `user_password_history_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_password_history_history` */

/*Table structure for table `user_password_policy_history` */

DROP TABLE IF EXISTS `user_password_policy_history`;

CREATE TABLE `user_password_policy_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `maxLength` int(11) DEFAULT NULL,
  `maxPasswordAge` int(11) DEFAULT NULL,
  `minDigits` int(11) DEFAULT NULL,
  `minLength` int(11) DEFAULT NULL,
  `minSpecialCharacter` int(11) DEFAULT NULL,
  `unsuccessfulAttempts` int(11) DEFAULT NULL,
  `whetherPasswordExpires` tinyint(1) DEFAULT NULL,
  `whetherReusePassword` tinyint(1) DEFAULT NULL,
  `whetherReuseUsername` tinyint(1) DEFAULT NULL,
  `whetherTemporaryLock` tinyint(1) DEFAULT NULL,
  `whetherUnlockOnPasswordReset` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_password_policy_history` */

/*Table structure for table `user_privilege_overrides_history` */

DROP TABLE IF EXISTS `user_privilege_overrides_history`;

CREATE TABLE `user_privilege_overrides_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `granted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `featurePrivilegeId` bigint(20) DEFAULT NULL,
  `userAcademyLocationRoleId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_privilege_overrides_history` */

/*Table structure for table `user_programs_history` */

DROP TABLE IF EXISTS `user_programs_history`;

CREATE TABLE `user_programs_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `allCourses` int(11) DEFAULT NULL,
  `allPrograms` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `user_programs_history` */

/*Table structure for table `users_history` */

DROP TABLE IF EXISTS `users_history`;

CREATE TABLE `users_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `categoryField1` varchar(15) DEFAULT NULL,
  `categoryField2` varchar(15) DEFAULT NULL,
  `categoryField3` varchar(15) DEFAULT NULL,
  `categoryField4` varchar(15) DEFAULT NULL,
  `categoryField5` varchar(15) DEFAULT NULL,
  `code` varchar(20) DEFAULT NULL,
  `firstName` varchar(20) DEFAULT NULL,
  `ipAddress` varchar(30) DEFAULT NULL,
  `lastLockReleaseDate` datetime DEFAULT NULL,
  `lastName` varchar(20) DEFAULT NULL,
  `lockedOn` datetime DEFAULT NULL,
  `lockedReason` varchar(100) DEFAULT NULL,
  `lockedStatus` tinyint(1) DEFAULT NULL,
  `middleName` varchar(20) DEFAULT NULL,
  `noOfLoginFailed` int(11) DEFAULT NULL,
  `noOfTimesLocked` int(11) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `salt` varchar(100) DEFAULT NULL,
  `shortName` varchar(20) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `totalAutoLogout` bigint(20) DEFAULT NULL,
  `totalLoginFailed` bigint(20) DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `whetherInternal` tinyint(1) DEFAULT NULL,
  `whetherPasswordReset` tinyint(1) DEFAULT NULL,
  `whetherSystemUser` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `userGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `users_history` */

/*Table structure for table `users_system_usage_log_history` */

DROP TABLE IF EXISTS `users_system_usage_log_history`;

CREATE TABLE `users_system_usage_log_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `accessTime` datetime DEFAULT NULL,
  `featurePrivilegeId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `users_system_usage_log_history` */

/*Table structure for table `usertries_history` */

DROP TABLE IF EXISTS `usertries_history`;

CREATE TABLE `usertries_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `errorMessage` varchar(35) DEFAULT NULL,
  `userName` varchar(35) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `usertries_history` */

/*Table structure for table `vaccin_data_to_be_changed_history` */

DROP TABLE IF EXISTS `vaccin_data_to_be_changed_history`;

CREATE TABLE `vaccin_data_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `purpose` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `vaccinationInfoId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FK13AC6A6B7BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FK13AC6A6B7BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `vaccin_data_to_be_changed_history` */

/*Table structure for table `vaccination_info_history` */

DROP TABLE IF EXISTS `vaccination_info_history`;

CREATE TABLE `vaccination_info_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `purpose` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `vaccinationDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `vaccination_info_history` */

/*Table structure for table `work_data_to_be_changed_history` */

DROP TABLE IF EXISTS `work_data_to_be_changed_history`;

CREATE TABLE `work_data_to_be_changed_history` (
  `dataToBeChangedId` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `department` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `employer` varchar(255) DEFAULT NULL,
  `whetherFullTime` tinyint(1) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `workExperienceId` bigint(20) DEFAULT NULL,
  `workType` varchar(255) DEFAULT NULL,
  `experienceTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataToBeChangedId`,`REV`),
  KEY `FKC397316A7BEC668A` (`dataToBeChangedId`,`REV`),
  CONSTRAINT `FKC397316A7BEC668A` FOREIGN KEY (`dataToBeChangedId`, `REV`) REFERENCES `data_to_be_changed_history` (`id`, `REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `work_data_to_be_changed_history` */

/*Table structure for table `work_experience_history` */

DROP TABLE IF EXISTS `work_experience_history`;

CREATE TABLE `work_experience_history` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `designation` varchar(255) DEFAULT NULL,
  `duration` float DEFAULT NULL,
  `employer` varchar(255) DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `workType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `experienceTypeId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET FOREIGN_KEY_CHECKS=1;