CREATE TABLE `hostel_address_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `addressId` bigint(20) DEFAULT NULL,
  `hostelId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_available_history_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `roomStatus` varchar(45) DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roomId` bigint(20) DEFAULT NULL,
  `statusChnageReasonId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_bed_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `bedDeatails` longtext,
  `bedNumber` varchar(60) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `roomId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_building_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `cellCountryCode` varchar(10) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `closureDate` date DEFAULT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `remarks` longtext,
  `startDate` date DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `hostelId` bigint(20) DEFAULT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  `wardenId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_cancellation_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_checkout_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `hostelId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_floor_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `floorNumber` varchar(60) DEFAULT NULL,
  `remarks` longtext,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `buildinglId` bigint(20) DEFAULT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `cellCountryCode` varchar(10) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `closureDate` date DEFAULT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `leaseEndDate` date DEFAULT NULL,
  `ownership` varchar(20) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `remarks` longtext,
  `startDate` date DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `managerId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  `wardenId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_restriction_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `restrictionType` varchar(60) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `userGroupId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_room_allotment_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `allotmentDate` date DEFAULT NULL,
  `allotmentStatus` varchar(45) DEFAULT NULL,
  `cancelDate` date DEFAULT NULL,
  `cancelRemarks` longtext,
  `checkInDate` date DEFAULT NULL,
  `checkOutDate` date DEFAULT NULL,
  `expectedCheckOutDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `allotmentBy` bigint(20) DEFAULT NULL,
  `cancellationBy` bigint(20) DEFAULT NULL,
  `createdBy` bigint(20) DEFAULT NULL,
  `bedId` bigint(20) DEFAULT NULL,
  `cancelReasonId` bigint(20) DEFAULT NULL,
  `checkOutReasonId` bigint(20) DEFAULT NULL,
  `roomId` bigint(20) DEFAULT NULL,
  `keyHandoverBy` bigint(20) DEFAULT NULL,
  `keyHandoverTo` bigint(20) DEFAULT NULL,
  `keyReturnedTo` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_room_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `numberOfBeds` int(11) DEFAULT NULL,
  `remarks` longtext,
  `roomNumber` varchar(45) DEFAULT NULL,
  `roomStatus` varchar(45) DEFAULT NULL,
  `statusChnageDate` date DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `floorId` bigint(20) DEFAULT NULL,
  `restrictionTypeId` bigint(20) DEFAULT NULL,
  `roomTypeId` bigint(20) DEFAULT NULL,
  `statusChnageReasonId` bigint(20) DEFAULT NULL,
  `resourceId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_room_type_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `roomType` varchar(60) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hostel_status_change_reason_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `itemCode` varchar(255) DEFAULT NULL,
  `itemValue` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
