DROP TABLE IF EXISTS calendars_history;
DROP TABLE IF EXISTS calendar_special_days_history;
DROP TABLE IF EXISTS calendar_weekdays_history;
DROP TABLE IF EXISTS calendar_weeklyoffs_history;
DROP TABLE IF EXISTS calendar_holidays_history;
DROP TABLE IF EXISTS calendar_working_weekdays_history;
DROP TABLE IF EXISTS calendar_academy_locations_history;
DROP TABLE IF EXISTS calendar_breaks_history;

CREATE TABLE `calendars_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `code` varchar(10) NOT NULL,
  `calenderName` varchar(35) DEFAULT NULL,
  `calendarDesc` varchar(100) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `weekStart` varchar(10) DEFAULT NULL,
  `calendarInitSetupComplete` char(1) DEFAULT NULL,
  `calendarType` varchar(60) DEFAULT 'ACADEMIC',
  `isSessionBreakdown` bit(1) DEFAULT b'0',
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `dayWiseSchedule` bit(1) NOT NULL DEFAULT b'0',
  `dayPerCycle` int(11) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
  ) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;


CREATE TABLE `calendar_weekdays_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `weekDay` varchar(15) DEFAULT NULL,
  `startTime` datetime DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `slot` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) DEFAULT NULL,
  `isNightShift` bit(1) DEFAULT b'0',
  `lateComingAllowedTill` time DEFAULT NULL,
  `earlyGoingAllowedAfter` time DEFAULT NULL,
  `totalHours` time DEFAULT NULL,
  `minHoursOfFullDay` time DEFAULT NULL,
  `minHoursOfHalfDay` time DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB AUTO_INCREMENT=458 DEFAULT CHARSET=utf8;


CREATE TABLE `calendar_special_days_history` (
  `calendarWeekdayId` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `startDate` date NOT NULL,
  `tillDate` date DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `calendarId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`calendarWeekdayId`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `calendar_weeklyoffs_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `weekday` varchar(15) DEFAULT NULL,
  `calendarId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) DEFAULT NULL,
	PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB AUTO_INCREMENT=524 DEFAULT CHARSET=utf8;

CREATE TABLE `calendar_holidays_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `calendarId` bigint(20) DEFAULT NULL,
  `fromDate` date NOT NULL,
  `toDate` date DEFAULT NULL,
  `holidayReason` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;

CREATE TABLE `calendar_working_weekdays_history` (
  `calendarWeekdayId` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `calendarId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`calendarWeekdayId`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `calendar_academy_locations_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `calendarId` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=utf8;

CREATE TABLE `calendar_breaks_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `calendarWeekdayId` bigint(20) DEFAULT NULL,
  `breakName` varchar(15) DEFAULT NULL,
  `startTime` datetime DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8;






