DELIMITER $$

DROP PROCEDURE IF EXISTS application_followup_audit_create_proc $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE application_followup_audit_create_proc()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_followup_history' )) THEN
    
	CREATE TABLE `application_followup_history` (
	  `id` bigint(20) NOT NULL,
	  `REV` int(11) NOT NULL,
	  `REVTYPE` tinyint(4) DEFAULT NULL,
	  `userId` bigint(20) DEFAULT NULL,
	  `applicationId` bigint(20) DEFAULT NULL,
	  `assignTo` bigint(20) DEFAULT NULL,
	  `followUpNo` smallint(6) DEFAULT NULL,
	  `followUpDate` date DEFAULT NULL,
	  `actualFollowUpDate` date DEFAULT NULL,
	  `whetherDeleted` bit(1) DEFAULT NULL,
	  `remark` text DEFAULT NULL,
	  `lastUpdatedBy` bigint(20) DEFAULT NULL,
	  `lastUpdate` timestamp NULL DEFAULT NULL,
	  `isLatestFollowUp` bit(1) DEFAULT NULL,
	  `followupReason_id` bigint(20) DEFAULT NULL,
	  `followupActivityTypeId` bigint(20) DEFAULT NULL,
	  `followupActivityStatusId` bigint(20) DEFAULT NULL,
	  `followupTime` time DEFAULT NULL, 
	  `enqPriorityId` BIGINT(20) DEFAULT NULL,
	  `status` varchar(30) NULL DEFAULT NULL,
	  PRIMARY KEY (`id`,`REV`)
	);
	
  END IF ;

END $$

-- Execute the stored procedure
CALL application_followup_audit_create_proc $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS application_followup_audit_create_proc $$
 
DELIMITER ;