DELIMITER $$

DROP PROCEDURE IF EXISTS kohaUserCategoryMappingAudit $$


CREATE PROCEDURE kohaUserCategoryMappingAudit()

BEGIN
  
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='koha_user_category_mapping_history')) THEN
  
CREATE TABLE `koha_user_category_mapping_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `userType` varchar(255) NOT NULL,
  `categoryId` int(10) NOT NULL,
  `userId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;

 IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='koha_user_library_mapping_history')) THEN

CREATE TABLE `koha_user_library_mapping_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `userType` varchar(255) NOT NULL,
  `branchId` bigint(10) NOT NULL,
  `userId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


  END IF;

END $$

-- Execute the stored procedure
CALL kohaUserCategoryMappingAudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS kohaUserCategoryMappingAudit $$
 
DELIMITER ;