DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291737__AlterPaymentHeaderHistory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291737__AlterPaymentHeaderHistory()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='payment_header_history' 
  AND column_name='acadLocCurrencyAmount')) THEN
  
ALTER TABLE `payment_header_history` 
ADD COLUMN `acadLocCurrencyAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `cancellationDate`,
ADD COLUMN `orgCurrencyAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrencyAmount`,
ADD COLUMN `acadLocCurrencyConvertionId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrencyAmount`,
ADD COLUMN `orgCurrencyConvertionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConvertionId`,
ADD COLUMN `acadLocCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrencyConvertionId`,
ADD COLUMN `orgCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyId`;

  
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291737__AlterPaymentHeaderHistory $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291737__AlterPaymentHeaderHistory $$
 
DELIMITER ;