DELIMITER $$

DROP PROCEDURE IF EXISTS V20200519151305__AlterDataRequirement $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200519151305__AlterDataRequirement()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup_history' 
  AND column_name='exam_passed_id')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup_history` ADD COLUMN `exam_passed_id` BIGINT(20) NULL AFTER `applicant_portal_module_id`;
  
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup_history' 
  AND column_name='competitive_exam_id')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup_history` ADD COLUMN `competitive_exam_id` BIGINT(20) NULL AFTER `exam_passed_id`;

  
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup_history' 
  AND column_name='parent_guardian')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `data_requirement_setup_history` ADD COLUMN `parent_guardian` VARCHAR(50) NULL AFTER `competitive_exam_id`;
  
  END IF;
  
  IF EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='data_requirement_setup_history' 
  AND column_name='exam_pass')) THEN
  
    ALTER TABLE data_requirement_setup_history DROP exam_pass;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V20200519151305__AlterDataRequirement $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200519151305__AlterDataRequirement $$
 
DELIMITER ;