DELIMITER $$
DROP PROCEDURE IF EXISTS V20200828113625__Create_registration_setup_audit $$
CREATE PROCEDURE V20200828113625__Create_registration_setup_audit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_profile_update_history')) THEN 
CREATE TABLE `term_wise_profile_update_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `registrationTermSetupDetailId` bigint(20) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date NOT NULL,
  `isProfileUpdateApplicable` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_profile_link_history')) THEN 
CREATE TABLE `term_wise_profile_link_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `termWiseProfileUpdateId` bigint(20) NOT NULL,
  `sequenceNo` INT NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `linkName` varchar(225) NOT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_profile_link_history')) THEN 
ALTER TABLE `term_wise_profile_link_history` 
ADD COLUMN `isSelected` BIT(1) NOT NULL DEFAULT b'1' AFTER `sequenceNo`;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_registration_document_setup_history')) THEN 
CREATE TABLE `term_wise_registration_document_setup_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `registrationTermSetupDetailId` bigint(20) NOT NULL,
  `isDocumentApplicable` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_registration_document_history')) THEN 
CREATE TABLE `term_wise_registration_document_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `termWiseRegistrationDocumentSetupId` bigint(20) NOT NULL,
  `documentTypeId` bigint(20) NOT NULL,
  `isMandatory` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20200828113625__Create_registration_setup_audit () $$ 
DROP PROCEDURE IF EXISTS V20200828113625__Create_registration_setup_audit $$ 
DELIMITER ;