DELIMITER $$

DROP PROCEDURE IF EXISTS V20201221095710__Insert_ApplicantEligibilityDetailAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201221095710__Insert_ApplicantEligibilityDetailAudit()

BEGIN
  
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_eligibility_detail_history' )) THEN
  
  CREATE TABLE `applicant_eligibility_detail_history` (
		  `id` bigint(20) NOT NULL,
		  `REV` bigint(20) NOT NULL,
		  `REVTYPE` tinyint(4) DEFAULT NULL,
		`applicantPersonId` BIGINT NULL,
		  `achievementTypeId` BIGINT NULL,
		`achievementTypeOther` VARCHAR(100) NULL,
		`progEndorsedStatusId` BIGINT NULL,
		`additionalReqMet` BIT NULL,
		`heqsfLevelId` BIGINT NULL,
		`thirdYProgAvg` FLOAT NULL,
		`cognateSubAvg` FLOAT NULL,
		`honoursProgAvg` FLOAT NULL,
		`pgRequirementMet` BIT NULL,
		`pgMarks` BIT NULL,
		`honoursProgMastersAvg` FLOAT NULL,
		`mastersProgAvg` FLOAT NULL,
		`rpl` BIT NULL,
		`examNumber` BIGINT NULL,
		`examMonth` INT NULL,
		`examYear` INT NULL,
		`province` VARCHAR(10) NULL,
		`examBoard` VARCHAR(10) NULL,
		`centreNumber` BIGINT NULL,
		`centreName` VARCHAR(255) NULL,
		`attendanceMode` VARCHAR(45) NULL,
		`heAdmissionOriginal` VARCHAR(45) NULL,
		`heAdmissionCombined` VARCHAR(45) NULL,
		`numberOfSubject` INT NULL,
		`achievedNSC` BIT NULL,
		`eligibilityStatusId` BIGINT NULL,
		`comment` TEXT NULL,
		`lastUpdatedBy` BIGINT NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;

END $$

-- Execute the stored procedure
CALL V20201221095710__Insert_ApplicantEligibilityDetailAudit $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201221095710__Insert_ApplicantEligibilityDetailAudit $$
 
DELIMITER ;