DELIMITER $$
DROP PROCEDURE IF EXISTS syllabusplus_student_info $$
CREATE PROCEDURE syllabusplus_student_info()
BEGIN
SELECT 
RPAD(substring(concat(if(ps.externalSysRefOne is null,'',substring(ps.externalSysRefOne,1,8)),
ifnull(u.lastname,'')),1,27),27,' ') as ucode,
LPAD(' ',1,' ') as space1,
substring(ifnull(u.firstName,' '),1,1) as firstname, LPAD(' ',7,' ') as space2,
if(('afrikaans'=(select lower(code) from multi_language where id=ps.contact_language)),'09','01')
as contactlang, 
if((length(p.programCode)<8 || p.programCode is null) ,'000000',
concat(substring(p.programCode,2,3),substring(p.programCode,6,3))) as progcode, '1' as fixval,
RPAD(substring(ifnull(p.programNameToBePrintLanguageOne,' '),1,29),29,' ') as progname,
LPAD(' ',1,' ') as space3,
regexp_replace(group_concat( distinct substring(regexp_replace(trim(c.courseCode),'[-, ]',''),1,8)),'[-, ]','') as coursecode 
 from student_course_enrollment enroll 
inner join admission a on enroll.admissionId = a.id
inner join users u on a.studentId=u.id
inner join students st on u.id = st.userid
inner join persons ps on st.personid = ps.id
inner join prog_batch_period_config period on enroll.programBatchPeriodConfigId=period.id
inner join academic_term atrm on period.academicTermId=atrm.id
inner join batches b on period.programBatchId=b.id
inner join program_batch_period_cd pbpcd on period.id=pbpcd.progBatchPeriodConfigId 
inner join categories_info ci on pbpcd.cf11=ci.id
inner join custom_field_config cfc on ci.customFieldConfigId=cfc.id and ci.subCategoryName='Yes'
inner join custom_table_configs ctc on cfc.customTableConfigId = ctc.id and ctc.tablename='prog_batch_period_config'
inner join intake_year iy on b.intakeYearId=iy.id
inner join programs p on b.programid=p.id
inner join course_variants cv on enroll.courseVarientId=cv.id
INNER JOIN courses c on cv.courseId=c.id
WHERE period.programPeriodSeq in (1,2)
and enroll.exitDate is null
AND iy.itemvalue = (select value from drop_down where type="Syllabusplus_IntakeYear")
AND atrm.itemValue = (select value from drop_down where type="Syllabusplus_AcademicTerm")
group by u.code;
END $$
DELIMITER ;