CREATE TABLE `languages_supported` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `languageCode` varchar(5) NOT NULL,
  `languageName` varchar(255) NOT NULL,
  `status` bit(1) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `languages_supported_ibfk_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
INSERT INTO languages_supported values (1, "en", "English", 1, 1, CURRENT_TIMESTAMP);

ALTER TABLE courses 
CHANGE COLUMN courseName courseName VARCHAR(255) NOT NULL,
CHANGE COLUMN courseShortName courseShortName VARCHAR(255) NULL,
CHANGE COLUMN nameToBePrinted nameToBePrinted VARCHAR(255) NULL
;

ALTER TABLE programs
CHANGE COLUMN programCode programCode VARCHAR(255) NOT NULL,
CHANGE COLUMN programShortName programShortName VARCHAR(255) NULL
;

ALTER TABLE `form_field_helptext_lang_translation` 
DROP COLUMN `languageCode`;

ALTER TABLE `form_field_helptext_lang_translation` 
ADD COLUMN `languageId` BIGINT(20) NOT NULL AFTER `formFieldHelpText`;

UPDATE form_field_helptext_lang_translation set languageId = 1;

ALTER TABLE `form_field_helptext_lang_translation` 
ADD INDEX `fk_form_field_helptext_lang_translation_2_idx` (`languageId` ASC);
ALTER TABLE `form_field_helptext_lang_translation` 
ADD CONSTRAINT `fk_form_field_helptext_lang_translation_2`
  FOREIGN KEY (`languageId`)
  REFERENCES `languages_supported` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;