SET SQL_SAFE_UPDATES = 0;

ALTER TABLE `id_definition` DROP COLUMN `lastUpdate`, ADD COLUMN `lastUpdate` TIMESTAMP NOT NULL AFTER `lastUpdatedBy`;
ALTER TABLE `id_format` DROP COLUMN `lastUpdate`, ADD COLUMN `lastUpdate` TIMESTAMP NOT NULL AFTER `lastUpdatedBy`;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
UPDATE `id_definition` SET lastUpdate=@currentTimeStamp where id <> 0;
UPDATE `id_format` SET lastUpdate=@currentTimeStamp where id <> 0;

/**Delete existing id generation configuration for application*/

DELETE FROM id_column_available WHERE tableName='application123' AND columnName='code';

DELETE FROM id_format_alphanumeric WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application123')));

DELETE FROM id_format_counter_mapping WHERE idDefinition IN (
SELECT id FROM id_definition WHERE idEntitySettingId IN (SELECT id FROM id_entity_setting WHERE tableName='application123'));

DELETE FROM `id_format_dynamic` WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application123')));

DELETE FROM `id_format_running_no` WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application123')));


DELETE FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application123'));

DELETE FROM id_definition WHERE idEntitySettingId IN (SELECT id FROM id_entity_setting WHERE tableName='application123');

DELETE FROM id_entity_setting WHERE tableName='application123';

/**Delete existing id generation configuration for application*/

DELETE FROM id_column_available WHERE tableName='application' AND columnName='code';

DELETE FROM id_format_alphanumeric WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application')));

DELETE FROM id_format_counter_mapping WHERE idDefinition IN (
SELECT id FROM id_definition WHERE idEntitySettingId IN (SELECT id FROM id_entity_setting WHERE tableName='application'));

DELETE FROM `id_format_dynamic` WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application')));

DELETE FROM `id_format_running_no` WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application')));

DELETE FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='application'));

DELETE FROM id_definition WHERE idEntitySettingId IN (SELECT id FROM id_entity_setting WHERE tableName='application');
DELETE FROM id_entity_setting WHERE tableName='application';

/** admission123*/

DELETE FROM id_column_available WHERE tableName='admission123' AND columnName='code';

DELETE FROM id_format_alphanumeric WHERE id IN(
SELECT id FROM id_format WHERE idDefinitionId IN (SELECT id FROM id_definition WHERE idEntitySettingId IN 
(SELECT id FROM id_entity_setting WHERE tableName='admission123')));

DELETE FROM id_format_counter_mapping WHERE idDefinition IN (
SELECT id FROM id_definition WHERE idEntitySettingId IN (SELECT id FROM id_entity_setting WHERE tableName='admission123'));

/*id format for application*/

INSERT INTO id_column_available (tableName, columnName) VALUES('application','code');
INSERT INTO id_entity_setting ( tableName,idGenerationTable, whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) VALUES('application','application','\0','\0',NULL,1,@currentTimeStamp);
  
SET @idEntitySettingId=(SELECT MAX(id) FROM id_entity_setting);
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','code',0,0,1,@currentTimeStamp,0);

SET @idDefinitionId=(SELECT MAX(id) FROM id_definition);
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);

SET @idFormat=(SELECT MAX(id) FROM id_format);
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'APPL','',1);


SET SQL_SAFE_UPDATES = 1;
