ALTER TABLE `evaluation_program_rank` 
DROP FOREIGN KEY `fk_programBatchPeriodId_4`;
ALTER TABLE `evaluation_program_rank` 
DROP COLUMN `programBatchPeriodId`,
DROP INDEX `fk_programBatchPeriodId_4_idx` ;

ALTER TABLE `evaluation_program_rank` 
ADD COLUMN `batchId` BIGINT(20) NULL AFTER `stage`,
ADD COLUMN `programName` VARCHAR(255) NULL AFTER `batchId`;

ALTER TABLE `evaluation_program_rank` 
ADD INDEX `fk_evaluation_program_rank_1_idx` (`batchId` ASC);
ALTER TABLE `evaluation_program_rank` 
ADD CONSTRAINT `fk_evaluation_program_rank_1`
  FOREIGN KEY (`batchId`)
  REFERENCES `batches` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

CREATE TABLE `evaluation_period_rank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `periodId` BIGINT(20) NULL,
  `admissionId` BIGINT(20) NULL,
  `rank` INT NULL,
  `sgpa` DOUBLE NULL,
  `obtainedMarks` DOUBLE NULL,
  `status` VARCHAR(45) NULL,
  `stage` VARCHAR(45) NULL,
  `evaluationPlanType` VARCHAR(255) NULL,
  `marksObtainedFrom` BIGINT(20) NULL,
  `hallticket` VARCHAR(255) NULL,
  `sectionName` VARCHAR(255) NULL,
  `periodName` VARCHAR(255) NULL,
  `batchName` VARCHAR(255) NULL,
  `programName` VARCHAR(255) NULL,
  PRIMARY KEY (`id`));

ALTER TABLE `evaluation_period_rank` 
ADD INDEX `fk_evaluation_period_rank_1_idx` (`periodId` ASC);
ALTER TABLE `evaluation_period_rank` 
ADD CONSTRAINT `fk_evaluation_period_rank_1`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `evaluation_period_rank` 
ADD INDEX `fk_evaluation_period_rank_2_idx` (`admissionId` ASC);
ALTER TABLE `evaluation_period_rank` 
ADD CONSTRAINT `fk_evaluation_period_rank_2`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `evaluation_period_rank` 
ADD COLUMN `lastUpdatedBy` BIGINT(20) NULL AFTER `programName`,
ADD COLUMN `lastUpdate` TIMESTAMP NULL AFTER `lastUpdatedBy`;

ALTER TABLE `evaluation_period_rank` 
ADD INDEX `fk_evaluation_period_rank_3_idx` (`lastUpdatedBy` ASC);
ALTER TABLE `evaluation_period_rank` 
ADD CONSTRAINT `fk_evaluation_period_rank_3`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `evaluation_program_rank` 
DROP COLUMN `periodName`;

ALTER TABLE `evaluation_period_rank` 
ADD COLUMN `creditSum` BIGINT(10) NULL AFTER `lastUpdate`,
ADD COLUMN `creditGradePointSum` DOUBLE NULL AFTER `creditSum`;

ALTER TABLE `evaluation_program_rank` 
ADD COLUMN `creditSum` BIGINT NULL AFTER `programName`,
ADD COLUMN `creditGradePointSum` DOUBLE NULL AFTER `creditSum`;