
CREATE 
   OR REPLACE
VIEW `fee_dashboard_payment_statistics_all_payment` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`
    from
        (((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON ((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`fee_plan_acad_locations`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
            and (`bill_header`.`userId` is not null));

CREATE 
   OR REPLACE
VIEW `fee_dashboard_payment_statistics_payment_made` AS
    select 
        `fee_adjustment_details`.`adjustedAmount` AS `adjustedAmount`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `payment_header`.`currencyId` AS `currencyId`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `payment_header`.`transactionDate` AS `transactionDate`
    from
        ((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON ((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`fee_plan_acad_locations`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)));

CREATE 
    OR REPLACE
VIEW `fee_dashboard_payment_statistics_pending_payment` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`
    from
        (((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON ((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`fee_plan_acad_locations`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
            and (`bill_header`.`userId` is not null)
            and (`bill_fee_plan_rule_stage`.`balanceAmount` > 0));