DROP VIEW IF EXISTS `pnc_dashboard_least_popular_courses`;

CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_least_popular_courses` AS
    SELECT 
        CONCAT(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `prog_batch_period_config`.`programBatchId` AS `programBatchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `courses`.`id` AS `courseId`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        (SELECT 
                COUNT(0)
            FROM
                ((`prog_batch_course_details` `pbcd`
                LEFT JOIN `course_variants` `cv` ON ((`pbcd`.`courseVarientId` = `cv`.`id`)))
                LEFT JOIN `courses` `c` ON ((`cv`.`courseId` = `c`.`id`)))
            WHERE
                ((`pbcd`.`whetherRequirementReceived` = 1)
                    AND (`pbcd`.`whetherOptional` = 1)
                    AND (`c`.`assignSectionType` = 'CourseSection')
                    AND (`cv`.`id` = `course_variants`.`id`)
                    AND (`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`))) AS `Applied`,
        (SELECT 
                COUNT(0)
            FROM
                ((`prog_batch_course_details` `pbcd`
                LEFT JOIN `course_variants` `cv` ON ((`pbcd`.`courseVarientId` = `cv`.`id`)))
                LEFT JOIN `courses` `c` ON ((`cv`.`courseId` = `c`.`id`)))
            WHERE
                ((`pbcd`.`whetherRequirementReceived` = 1)
                    AND (`pbcd`.`whetherOptional` = 1)
                    AND (`c`.`assignSectionType` = 'CourseSection')
                    AND (`cv`.`id` = `course_variants`.`id`)
                    AND (`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`))) AS `Enrolled`,
        (SELECT 
                SUM(`sections`.`maxCapacity`)
            FROM
                `sections`
            WHERE
                `sections`.`id` IN (SELECT 
                        `sections`.`id`
                    FROM
                        `sections`
                    WHERE
                        `sections`.`courseVariantId` IN (SELECT 
                                `course_variants`.`id`
                            FROM
                                `course_variants`
                            WHERE
                                (`course_variants`.`courseId` = `courses`.`id`)))) AS `capacity`
    FROM
        ((((((((`prog_batch_course_details` `pbcd`
        LEFT JOIN `prog_batch_period_config` ON ((`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `course_variants` ON ((`pbcd`.`courseVarientId` = `course_variants`.`id`)))
        LEFT JOIN `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        LEFT JOIN `sections` ON ((`pbcd`.`sectionId` = `sections`.`id`)))
        LEFT JOIN `course_academy_location` ON ((`course_academy_location`.`courseId` = `courses`.`id`)))
        LEFT JOIN `academy_location` ON ((`academy_location`.`id` = `course_academy_location`.`academyLocationId`)))
    WHERE
        ((`pbcd`.`whetherOptional` = 1)
            AND (`courses`.`assignSectionType` = 'CourseSection'))
    GROUP BY `courses`.`id` , `prog_batch_period_config`.`id` 
    UNION SELECT 
        CONCAT(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `prog_batch_period_config`.`programBatchId` AS `programBatchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `courses`.`id` AS `courseId`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        COUNT((CASE
            WHEN (`pbcd`.`whetherRequirementReceived` = 1) THEN `pbcd`.`whetherRequirementReceived`
        END)) AS `Applied`,
        COUNT((CASE
            WHEN (`pbcd`.`whetherEnrolled` = 1) THEN `pbcd`.`whetherEnrolled`
        END)) AS `Enrolled`,
        (SELECT 
                SUM(`sections`.`maxCapacity`)
            FROM
                `sections`
            WHERE
                `sections`.`id` IN (SELECT 
                        `sections`.`id`
                    FROM
                        `sections`
                    WHERE
                        (`sections`.`periodId` = `pbcd`.`programBatchPeriodConfigId`))) AS `capacity`
    FROM
        (((((((`prog_batch_course_details` `pbcd`
        LEFT JOIN `prog_batch_period_config` ON ((`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `course_variants` ON ((`pbcd`.`courseVarientId` = `course_variants`.`id`)))
        LEFT JOIN `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        LEFT JOIN `sections` ON ((`pbcd`.`sectionId` = `sections`.`id`)))
        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
    WHERE
        ((`pbcd`.`whetherOptional` = 1)
            AND (`courses`.`assignSectionType` = 'ProgramBatchSection'))
    GROUP BY `prog_batch_period_config`.`id`
    ORDER BY `Applied`;
    

DROP VIEW IF EXISTS `pnc_dashboard_most_popular_courses`;

CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_most_popular_courses` AS
    SELECT 
        CONCAT(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `prog_batch_period_config`.`programBatchId` AS `programBatchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `courses`.`id` AS `courseId`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        (SELECT 
                COUNT(0)
            FROM
                ((`prog_batch_course_details` `pbcd`
                LEFT JOIN `course_variants` `cv` ON ((`pbcd`.`courseVarientId` = `cv`.`id`)))
                LEFT JOIN `courses` `c` ON ((`cv`.`courseId` = `c`.`id`)))
            WHERE
                ((`pbcd`.`whetherRequirementReceived` = 1)
                    AND (`pbcd`.`whetherOptional` = 1)
                    AND (`c`.`assignSectionType` = 'CourseSection')
                    AND (`cv`.`id` = `course_variants`.`id`)
                    AND (`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`))) AS `Applied`,
        (SELECT 
                COUNT(0)
            FROM
                ((`prog_batch_course_details` `pbcd`
                LEFT JOIN `course_variants` `cv` ON ((`pbcd`.`courseVarientId` = `cv`.`id`)))
                LEFT JOIN `courses` `c` ON ((`cv`.`courseId` = `c`.`id`)))
            WHERE
                ((`pbcd`.`whetherRequirementReceived` = 1)
                    AND (`pbcd`.`whetherOptional` = 1)
                    AND (`c`.`assignSectionType` = 'CourseSection')
                    AND (`cv`.`id` = `course_variants`.`id`)
                    AND (`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`))) AS `Enrolled`,
        (SELECT 
                SUM(`sections`.`maxCapacity`)
            FROM
                `sections`
            WHERE
                `sections`.`id` IN (SELECT 
                        `sections`.`id`
                    FROM
                        `sections`
                    WHERE
                        `sections`.`courseVariantId` IN (SELECT 
                                `course_variants`.`id`
                            FROM
                                `course_variants`
                            WHERE
                                (`course_variants`.`courseId` = `courses`.`id`)))) AS `capacity`
    FROM
        ((((((((`prog_batch_course_details` `pbcd`
        LEFT JOIN `prog_batch_period_config` ON ((`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `course_variants` ON ((`pbcd`.`courseVarientId` = `course_variants`.`id`)))
        LEFT JOIN `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        LEFT JOIN `sections` ON ((`pbcd`.`sectionId` = `sections`.`id`)))
        LEFT JOIN `course_academy_location` ON ((`course_academy_location`.`courseId` = `courses`.`id`)))
        LEFT JOIN `academy_location` ON ((`academy_location`.`id` = `course_academy_location`.`academyLocationId`)))
    WHERE
        ((`pbcd`.`whetherOptional` = 1)
            AND (`courses`.`assignSectionType` = 'CourseSection'))
    GROUP BY `courses`.`id` , `prog_batch_period_config`.`id` 
    UNION SELECT 
        CONCAT(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `prog_batch_period_config`.`programBatchId` AS `programBatchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `courses`.`id` AS `courseId`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        COUNT((CASE
            WHEN (`pbcd`.`whetherRequirementReceived` = 1) THEN `pbcd`.`whetherRequirementReceived`
        END)) AS `Applied`,
        COUNT((CASE
            WHEN (`pbcd`.`whetherEnrolled` = 1) THEN `pbcd`.`whetherEnrolled`
        END)) AS `Enrolled`,
        (SELECT 
                SUM(`sections`.`maxCapacity`)
            FROM
                `sections`
            WHERE
                `sections`.`id` IN (SELECT 
                        `sections`.`id`
                    FROM
                        `sections`
                    WHERE
                        (`sections`.`periodId` = `pbcd`.`programBatchPeriodConfigId`))) AS `capacity`
    FROM
        (((((((`prog_batch_course_details` `pbcd`
        LEFT JOIN `prog_batch_period_config` ON ((`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `course_variants` ON ((`pbcd`.`courseVarientId` = `course_variants`.`id`)))
        LEFT JOIN `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        LEFT JOIN `sections` ON ((`pbcd`.`sectionId` = `sections`.`id`)))
        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
    WHERE
        ((`pbcd`.`whetherOptional` = 1)
            AND (`courses`.`assignSectionType` = 'ProgramBatchSection'))
    GROUP BY `prog_batch_period_config`.`id`
    ORDER BY `Applied` DESC;