
CREATE TABLE `course_remark` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT(20) NULL DEFAULT NULL,
  `examinationRemarkId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_course_remark_course_id_idx` (`courseId` ASC),
  INDEX `fk_course_remark_examination_remark_id_idx` (`examinationRemarkId` ASC),
  INDEX `fk_course_remark_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_course_remark_course_id`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_remark_examination_remark_id`
    FOREIGN KEY (`examinationRemarkId`)
    REFERENCES `examination_remark` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_remark_lastUpdatedBy_user_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);


set sql_safe_updates=0;    

UPDATE `standard_master` SET `whetherParent`=1 WHERE `tableName`='examination_remark';

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1,'course_remark', 'COURSE_REMARK', 'Examinations', 1, 0, '1',@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items` (`id`,`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'course', 'COURSE', @standardMasterMaxId+1, 'Varchar', '1', 1, 'courses', 'id', 'nameToBePrinted', 0, 0, 0, '1',@currentTimeStamp);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
UPDATE `standard_master` SET `childMaster`=@standardMasterMaxId WHERE `tableName`='examination_remark';

set sql_safe_updates=1;




-- For vehicle sub type table


create table trans_vehicle_sub_type
select * from trans_vehicle_Sub_Type;

ALTER TABLE `resources`
DROP FOREIGN KEY `fk_resources_1`;
drop table trans_vehicle_Sub_Type;

CREATE TABLE `trans_vehicle_sub_type_torename` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `lastUpdate` datetime NOT NULL,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`),
  KEY `fk_vehicle_Sub_Type_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_vehicle_Sub_Type_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

insert into trans_vehicle_sub_type_torename
select * from trans_vehicle_sub_type;

drop table trans_vehicle_sub_type;
alter table trans_vehicle_sub_type_torename rename to trans_vehicle_sub_type;

ALTER TABLE `resources`
ADD CONSTRAINT `fk_resources_1`
  FOREIGN KEY (vehicleSubTypeId)
  REFERENCES `trans_vehicle_sub_type` (id)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


