-- identity_type table
CREATE TABLE `identity_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_identity_type_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_identity_type_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- identity_detail table
CREATE TABLE `identity_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `idType` bigint(20) NOT NULL,
  `idNumber` varchar(100) NOT NULL,
  `issuingAuthority` varchar(150) DEFAULT NULL,
  `issuedPlace` varchar(200) DEFAULT NULL,
  `issuedDate` date DEFAULT NULL,
  `validTillDate` date DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_identity_detail_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `fk_identity_detail_applicantPersonId` (`applicantPersonId`),
  KEY `fk_identity_detail_personId` (`personId`),
  KEY `fk_identity_detail_idType` (`idType`),
  CONSTRAINT `fk_identity_detail_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT `fk_identity_detail_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
  CONSTRAINT `fk_identity_detail_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)  ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_identity_detail_idType` FOREIGN KEY (`idType`) REFERENCES `identity_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- identity_detail_document table
CREATE TABLE `identity_detail_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `identityDetailId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_identity_detail_document_documentId` (`documentId`),
  KEY `fk_identity_detail_document_identityDetailId` (`identityDetailId`),
  KEY `fk_identity_detail_document_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_identity_detail_document_documentId` FOREIGN KEY (`identityDetailId`) REFERENCES `identity_detail` (`id`),
  CONSTRAINT `fk_identity_detail_document_identityDetailId` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
  CONSTRAINT `fk_identity_detail_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)  ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
