-- Event Calendar
CREATE TABLE `event_calendar` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `calendarName` varchar(150) NOT NULL,
  `calendarDesc` TEXT NULL DEFAULT NULL,
  `validFrom` datetime NULL DEFAULT NULL,
  `validTo` datetime NULL DEFAULT NULL,
  `status` varchar(15) NOT NULL,
  `displayToStudent` bit(1) DEFAULT b'0',
  `displayToEmployee` bit(1) DEFAULT b'0',
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_event_calendar_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_event_calendar_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- Alter Resourse booking table
ALTER TABLE `resource_bookings` 
ADD COLUMN `eventCalendarId` BIGINT(20) NULL DEFAULT NULL AFTER `whetherDeleted`,
ADD INDEX `fk_resource_bookings_eventCalendarId_idx` (`eventCalendarId` ASC);

ALTER TABLE `resource_bookings` 
ADD CONSTRAINT `fk_resource_bookings_eventCalendarId` FOREIGN KEY (`eventCalendarId`) REFERENCES `event_calendar` (`id`);
