CREATE TABLE IF NOT EXISTS `section_group_course_variant` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sectionGroupId` bigint(20) NOT NULL,
  `courseVariantId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_section_group_course_variant_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `fk_section_group_course_variant_sectionGroupId` (`sectionGroupId`),
  KEY `fk_section_group_course_variant_courseVariantId` (`courseVariantId`),
  CONSTRAINT `fk_section_group_course_variant_sectionGroupId` FOREIGN KEY (`sectionGroupId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_section_group_course_variant_courseVariantId` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `fk_section_group_course_variant_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `section_group_period` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sectionGroupId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_section_group_period_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `fk_section_group_period_sectionGroupId` (`sectionGroupId`),
  KEY `fk_section_group_period_periodId` (`periodId`),
  CONSTRAINT `fk_section_group_period_sectionGroupId` FOREIGN KEY (`sectionGroupId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_section_group_period_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_section_group_period_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET FOREIGN_KEY_CHECKS=0;
ALTER TABLE `sections` 
ADD COLUMN  `whetherSectionGroup` bit(1) NULL DEFAULT b'0' AFTER `succedingSectionId`;
SET FOREIGN_KEY_CHECKS=1;
