CREATE TABLE `staff_calendar` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `staffId` bigint(20) DEFAULT NULL,
  `calendarId` bigint(20) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `status` bit(1) DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_staff_calendar_staffId_idx` (`staffId`),
  KEY `fk_staff_calendar_calendarId_idx` (`calendarId`),
  KEY `fk_staff_calendar_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_staff_calendar_calendarId` FOREIGN KEY (`calendarId`) REFERENCES `calendars` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_staff_calendar_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_staff_calendar_staffId` FOREIGN KEY (`staffId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;