CREATE TABLE `fee_payer_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `payerType` varchar(15) DEFAULT NULL,
  `salutationId` bigint(20) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `doesFeePayerConsentToCreditCheck` bit(1) DEFAULT NULL,
  `homeTelephoneCountryCode` varchar(10) DEFAULT NULL,
  `homeTelephone` varchar(20) DEFAULT NULL,
  `workTelephoneCountryCode` varchar(10) DEFAULT NULL,
  `workTelephone` varchar(45) DEFAULT NULL,
  `countryCode` varchar(10) DEFAULT NULL,
  `mobileNumber` varchar(20) DEFAULT NULL,
  `emailHome` varchar(100) DEFAULT NULL,
  `emailHomeUseForCommunication` bit(1) DEFAULT NULL,
  `emailWork` varchar(100) DEFAULT NULL,
  `emailWorkUseForCommunication` bit(1) DEFAULT NULL,
  `feePayerID` bigint(20) DEFAULT NULL,
  `feePayerLatestPayslip` bigint(20) DEFAULT NULL,
  `companyName` varchar(255) DEFAULT NULL,
  `contactPerson` varchar(255) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_fee_payer_detail_applicantPersonId_idx` (`applicantPersonId`),
  KEY `fk_fee_payer_detail_salutationId_idx` (`salutationId`),
  KEY `fk_fee_payer_detail_feePayerID_idx` (`feePayerID`),
  KEY `fk_fee_payer_detail_feePayerLatestPayslip_idx` (`feePayerLatestPayslip`),
  KEY `fk_fee_payer_detail_lastUpdateBy_idx` (`lastUpdatedBy`),
  KEY `fk_fee_payer_detail_personId_idx` (`personId`),
  CONSTRAINT `fk_fee_payer_detail_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_fee_payer_detail_feePayerID` FOREIGN KEY (`feePayerID`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_fee_payer_detail_feePayerLatestPayslip` FOREIGN KEY (`feePayerLatestPayslip`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_fee_payer_detail_lastUpdateBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_fee_payer_detail_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_fee_payer_detail_salutationId` FOREIGN KEY (`salutationId`) REFERENCES `salutations` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
