CREATE TABLE `manage_target` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `programGroupId` bigint(20) DEFAULT NULL,
  `intakeYearId` bigint(20) DEFAULT NULL,
  `programId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `enquiryTarget` int(5) DEFAULT NULL,
  `applicationTarget` int(5) DEFAULT NULL,
  `enrolmentTarget` int(5) DEFAULT NULL,
  `buildingCapacity` int(5) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_manage_target_academyLocationId_idx` (`academyLocationId`),
  KEY `fk_manage_target_programGroupId_idx` (`programGroupId`),
  KEY `fk_manage_target_intakeYearId_idx` (`intakeYearId`),
  KEY `fk_manage_target_programId_idx` (`programId`),
  KEY `fk_manage_target_batchId_idx` (`batchId`),
  KEY `fk_manage_target_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_manage_target_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_intakeYearId` FOREIGN KEY (`intakeYearId`) REFERENCES `intake_year` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_programGroupId` FOREIGN KEY (`programGroupId`) REFERENCES `program_group` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_programId` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;