
DELIMITER //

CREATE TRIGGER document_types_after_insert
AFTER INSERT
   ON document_types FOR EACH ROW
BEGIN
      -- Insert record into other table
INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('General',NEW.itemValue, 'Documents', 'APPLICANT', NEW.id,
   'select T3.path AS value from document_types T1 
LEFT JOIN application_required_documents T2 ON T1.id = T2.documentTypeId 
LEFT JOIN documents T3 ON T3.id = T2.documentId LEFT JOIN application T4 ON T4.id = T2.applicationId
LEFT JOIN applicant_person T5 ON T5.id = T4.applicantPersonId  where T4.applicantPersonId = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('General',NEW.itemValue, 'Documents', 'EMPLOYEE', NEW.id,
   'select T3.path AS value from document_types T1 
LEFT JOIN faculty_documents T2 ON T1.id = T2.documentTypeId 
LEFT JOIN documents T3 ON T3.id = T2.documentId LEFT JOIN users T4 ON T4.id = T2.facultyId
LEFT JOIN staffs T5 ON T5.userId = T4.id  where T5.personId = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('General',NEW.itemValue, 'Documents', 'STUDENT', NEW.id,
   'select T3.path AS value from document_types T1 
LEFT JOIN student_documents T2 ON T1.id = T2.documentTypeId 
LEFT JOIN documents T3 ON T3.id = T2.documentId
LEFT JOIN users T4 ON T4.id = T2.studentId
LEFT JOIN students T5 ON T5.userId = T4.id
 where T5.personId = $param1',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER document_types_after_update
AFTER UPDATE
   ON document_types FOR EACH ROW
BEGIN
   UPDATE bulk_document_group SET documentName = NEW.itemValue, lastUpdate = NEW.lastUpdate,
   lastUpdatedBy = NEW.lastUpdatedBy WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER document_types_after_delete
AFTER DELETE
   ON document_types FOR EACH ROW
BEGIN
   DELETE FROM bulk_document_group WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ; 