CREATE 
	 OR REPLACE VIEW `student_publish_data` AS
	SELECT 
		FUNC_INC_VAR_SESSION() AS `Id`,
		`eval_group_hall_ticket`.`admissionId` AS `admissionId`,
		`admission`.`studentId` AS `studentId`,
		`eval_group_hall_ticket`.`reportType` AS `reportType`,
		`eval_group_hall_ticket`.`hallTicketPath` AS `documentPath`,
		`eval_group_hall_ticket`.`hallTicketNumber` AS `documentName`,
		DATE_FORMAT(`eval_group_hall_ticket`.`lastUpdate`,
				'%Y-%m-%d') AS `publishDate`
	FROM
		(`eval_group_hall_ticket`
		LEFT JOIN `admission` ON ((`eval_group_hall_ticket`.`admissionId` = `admission`.`id`)))
	WHERE
		((`eval_group_hall_ticket`.`isPublishHallTicket` = 1)
			AND (`eval_group_hall_ticket`.`reportType` = 'HALL_TICKET')) 
	UNION SELECT 
		FUNC_INC_VAR_SESSION() AS `Id`,
		`marksheet_job_details`.`admissionId` AS `admissionId`,
		`admission`.`studentId` AS `studentId`,
		'MARKSHEET' AS `reportType`,
		`marksheet_job_details`.`marksheetPath` AS `documentPath`,
		`marksheet_job_sub_level`.`marksheetJobSubLevelName` AS `documentName`,
		`marksheet_job_sub_level`.`publishDate` AS `publishDate`
	FROM
		((`marksheet_job_details`
		LEFT JOIN `marksheet_job_sub_level` ON ((`marksheet_job_details`.`marksheetJobSubLevelId` = `marksheet_job_sub_level`.`id`)))
		LEFT JOIN `admission` ON ((`marksheet_job_details`.`admissionId` = `admission`.`id`)))
	WHERE
		(`marksheet_job_details`.`isPublishMarksheet` = 1)
		Union select
		FUNC_INC_VAR_SESSION() AS `Id`,
		`evaluation_group_marksheet_details`.`admissionId` AS `admissionId`,
		`admission`.`studentId` AS `studentId`,
		'MARKSHEET' AS `reportType`,
		`evaluation_group_marksheet_details`.`marksheetPath` AS `documentName`,
		`evaluation_group_marksheet_details`.`marksheetPath` AS `documentPath`,
		`evaluation_group_marksheet_details`.`publishDate` AS `publishDate`
	FROM
		((`evaluation_group_marksheet`
		LEFT JOIN `evaluation_group_marksheet_details` ON ((`evaluation_group_marksheet`.`id` = `evaluation_group_marksheet_details`.`evaluationGroupMarksheetId`)))
		LEFT JOIN `admission` ON ((`evaluation_group_marksheet_details`.`admissionId` = `admission`.`id`)))
	WHERE
		(`evaluation_group_marksheet_details`.`isPublishMarksheet` = 1);
