DELIMITER ;
CREATE TABLE `applicant_person_contact_history` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `mobileNumber` varchar(15) DEFAULT NULL,
  `mobileCountryCode` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `fk_applicant_person_contact_history_personId_idx` (`applicantPersonId`),
  CONSTRAINT `fk_applicant_person_contact_history_personId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DELIMITER //
CREATE DEFINER=`root`@`localhost` TRIGGER applicant_person_contact_history_after_insert_trigger 
   After INSERT ON applicant_person 
   FOR EACH ROW 
BEGIN
     INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode)
     VALUES(NEW.id,NEW.emailId,NEW.mobileNumber,NEW.mobileCountryCode);
END;//
DELIMITER ;
DELIMITER //
CREATE DEFINER=`root`@`localhost` TRIGGER applicant_person_contact_history_after_update_trigger 
   After UPDATE ON applicant_person 
   FOR EACH ROW 
BEGIN
	IF NEW.id = OLD.id and (NEW.emailId<> OLD.emailId or NEW.mobileNumber <> OLD.mobileNumber or NEW.mobileCountryCode <> OLD.mobileCountryCode)
	THEN
     INSERT INTO applicant_person_contact_history(applicantPersonId,emailId,mobileNumber,mobileCountryCode)
     VALUES(NEW.id,NEW.emailId,NEW.mobileNumber,NEW.mobileCountryCode);
     END IF;
END;//
DELIMITER ;
