CREATE TABLE `evaluation_plan_programs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `period_section_unique_type_program` (`evaluationPlanId`,`periodId`),
  KEY `evaluation_plan_programs_planId` (`evaluationPlanId`),
  KEY `evaluation_plan_programs_periodId` (`periodId`),
  KEY `evaluation_plan_programs_userId` (`lastUpdatedBy`),
  CONSTRAINT `evaluation_plan_programs_planId` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `evaluation_plan_programs_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `evaluation_plan_programs_userId` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;