-- Creare Gallery Tables 

CREATE TABLE IF NOT EXISTS  `gallery` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `albumName` VARCHAR(60) NOT NULL DEFAULT 'Album',
  `description` VARCHAR(255) NULL DEFAULT NULL,
  `createdDate` TIMESTAMP NULL DEFAULT NULL,
  `createdBy` BIGINT(20) NULL DEFAULT NULL,
  `academyLocationId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_gallery_created_by_idx` (`createdBy` ASC),
  INDEX `fk_gallery_lastUpdated_by_idx` (`lastUpdatedBy` ASC),
   INDEX `fk_gallery_academyLocationId_idx` (`academyLocationId` ASC),
  CONSTRAINT `fk_gallery_created_by`
	FOREIGN KEY (`createdBy`)
	REFERENCES  `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_gallery_lastUpdated_by`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES  `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_gallery_academyLocationId`
	FOREIGN KEY (`academyLocationId`)
	REFERENCES  `academy_location` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION); 



CREATE TABLE IF NOT EXISTS  `gallery_images` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `galleryId` BIGINT(20) NOT NULL,
  `imageName` VARCHAR(45) NOT NULL DEFAULT 'Image',
  `path` VARCHAR(255) NULL DEFAULT NULL,
  `sequenceNo` int(11) DEFAULT NULL,
  `uploadedDate` TIMESTAMP NULL DEFAULT NULL,
  `uploadedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_gallery_images_galleryId_idx` (`galleryId` ASC),
  INDEX `fk_gallery_images_uploaded_by_idx` (`uploadedBy` ASC),
  INDEX `fk_gallery_images_lastUpdatedby_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_gallery_images_galleryId`
	FOREIGN KEY (`galleryId`)
	REFERENCES  `gallery` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_gallery_images_uploadedby`
	FOREIGN KEY (`uploadedBy`)
	REFERENCES  `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `fk_gallery_images_lastUpdatedby`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES   `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);


CREATE TABLE IF NOT EXISTS `gallery_batch_mapping` (
	  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	  `galleryId` BIGINT(20) NOT NULL,
	  `batchId` BIGINT(20) NOT NULL,
	  `isSharedWithFaculty` BIT(1) NULL DEFAULT b'0',
	  `isSharedWithStudent` BIT(1) NULL DEFAULT b'0',
	  `sharedDate` TIMESTAMP NULL DEFAULT NULL,
	  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
	  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	  PRIMARY KEY (`id`),
	  INDEX `fk_gallery_batch_mapping_galleryId_idx` (`galleryId` ASC),
	  INDEX `fk_gallery_batch_mapping_batchId_idx` (`batchId` ASC),
	  INDEX `fk_gallery_batch_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
	  UNIQUE INDEX `galleryId_batchId_unique` (`galleryId` ASC, `batchId` ASC),
	  CONSTRAINT `fk_gallery_batch_mapping_galleryId`
		FOREIGN KEY (`galleryId`)
		REFERENCES `gallery` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION,
	  CONSTRAINT `fk_gallery_batch_mapping_batchId`
		FOREIGN KEY (`batchId`)
		REFERENCES `batches` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION,
	  CONSTRAINT `fk_gallery_batch_mapping_lastUpdatedBy`
		FOREIGN KEY (`lastUpdatedBy`)
		REFERENCES  `users` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION);