CREATE TABLE IF NOT EXISTS `email_domain_configuration` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`domain` VARCHAR(255) NOT NULL,
	`controlType` VARCHAR(255) NOT NULL,	
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

-- Email Domain Configuration
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'email_domain_configuration','EMAIL_DOMAIN_CONFIGURATION','Email','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'domain', 'DOMAIN_VALUE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
insert into standard_master_items (id,`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`)
values(@ItemsMaxId+1,'controlType','CONTROL_TYPE',@standardMasterMaxId+1,'Enum','control_type','2',false,b'0',b'0',false,1);


SET @pickListEnumMaxId=(SELECT MAX(id) FROM picklist_enum);
INSERT INTO `picklist_enum` (`id`, `enumType`, `code`, `enumValue`) VALUES(@pickListEnumMaxId+1,'control_type','ALLOWED','Allowed');
INSERT INTO `picklist_enum` (`id`, `enumType`, `code`, `enumValue`) VALUES(@pickListEnumMaxId+2,'control_type','BLOCKLIST','BlockList');