DROP procedure IF EXISTS `sp_map_previous_discount`;

DELIMITER $$
CREATE PROCEDURE `sp_map_previous_discount`()
BEGIN

DECLARE done INTEGER DEFAULT 0;
declare var_feePlanTypeId, var_feeStageMasterId, var_discountMasterId int;

DEClARE cursor_map_prev_discount CURSOR FOR SELECT feePlanTypeId, feeStageMasterId, discountMasterId FROM fee_plan_type_stage where feeStageHeadConfigId is null;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;

OPEN cursor_map_prev_discount;
proc_map_prev_discount: LOOP
FETCH cursor_map_prev_discount INTO var_feePlanTypeId, var_feeStageMasterId, var_discountMasterId;

IF done = 1 THEN 
LEAVE proc_map_prev_discount;
END IF;

insert into fee_plan_type_stage(feePlanTypeId, feeStageMasterId, discountMasterId, feeStageHeadConfigId, lastUpdate, lastUpdatedBy)
SELECT var_feePlanTypeId, var_feeStageMasterId, var_discountMasterId, fshc.id, now(), 1 FROM fee_stage_head_config fshc 
LEFT OUTER JOIN fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
LEFT OUTER JOIN fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
LEFT OUTER JOIN fee_plan fp ON fp.id = fpr.feePlanId
LEFT OUTER JOIN fee_plan_type fpt ON fpt.id = fp.feePlanType
LEFT OUTER JOIN fee_stage_master fsm ON fsm.id = fprs.stageId
WHERE fpt.id = var_feePlanTypeId AND fsm.id = var_feeStageMasterId AND fshc.isActive = 1 AND fshc.payableDiscountFeeHeadId is null
AND fshc.whetherPayableDiscount = 0 AND fp.feePlanStatus='ACTIVE' AND fpr.status='ACTIVE';

END LOOP proc_map_prev_discount;

CLOSE cursor_map_prev_discount;

select 'data inserted';
END$$

DELIMITER ;