CREATE TABLE `examination_report_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `admissionId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `levelName` varchar(255) NOT NULL,
  `reportType` varchar(60) NULL DEFAULT NULL,
  `documentName` varchar(255) NOT NULL,
  `documentPath` varchar(512) NOT NULL,
  `isPublish` bit(1) NOT NULL DEFAULT b'0',
  `publishDate` Date NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `examination_report_document_fk1_idx` (`admissionId`),
  KEY `examination_report_document_2_idx` (`periodId`),
  KEY `examination_report_document_fk3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_examination_report_document_1` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_examination_report_document_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_examination_report_document_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP PROCEDURE IF EXISTS student_publish_data;

DELIMITER $$
CREATE PROCEDURE student_publish_data(IN instudentId BIGINT(20), IN firstResult INT(11), IN maxResult INT(11))

BEGIN

START TRANSACTION;
if firstResult is null then set firstResult = 0; end if;
if maxResult is null then set maxResult = 1000; end if;

BLOCK1: BEGIN
-- Hall ticket data
	SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        hallTicket.admissionId AS admissionId,
        admission.studentId AS studentId,
        hallTicket.reportType AS reportType,
        hallTicket.hallTicketPath AS documentPath,
        hallTicket.hallTicketNumber AS documentName,
        DATE_FORMAT(hallTicket.lastUpdate,'%Y-%m-%d') AS publishDate
		FROM eval_group_hall_ticket as hallTicket
        JOIN admission ON hallTicket.admissionId = admission.id
		WHERE
        hallTicket.isPublishHallTicket = true
            AND hallTicket.reportType = 'HALL_TICKET' 
            AND admission.studentId= instudentId
            
-- Marksheet data 
	UNION SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        jobDetails.admissionId AS admissionId,
        admission.studentId AS studentId,
        'MARKSHEET' AS reportType,
        jobDetails.marksheetPath AS documentPath,
        subLevel.marksheetJobSubLevelName AS documentName,
        subLevel.publishDate AS publishDate
    FROM marksheet_job_details as jobDetails
        JOIN marksheet_job_sub_level as subLevel ON jobDetails.marksheetJobSubLevelId = subLevel.id
        JOIN admission ON jobDetails.admissionId = admission.id
    WHERE
        jobDetails.isPublishMarksheet = true
        AND admission.studentId= instudentId
        
-- Evaluation Group marksheet data        
    UNION SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        details.admissionId AS admissionId,
        admission.studentId AS studentId,
        'MARKSHEET' AS reportType,
        details.marksheetPath AS documentPath,
        details.marksheetPath AS documentName,
        details.publishDate AS publishDate
    FROM
        evaluation_group_marksheet as markSheet
        JOIN evaluation_group_marksheet_details as details ON markSheet.id = details.evaluationGroupMarksheetId
        JOIN admission ON details.admissionId = admission.id
    WHERE
        details.isPublishMarksheet = true
        AND admission.studentId= instudentId

-- Exam report document data        
    UNION SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        examDoc.admissionId AS admissionId,
        admission.studentId AS studentId,
        examDoc.reportType AS reportType,
        examDoc.documentPath AS documentPath,
        examDoc.documentName AS documentName,
        examDoc.publishDate AS publishDate
    FROM
        examination_report_document as examDoc
        JOIN admission ON examDoc.admissionId = admission.id
    WHERE
        examDoc.isPublish = true
        AND admission.studentId= instudentId
        LIMIT firstResult, maxResult;
 END BLOCK1;

COMMIT;    
END$$
DELIMITER ;

