DROP procedure IF EXISTS `SP_DELETE_EVALUATION_TYPE_PROGRAM`;

DELIMITER $$
CREATE PROCEDURE `SP_DELETE_EVALUATION_TYPE_PROGRAM`(IN evalTypeProgId varchar(2000))
BEGIN

set @examResultRowCount='1';
set @sql = concat("SELECT 
        COUNT(DISTINCT result.id) INTO @examResultRowCount
    FROM
        examination_result AS result
    INNER JOIN eval_seq_detail event ON result.evaluationDetailSequenceId = event.id
    INNER JOIN evaluation_sequence AS method ON event.evalSequenceId = method.id
    INNER JOIN evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
    INNER JOIN evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
    INNER JOIN evaluation_type_program AS etp on etp.evaluationPlanId=type.evaluationPlanId AND result.sectionId=etp.sectionId 
												AND result.periodId=etp.programBatchPeriodConfigId
    
    WHERE
        result.courseVariantId IS NULL
        AND (result.finalMarks IS NOT NULL OR result.finalGrade IS NOT NULL)
		AND etp.id IN (", evalTypeProgId,")");
        
    PREPARE stmt FROM @sql;
    EXECUTE stmt;
        
if (@examResultRowCount >0) then
select false;

else 

set @sql = concat("DELETE result

    FROM
        examination_result AS result
    INNER JOIN eval_seq_detail event ON result.evaluationDetailSequenceId = event.id
    INNER JOIN evaluation_sequence AS method ON event.evalSequenceId = method.id
    INNER JOIN evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
    INNER JOIN evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
    INNER JOIN evaluation_type_program AS etp on etp.evaluationPlanId=type.evaluationPlanId AND result.sectionId=etp.sectionId 
												AND result.periodId=etp.programBatchPeriodConfigId
    
    WHERE
        result.courseVariantId IS NULL
		AND etp.id IN (", evalTypeProgId,")");
        
    PREPARE stmt FROM @sql;
    EXECUTE stmt;

set @sql = concat("DELETE FROM evaluation_type_program where id IN (", evalTypeProgId,")");
        
    PREPARE stmt FROM @sql;
    EXECUTE stmt;  
select true;
END IF;
END$$

DELIMITER ;