
-- Create a new table
CREATE TABLE `course_variant_event_mapping` (
 `id` bigint(20) NOT NULL AUTO_INCREMENT,
 `eventId` bigint(20) NOT NULL,
 `evaluationTypeCourseId` bigint(20) DEFAULT NULL,
 `evaluationTypeProgramId` bigint(20) DEFAULT NULL,
 `eventStatus` varchar(45) NOT NULL DEFAULT 'PENDING',
 `lastUpdatedBy` bigint(20) NOT NULL,
 `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 UNIQUE KEY `event_mapping_unique_typeCourse` (`eventId`,`evaluationTypeCourseId`),
 UNIQUE KEY `event_mapping_unique_typeProgram` (`eventId`,`evaluationTypeProgramId`),
 KEY `event_mapping_eventId` (`eventId`),
 KEY `event_mapping_evaluationTypeCourseId` (`evaluationTypeCourseId`),
 KEY `event_mapping_evaluationTypeProgramId` (`evaluationTypeProgramId`),
 KEY `event_mapping_lastUpdatedBy` (`lastUpdatedBy`),
 CONSTRAINT `event_mapping_evaluationTypeCourseId` FOREIGN KEY (`evaluationTypeCourseId`) REFERENCES `evaluation_type_course` (`id`),
 CONSTRAINT `event_mapping_evaluationTypeProgramId` FOREIGN KEY (`evaluationTypeProgramId`) REFERENCES `evaluation_type_program` (`id`),
 CONSTRAINT `event_mapping_eventId` FOREIGN KEY (`eventId`) REFERENCES `eval_seq_detail` (`id`),
 CONSTRAINT `event_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- To Insert old event and course variant data into new table
INSERT INTO course_variant_event_mapping (eventId,evaluationTypeCourseId,evaluationTypeProgramId,eventStatus,lastUpdatedBy,lastUpdate)
SELECT 
    event.id AS EventId, evalTypeCourse.id AS EvalTypeCourseId, null as EvalTypeProgId,  event.status, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_course AS evalTypeCourse ON plan.id = evalTypeCourse.evaluationPlanId
    order by plan.id,  event.id , evalTypeCourse.id;
    

-- To Insert old event and section data into new table    
INSERT INTO course_variant_event_mapping (eventId,evaluationTypeCourseId,evaluationTypeProgramId,eventStatus,lastUpdatedBy,lastUpdate)
SELECT 	
    event.id AS EventId, null as EvalTypeCourseId,  evalTypeProg.id as EvalTypeProgId, event.status, 1, now()
FROM
    eval_seq_detail AS event
        INNER JOIN
    evaluation_sequence AS method ON event.evalSequenceId = method.id
        INNER JOIN
    evaluation_plan_level_two AS subType ON method.evalPlanLevelTwoId = subType.id
        INNER JOIN
    evaluation_plan_level_one AS type ON subType.evalPlanLevelOneId = type.id
        INNER JOIN
    evaluation_plan AS plan ON type.evaluationPlanId = plan.id
        INNER JOIN
    evaluation_type_program AS evalTypeProg ON plan.id = evalTypeProg.evaluationPlanId
    
    order by plan.id,  event.id , evalTypeProg.id;
    