CREATE OR REPLACE VIEW `student_list_view` AS
    SELECT 
        `T1`.`userId` AS `ID`,
        `T6`.`photoUrl` AS `PERSON_IMAGE`,
        `T1`.`personId` AS `PERSON_ID`,
        `T1`.`userId` AS `APPLICATION_ID`,
        `T3`.`code` AS `ADMISSION_NUMBER`,
        `T2`.`code` AS `STUDENT_ID`,
        `T6`.`printName` AS `STUDENT_NAME`,
        `T6`.`firstName` AS `FIRST_NAME`,
        `T6`.`middleName` AS `MIDDLE_NAME`,
        `T6`.`lastName` AS `LAST_NAME`,
        `T6`.`shortName` AS `SHORT_NAME`,
        `T92`.`categoryName` AS `PROGRAM_CATEGORY`,
        `T71`.`programName` AS `PROGRAM_NAME`,
        `T71`.`id` AS `PROGRAM_ID`,
        `T70`.`batchName` AS `BATCH_NAME`,
        `T65`.`programPeriodName` AS `PROGRAM_PERIOD_NAME_NEW`,
        `T10`.`sectionCode` AS `SECTION_CODE`,
        `T93`.`itemValue` AS `INTAKE_YEAR`,
        `T6`.`emailId` AS `EMAIL_ID`,
        `T6`.`alternateEmailId` AS `ALTERNATE_EMAIL_ID`,
        `T6`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `T6`.`mobileNumber` AS `MOBILE_NUMBER`,
        `T25`.`itemValue` AS `RELIGION`,
        `T22`.`itemValue` AS `CASTE_CATEGORY`,
        `T66`.`progBatchSeatConfigId` AS `PROGRAM_BATCH_SEAT_CONFIG_ID`,
        `T3`.`id` AS `ADMISSION_ID`,
        `T70`.`id` AS `PROGRAM_BATCH_ID`,
        `T2`.`id` AS `USER_ID`,
        `T16`.`academyName` AS `ACADEMY_NAME`,
        `T16`.`locationName` AS `LOCATION_NAME`,
        `T100`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `T3`.`status` AS `ADMISSION_STATUS`,
        `T3`.`admissionDate` AS `ADMISSION_DATE`,
        `T70`.`startDate` AS `BATCH_SRART_DATE`,
        `T3`.`activeStatus` AS `STATUS`,
        `T70`.`tillDate` AS `BATCH_TILL_DATE`,
        `T6`.`birthDate` AS `DATE_OF_BIRTH`,
        `T6`.`gender` AS `GENDER`,
        `T18`.`firstName` AS `FATHERS_FULL_NAME`,
        `T18`.`firstName` AS `FATHERS_FIRST_NAME`,
        `T18`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `T18`.`lastName` AS `FATHERS_LAST_NAME`,
        `T18`.`emailId` AS `FATHERS_EMAIL_ID`,
        `T18`.`mobileNumber` AS `FATHERS_MOBILE_NUMBER`,
        `T18`.`mobileCountryCode` AS `FATHERS_MOBILE_COUNTRY_CODE`,
        `T30`.`firstName` AS `MOTHERS_FULL_NAME`,
        `T30`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `T30`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `T30`.`lastName` AS `MOTHERS_LAST_NAME`,
        `T30`.`emailId` AS `MOTHERS_EMAIL_ID`,
        `T30`.`mobileNumber` AS `MOTHERS_MOBILE_NUMBER`,
        `T21`.`firstName` AS `GUARDIAN_FULL_NAME`,
        `T30`.`mobileCountryCode` AS `MOTHERS_MOBILE_COUNTRY_CODE`,
        `T21`.`firstName` AS `GUARDIAN_FIRST_NAME`,
        `T21`.`middleName` AS `GUARDIAN_MIDDLE_NAME`,
        `T21`.`lastName` AS `GUARDIAN_LAST_NAME`,
        `T21`.`emailId` AS `GUARDIAN_EMAIL_ID`,
        `T21`.`mobileNumber` AS `GUARDIAN_MOBILE_NUMBER`,
        `T21`.`mobileCountryCode` AS `GUARDIAN_MOBILE_COUNTRY_CODE`,
        `T60`.`addressText` AS `ADDRESS`,
        `T61`.`cityName` AS `CITY_NAME`,
        `T91`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `T62`.`countryName` AS `COUNTRY_NAME`,
        `T23`.`itemValue` AS `NATIONALITY`,
        `T97`.`value` AS `HOME_LANGUAGE`,
        `T99`.`salutationName` AS `FATHERS_SALUTATION_NAME`,
        `T72`.`seatName` AS `SEAT_TYPE`,
        `T6`.`birthDate` AS `AGE`,
        `T6`.`nationalID` AS `NATIONAL_ID`,
        `T101`.`printName` AS `ADVISOR_NAME`,
        `T1`.`userId` AS `APPLICATION_CREATION_SOURCE`,
        `T102`.`salutationName` AS `GUARDIAN_SALUTATION_NAME`,
        `T98`.`salutationName` AS `MOTHERS_SALUTATION_NAME`,
        `T16`.`id` AS `ACADEMY_LOCATION_ID`
    FROM
        ((((((((((((((((((((((((((((((((((`students` `T1`
        LEFT JOIN `users` `T2` ON ((`T1`.`userId` = `T2`.`id`)))
        LEFT JOIN `persons` `T6` ON ((`T6`.`id` = `T1`.`personId`)))
        LEFT JOIN `admission` `T3` ON ((`T3`.`studentId` = `T1`.`userId`)))
        LEFT JOIN `user_academy_locations` `T15` ON (((`T2`.`id` = `T15`.`userId`)
            AND (`T15`.`whetherPrimary` = 1))))
        LEFT JOIN `person_relationships` `T20` ON (((`T6`.`id` = `T20`.`personId`)
            AND (`T20`.`relationship` = 'GUARDIAN')
            AND (`T20`.`whetherDeleted` = 0))))
        LEFT JOIN `person_relationships` `T17` ON (((`T6`.`id` = `T17`.`personId`)
            AND (`T17`.`relationship` = 'FATHER')
            AND (`T17`.`whetherDeleted` = 0))))
        LEFT JOIN `person_relationships` `T29` ON (((`T6`.`id` = `T29`.`personId`)
            AND (`T29`.`relationship` = 'MOTHER')
            AND (`T29`.`whetherDeleted` = 0))))
        LEFT JOIN `users` `T101` ON ((`T101`.`id` = `T6`.`advisorId`)))
        LEFT JOIN `student_hostel_requirement` `T100` ON (((`T100`.`personId` = `T6`.`id`)
            AND (`T100`.`whetherDeleted` = 0))))
        LEFT JOIN `nationalities` `T23` ON ((`T6`.`nationalityId` = `T23`.`id`)))
        LEFT JOIN `person_addresses` `T59` ON (((`T59`.`personId` = `T6`.`id`)
            AND (`T59`.`whetherPrimary` = 1)
            AND (`T59`.`whetherDeleted` = 0))))
        LEFT JOIN `religions` `T25` ON ((`T6`.`religionId` = `T25`.`id`)))
        LEFT JOIN `caste_categories` `T22` ON ((`T6`.`castCategoryId` = `T22`.`id`)))
        LEFT JOIN `drop_down` `T97` ON ((`T6`.`homeLanguage` = `T97`.`id`)))
        LEFT JOIN `program_batch_students` `T66` ON (((`T66`.`admissionId` = `T3`.`id`)
            AND (`T66`.`isCurrentSection` = 1)
            AND (`T66`.`isCurrentPeriod` = 1))))
        LEFT JOIN `academy_location` `T16` ON ((`T16`.`id` = `T15`.`academyLocationId`)))
        LEFT JOIN `persons` `T21` ON (((`T21`.`id` = `T20`.`relatedPersonId`)
            AND (`T20`.`relationship` = 'GUARDIAN')
            AND (`T20`.`whetherDeleted` = 0))))
        LEFT JOIN `persons` `T18` ON (((`T18`.`id` = `T17`.`relatedPersonId`)
            AND (`T17`.`relationship` = 'FATHER')
            AND (`T18`.`whetherDeleted` = 0))))
        LEFT JOIN `persons` `T30` ON (((`T30`.`id` = `T29`.`relatedPersonId`)
            AND (`T29`.`relationship` = 'MOTHER')
            AND (`T29`.`whetherDeleted` = 0))))
        LEFT JOIN `address` `T60` ON ((`T60`.`id` = `T59`.`addressId`)))
        LEFT JOIN `prog_batch_seat_config` `T74` ON ((`T74`.`id` = `T66`.`progBatchSeatConfigId`)))
        LEFT JOIN `prog_batch_period_config` `T65` ON ((`T65`.`id` = `T66`.`progBatchPeriodConfigId`)))
        LEFT JOIN `sections` `T10` ON ((`T10`.`id` = `T66`.`sectionId`)))
        LEFT JOIN `salutations` `T102` ON ((`T102`.`id` = `T21`.`salutationId`)))
        LEFT JOIN `salutations` `T99` ON ((`T99`.`id` = `T18`.`salutationId`)))
        LEFT JOIN `salutations` `T98` ON ((`T98`.`id` = `T30`.`salutationId`)))
        LEFT JOIN `city` `T61` ON ((`T61`.`id` = `T60`.`cityId`)))
        LEFT JOIN `seat_types` `T72` ON ((`T72`.`id` = `T74`.`seatTypeId`)))
        LEFT JOIN `batches` `T70` ON ((`T70`.`id` = `T65`.`programBatchId`)))
        LEFT JOIN `country` `T62` ON ((`T62`.`id` = `T61`.`countryId`)))
        LEFT JOIN `country_region` `T91` ON ((`T91`.`id` = `T61`.`countryRegionId`)))
        LEFT JOIN `programs` `T71` ON ((`T71`.`id` = `T70`.`programId`)))
        LEFT JOIN `intake_year` `T93` ON ((`T93`.`id` = `T70`.`intakeYearId`)))
        LEFT JOIN `program_category` `T92` ON ((`T92`.`id` = `T71`.`programCategoryId`)))
    WHERE
        ((`T2`.`status` = 1)
            AND (`T3`.`activeStatus` = 1))