/* */
set sql_safe_updates=0;
CREATE OR REPLACE VIEW `exam_wise_report_view` AS SELECT DISTINCT
    al.displayName AS 'Brand',
    al.locationName AS 'Campus',
    pg.groupName AS 'School Phase',
    al.id AS 'Academy_Location_Id',
    prgm.programNameToBePrint AS 'Grade',
    pc.categoryName AS 'Grade Category',
    batch.printName AS 'Intake',
    period.printName AS 'Period',
    admission.id AS 'ADmission',
    person.printName AS 'Student Name',
    usr.code AS 'Student Id',
    course.nameToBePrinted AS 'Subject',
    cv.courseVariantCode AS 'Subject Variant',
    cc.categoryName AS 'Subject Category',
    fac.printName AS 'Teacher',
    plan.evaluationPlanNumber AS 'Scheme',
    planRank.marksObtainedFrom AS 'Maximum Marks',
    planRank.effectiveMarks AS 'Subject Level Marks',
    planRank.grade AS 'Subject Grade',
    planRank.effectiveMarks AS 'Percentage',
    planRank.status AS 'Plan Rank Result Status',
    type.printNameInMarksheet AS 'Type',
    typeRank.effectiveMarks AS 'Type Marks',
    typeRank.grade AS 'Type Grade',
    typeRank.status AS 'Type Rank Result Status',
    subType.printNameInMarksheet AS 'Sub Type',
    subTypeRank.effectiveMarks AS 'Sub Type Marks',
    subTypeRank.grade AS 'Sub Type Grade',
    subTypeRank.status AS 'Sub Type Result Status',
    method.printNameInMarksheet AS 'Method',
    methodRank.effectiveMarks AS 'Method Marks',
    methodRank.grade AS 'Method Grade',
    methodRank.status AS 'Result Status',
    CASE WHEN evntDetail.eventName is null then evnt.detailSequenceNumber
		 WHEN evntDetail.eventName is not null then evntDetail.eventName
	     ELSE null END AS 'Event',
    result.effectiveMarks AS 'Event Marks',
    result.finalGrade AS 'Event Grade'
FROM
    examination_result AS result
        INNER JOIN
    admission AS admission ON admission.id = result.admissionId
        INNER JOIN
    students AS stu ON stu.userId = admission.studentId
        INNER JOIN
    persons AS person ON person.id = stu.personId
        INNER JOIN
    users AS usr ON usr.id = stu.userId
        INNER JOIN
    academy_location AS al ON al.id = admission.academyLocationId
        INNER JOIN
    prog_batch_period_config AS period ON period.id = result.periodId
        INNER JOIN
    batches AS batch ON batch.id = period.programBatchId
        INNER JOIN
    programs AS prgm ON prgm.id = batch.programId
        LEFT OUTER JOIN
    program_group AS pg ON pg.id = prgm.programGroupId
        LEFT OUTER JOIN
    program_category AS pc ON pc.id = prgm.programCategoryId
        LEFT OUTER JOIN
    course_variants AS cv ON cv.id = result.courseVariantId
        LEFT OUTER JOIN
    courses AS course ON course.id = cv.courseId
        LEFT OUTER JOIN
    course_category AS cc ON cc.id = course.courseCategoryId
        INNER JOIN
    eval_seq_detail AS evnt ON evnt.id = result.evaluationDetailSequenceId
        INNER JOIN
    evaluation_sequence AS method ON method.id = evnt.evalSequenceId
        INNER JOIN
    sequence_header AS header ON header.id = method.evalSequenceId
        INNER JOIN
    evaluation_plan_level_two AS subType ON subType.id = method.evalPlanLevelTwoId
        INNER JOIN
    evaluation_plan_level_one AS type ON type.id = subType.evalPlanLevelOneId
        INNER JOIN
    evaluation_plan AS plan ON plan.id = type.evaluationPlanId
        LEFT OUTER JOIN
    evaluation_sequence_rank AS methodRank ON methodRank.evaluationSequenceId = method.id
        AND result.admissionId = methodRank.admissionId
        AND result.courseVariantId=methodRank.courseVariantId
        AND result.periodId = methodRank.periodId
        LEFT OUTER JOIN
    evaluation_plan_level_two_rank AS subTypeRank ON subTypeRank.evaluationPlanLevelTwoId = subType.id
        AND result.admissionId = subTypeRank.admissionId
        AND result.courseVariantId=subTypeRank.courseVariantId
        AND result.periodId = subTypeRank.periodId
        LEFT OUTER JOIN
    evaluation_plan_level_one_rank AS typeRank ON typeRank.evaluationPlanLevelOneId = type.id
        AND result.admissionId = typeRank.admissionId
        AND result.courseVariantId=typeRank.courseVariantId
        AND result.periodId = typeRank.periodId
        LEFT OUTER JOIN
    evaluation_plan_rank AS planRank ON planRank.evaluationPlanId = plan.id
        AND result.admissionId = planRank.admissionId
        AND result.courseVariantId=planRank.courseVariantId
        AND result.periodId = planRank.periodId
        LEFT OUTER JOIN
    program_batch_course_param AS param ON param.courseVarientId = result.courseVariantId and result.periodId=param.progBatchPeriodConfigId
        LEFT OUTER JOIN
    prog_batch_course_faculty AS pbcf ON pbcf.progBatchCourseParamId = param.id
        LEFT OUTER JOIN
    users AS fac ON fac.id = pbcf.facultyId
        LEFT OUTER JOIN
    evaluation_type_course typeCourse ON result.courseVariantId = typeCourse.courseVariantId
        AND typeCourse.periodId = result.periodId
        LEFT OUTER JOIN
    exam_event_detail evntDetail ON result.evaluationDetailSequenceId = evntDetail.eventId
        AND evntDetail.evaluationTypeCourseId = typeCourse.id
	where result.examResultStatus is not null
 ORDER BY al.locationName ASC, pg.groupName ASC , prgm.programNameToBePrint ASC ,
pc.categoryName ASC , batch.printName ASC , period.printName ASC , person.printName ASC;
set sql_safe_updates=1;

