DELIMITER $$

DROP PROCEDURE IF EXISTS insert_enrollment_ui_translation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE insert_enrollment_ui_translation()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'COURSETX' and keyName = 'STUDENTS_BACKLOG_ENROLLED_CONFIRM_MESSAGE')) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('COURSETX','STUDENTS_BACKLOG_ENROLLED_CONFIRM_MESSAGE','There are some repeat and backlog courses for the selected student. Do you still want to continue with the selected regular courses?','There are some repeat and backlog courses for the selected student. Do you still want to continue with the selected regular courses?',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL insert_enrollment_ui_translation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS insert_enrollment_ui_translation $$
 
DELIMITER ;