DELIMITER $$

DROP PROCEDURE IF EXISTS V202001021926_Insert_UITranslation_Citizenship $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001021926_Insert_UITranslation_Citizenship()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="CITIZENSHIP" )) THEN
    
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','CITIZENSHIP','Citizenship','Citizenship',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL V202001021926_Insert_UITranslation_Citizenship() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001021926_Insert_UITranslation_Citizenship $$
 
DELIMITER ;