DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071824__AlterGender $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071824__AlterGender()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND  table_name='gender' 
  AND column_name in('isDeletable','isEditable'))) THEN

    ALTER TABLE gender 
    ADD COLUMN `isDeletable` BIT(1) NOT NULL DEFAULT 1 AFTER `lastUpdatedBy`,
    ADD COLUMN `isEditable` BIT(1) NOT NULL DEFAULT 1 AFTER `isDeletable`;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001071824__AlterGender() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071824__AlterGender $$
 
DELIMITER ;