DELIMITER $$

DROP PROCEDURE IF EXISTS UITranslation_MarkEntryResultPublishSelectedRecordsRecords $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE UITranslation_MarkEntryResultPublishSelectedRecordsRecords()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='EXAMINATION' and keyName='MARK_ENTRY_RESULT_PUBLISH_SELECTED_RECORDS')) THEN
  
		UPDATE `ui_translation`  
			SET `defaultValue`='Marks Submitted Successfully, Are you sure you want to publish the result of selected records.',
			`customerDefineValue`='Marks Submitted Successfully, Are you sure you want to publish the result of selected records.'
		WHERE `keyName`='MARK_ENTRY_RESULT_PUBLISH_SELECTED_RECORDS' AND ID>0;
		  
  END IF;

END $$

-- Execute the stored procedure
CALL UITranslation_MarkEntryResultPublishSelectedRecordsRecords $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS UITranslation_MarkEntryResultPublishSelectedRecordsRecords $$
 
DELIMITER ;