DELIMITER $$

DROP PROCEDURE IF EXISTS AlterAcademyLocationForFooterUrl $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE AlterAcademyLocationForFooterUrl()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='academy_location' 
  AND column_name='footerUrl')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `academy_location` 
ADD COLUMN `footerUrl` VARCHAR(255) NULL DEFAULT NULL AFTER `headerUrl`;
  
  END IF;

END $$

-- Execute the stored procedure
CALL AlterAcademyLocationForFooterUrl() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS AlterAcademyLocationForFooterUrl $$
 
DELIMITER ;