DELIMITER $$

DROP PROCEDURE IF EXISTS V202001171348__UITranslation_ConcurrentLoginAllow $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001171348__UITranslation_ConcurrentLoginAllow()

BEGIN
 
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'CONCURRENT_LOGIN_ALLOW' )) THEN
   
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('TRANSLATIONS','CONCURRENT_LOGIN_ALLOW','Allow Concurrent Login','Allow Concurrent Login',now(),1);
   
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'NOT_ABLE_TO_LOGIN_DUE_TO_RESTRICTED_IP_ADDRESS' )) THEN

	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
    VALUES ('TRANSLATIONS','NOT_ABLE_TO_LOGIN_DUE_TO_RESTRICTED_IP_ADDRESS','User is restricted to Login on this IP Address','User is restricted to Login on this IP Address',now(),1);
   
  END IF;

END $$


-- Execute the stored procedure
CALL V202001171348__UITranslation_ConcurrentLoginAllow() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001171348__UITranslation_ConcurrentLoginAllow $$
 
DELIMITER ;