DELIMITER $$

DROP PROCEDURE IF EXISTS AlterPersonDataChanged $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE AlterPersonDataChanged()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='personal_data_to_be_changed' 
  AND column_name='genderId')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `personal_data_to_be_changed` 
	ADD COLUMN `genderId` BIGINT(20) NULL DEFAULT NULL AFTER `gender`,
	ADD INDEX `fk_personal_data_to_be_changed_genderCSM_idx` (`genderId` ASC);
	ALTER TABLE `personal_data_to_be_changed` 
	ADD CONSTRAINT `fk_personal_data_to_be_changed_genderCSM`
  FOREIGN KEY (`genderId`)
  REFERENCES `gender` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
  
  END IF;

END $$

-- Execute the stored procedure
CALL AlterPersonDataChanged $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS AlterPersonDataChanged $$
 
DELIMITER ;