DELIMITER $$
DROP PROCEDURE IF EXISTS V20200208114642__Insert_data_grid_seed_values $$
CREATE PROCEDURE V20200208114642__Insert_data_grid_seed_values()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName="UserList" and portalId=1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('UserList',1,
'[{"id":null,"columnName":"CODE","dataIndex":"code","columnVisibility":"HIDE","sequence":1,"mandatory":false},
{"id":null,"columnName":"USER_ID","dataIndex":"id","columnVisibility":"HIDE","sequence":2,"mandatory":false},
{"id":null,"columnName":"INTERNAL_WHETHER","dataIndex":"whetherInternal","columnVisibility":"HIDE","sequence":3,"mandatory":false},
{"id":null,"columnName":"FULL_NAME","dataIndex":"firstName","columnVisibility":"HIDE","sequence":4,"mandatory":false},
{"id":null,"columnName":"LAST_NAME","dataIndex":"lastName","columnVisibility":"REMOVE","sequence":5,"mandatory":false},
{"id":null,"columnName":"USER_GROUP_NAME","dataIndex":"userGroupName","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"ACADEMY_NAME","dataIndex":"academyName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"LOCATION_NAME","dataIndex":"locationName","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"CALENDAR_NAME","dataIndex":"calenderName","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"STATUS","dataIndex":"status","columnVisibility":"SHOW","sequence":10,"mandatory":false},
{"id":null,"columnName":"DEPARTMENT","dataIndex":"DEPARTMENT","columnVisibility":"SHOW","sequence":11,"mandatory":false},
{"id":null,"columnName":"ROLE","dataIndex":"ROLE","columnVisibility":"SHOW","sequence":12,"mandatory":false},
{"id":null,"columnName":"DATE_OF_EXIT","dataIndex":"exitDate","columnVisibility":"SHOW","sequence":13,"mandatory":true}]',now(),1);
END IF; 

IF NOT EXISTS ((select * from data_grid where gridName="Academia.view.campaignnew.CampaignNewGrid" and portalId=1)) THEN 
INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
('Academia.view.campaignnew.CampaignNewGrid',1,
'[{"id":null,"columnName":"Intake Year","dataIndex":"intakeYearValue","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"Mode Of Delivery","dataIndex":"modeofDelivery","columnVisibility":"HIDE","sequence":2,"mandatory":false},
{"id":null,"columnName":"Registration Type","dataIndex":"registrationType","columnVisibility":"HIDE","sequence":4,"mandatory":false},
{"id":null,"columnName":"Academy Location","dataIndex":"noOfAcademyLocCount","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"Campaign Type","dataIndex":"campaignType","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"Presentation Type","dataIndex":"presentationType","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"Presentation Sub Type","dataIndex":"presentationSubType","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"Campaign Name","dataIndex":"campaignName","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"status","dataIndex":"status","columnVisibility":"SHOW","sequence":10,"mandatory":false},
{"id":null,"columnName":"school","dataIndex":"noOfSchoolCount","columnVisibility":"SHOW","sequence":11,"mandatory":false},
{"id":null,"columnName":"Owner","dataIndex":"ownerPrintName","columnVisibility":"HIDE","sequence":12,"mandatory":false},
{"id":null,"columnName":"Created On","dataIndex":"createdOn","columnVisibility":"SHOW","sequence":13,"mandatory":false},
{"id":null,"columnName":"Start Date","dataIndex":"startDate","columnVisibility":"SHOW","sequence":14,"mandatory":false},
{"id":null,"columnName":"End Date","dataIndex":"endDate","columnVisibility":"SHOW","sequence":14,"mandatory":false},
{"id":null,"columnName":"No of Leads Captured","dataIndex":"noOfEnquiryCount","columnVisibility":"SHOW","sequence":14,"mandatory":false},
{"id":null,"columnName":"Conversion Rate %","dataIndex":"conversionRate","columnVisibility":"SHOW","sequence":14,"mandatory":false}]',now(),1);
END IF; 

END $$
CALL V20200208114642__Insert_data_grid_seed_values() $$
DROP PROCEDURE IF EXISTS V20200208114642__Insert_data_grid_seed_values $$
DELIMITER ;