DELIMITER $$

DROP PROCEDURE IF EXISTS UITranslationApplicantAppointmentEvent $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE UITranslationApplicantAppointmentEvent()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'MESSAGING_TRANSLATIONS' and keyName = 'APPLICANT_APPOINTMENT' )) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_APPOINTMENT','Applicant Appointment','Applicant Appointment',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'MESSAGING_TRANSLATIONS' and keyName = 'APPLICANT_APPOINTMENT_DL' )) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_APPOINTMENT_DL','Applicant Appointment DL','Applicant Appointment DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'MESSAGING_TRANSLATIONS' and keyName = 'APPLICANT_APPOINTMENT_RECIPIENT' )) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_APPOINTMENT_RECIPIENT','Applicant Appointment Recipient','Applicant Appointment Recipient',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'MESSAGING_TRANSLATIONS' and keyName = 'APPLICANT_CODE' )) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_CODE','Applicant Code','Applicant Code',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key` = 'APPLICANT_APPOINTMENT_RECIPIENT' )) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_APPOINTMENT_RECIPIENT', 'Applicant Appointment Recipient');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key` = 'APPLICANT_APPOINTMENT_DL' )) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_APPOINTMENT_DL', 'Applicant Appointment DL');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key` = 'APPLICANT_APPOINTMENT' )) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_APPOINTMENT', 'Applicant Appointment');
END IF;
END $$


-- Execute the stored procedure
CALL UITranslationApplicantAppointmentEvent() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS UITranslationApplicantAppointmentEvent $$
 
DELIMITER ; 