DELIMITER $$
DROP PROCEDURE IF EXISTS V20200321110421__Create_EventQuestionDetailsMapping $$
CREATE PROCEDURE V20200321110421__Create_EventQuestionDetailsMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='event_question_detail_mapping')) THEN 
CREATE TABLE `event_question_detail_mapping` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `questionDetailsId` BIGINT(20) NOT NULL,
    `correlationId` BIGINT(20) NOT NULL,
    `manageCourseOutComesId` BIGINT(20) NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    PRIMARY KEY (`id`),	
    UNIQUE KEY `question_detail_mapping_unique` (`questionDetailsId`,`manageCourseOutComesId`),
    KEY `fk_question_detail_mapping_questionDetailsId` (`questionDetailsId`),
    KEY `fk_question_detail_mapping_correlationId` (`correlationId`),
    KEY `fk_question_detail_mapping_manageCourseOutComesId` (`manageCourseOutComesId`),
    KEY `fk_question_detail_mapping_lastUpdatedBy` (`lastUpdatedBy`),
    CONSTRAINT `fk_question_detail_mapping_questionDetailsId` FOREIGN KEY (`questionDetailsId`)
        REFERENCES `exam_event_question_detail` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_question_detail_mapping_correlationId` FOREIGN KEY (`correlationId`)
        REFERENCES `obe_correlation_level` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_question_detail_mapping_manageCourseOutComesId` FOREIGN KEY (`manageCourseOutComesId`)
        REFERENCES `manage_course_outcomes` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION,
    CONSTRAINT `fk_question_detail_mapping_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE NO ACTION ON UPDATE NO ACTION
)  ENGINE=INNODB DEFAULT CHARSET=UTF8;

END IF; 

END $$
CALL V20200321110421__Create_EventQuestionDetailsMapping () $$ 
DROP PROCEDURE IF EXISTS V20200321110421__Create_EventQuestionDetailsMapping $$ 
DELIMITER ;