DELIMITER $$
DROP PROCEDURE IF EXISTS V20200508164925__Create_examQuCOmarks $$
CREATE PROCEDURE V20200508164925__Create_examQuCOmarks()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_question_courseoutcome_marks_detail' )) THEN 
CREATE TABLE `exam_question_courseoutcome_marks_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventQuestionDetailsMappingId` bigint(20) NOT NULL,
  `questionPaperStudentDetailsId` int(20) NOT NULL,
  `effectiveMaxMarks`double(6,2) NOT NULL,
  `effectiveMarks` double(6,2) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`eventQuestionDetailsMappingId`,`questionPaperStudentDetailsId`),
  KEY `fk_exam_question_courseoutcome_marks_detail_idx` (`lastUpdatedBy`),
  KEY `fk_exam_question_courseoutcome_marks_detail_idx1` (`eventQuestionDetailsMappingId`),
  KEY `fk_exam_question_courseoutcome_marks_detail_idx2` (`questionPaperStudentDetailsId`),
 CONSTRAINT `fk_exam_question_courseoutcome_marks_detail_mapping` FOREIGN KEY (`eventQuestionDetailsMappingId`) REFERENCES `event_question_detail_mapping` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_question_courseoutcome_marks_detail_student` FOREIGN KEY (`questionPaperStudentDetailsId`) REFERENCES `question_paper_student_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_exam_question_courseoutcome_marks_detail_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200508164925__Create_examQuCOmarks () $$ 
DROP PROCEDURE IF EXISTS V20200508164925__Create_examQuCOmarks $$ 
DELIMITER ;