DELIMITER $$
DROP PROCEDURE IF EXISTS V20200508194547__Insert_Insert_AuReceiptReport $$
CREATE PROCEDURE V20200508194547__Insert_Insert_AuReceiptReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'AUM_RECEIPT_WITH_SETTLEMENT' )) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('4', 'AUM_RECEIPT_WITH_SETTLEMENT', 'AU Multicurrency Receipt with settlement - Triplicate', 'SettlementTriplicateCollege.png', 'CommonReport_LandScape_pageNo_LeftCenterRight.jasper', 'All', '1', 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', '0', '0', 'AuReceiptReport1.jasper', 'AcademiaLogo.png');
set @d1ReceiptSettle = (select max(id) from report_template where templateCode ='AUM_RECEIPT_WITH_SETTLEMENT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@d1ReceiptSettle , 'TRANS_RECEIPTNO', 'Receipt No.', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_DATE', 'Date', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_RECEIVED_FROM', 'Received From', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_FATHER_NAME', 'Father Name', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_ID', 'Id', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_ACADEMY_NAME', 'Academy Name', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_PROCESSED_BY', 'Processed By', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_REMARK', 'Remark', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_SR_NO', 'Sr. No.', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_PARTICULAR', 'Particular', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@d1ReceiptSettle , 'TRANS_BANK_NAME', 'Bank Name', '1', NOW());


END IF; 

END $$
CALL V20200508194547__Insert_Insert_AuReceiptReport() $$
DROP PROCEDURE IF EXISTS V20200508194547__Insert_Insert_AuReceiptReport $$
DELIMITER ;